/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.path.CompiledPath;
import com.jayway.jsonpath.internal.path.PathCompiler;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.util.HashMap;
import org.apache.eventmesh.common.exception.EventMeshException;
import org.apache.eventmesh.common.exception.JsonException;

public class JsonPathUtils {
    public static final String JSONPATH_SPLIT = "\\.";
    public static final String JSONPATH_PREFIX = "$";
    public static final String JSONPATH_PREFIX_WITH_POINT = "$.";
    public static final String JSONPATH_DATA = "$.data";
    private static final ObjectMapper STRICT_OBJECT_MAPPER = new ObjectMapper();
    private static final Configuration JSON_PATH_CONFIG = Configuration.builder().jsonProvider((JsonProvider)new JacksonJsonProvider(STRICT_OBJECT_MAPPER)).build();

    public static boolean isEmptyJsonObject(String jsonString) {
        try {
            JsonNode jsonNode = STRICT_OBJECT_MAPPER.readTree(jsonString);
            return jsonNode.isObject() && jsonNode.isEmpty();
        }
        catch (Exception e) {
            throw new JsonException("INVALID_JSON_STRING", e);
        }
    }

    public static JsonNode parseStrict(String json) throws JsonException {
        try {
            JsonParser parser = STRICT_OBJECT_MAPPER.getFactory().createParser(json);
            JsonNode result = (JsonNode)STRICT_OBJECT_MAPPER.readTree(parser);
            if (parser.nextToken() != null) {
                throw new JsonException("Additional tokens found after parsing: " + json);
            }
            return result;
        }
        catch (Exception e) {
            throw new JsonException("Json is not valid in strict way: " + json, e);
        }
    }

    public static String buildJsonString(String key, Object value) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, value);
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public static boolean isValidAndDefinite(String jsonPath) {
        if (Strings.isNullOrEmpty((String)jsonPath) || !jsonPath.startsWith(JSONPATH_PREFIX)) {
            return Boolean.FALSE;
        }
        CompiledPath compiledPath = null;
        try {
            compiledPath = (CompiledPath)PathCompiler.compile((String)jsonPath, (Predicate[])new Predicate[0]);
        }
        catch (InvalidPathException e) {
            return Boolean.FALSE;
        }
        return compiledPath.isDefinite();
    }

    public static String getJsonPathValue(String content, String jsonPath) {
        if (Strings.isNullOrEmpty((String)content) || Strings.isNullOrEmpty((String)jsonPath)) {
            throw new EventMeshException("invalid config" + jsonPath);
        }
        Object obj = null;
        try {
            obj = JsonPath.using((Configuration)JSON_PATH_CONFIG).parse(content).read(jsonPath, JsonNode.class, new Predicate[0]);
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
        return obj.toString();
    }

    public static JsonNode convertToJsonNode(String object) throws JsonProcessingException {
        return (JsonNode)STRICT_OBJECT_MAPPER.readValue(object, JsonNode.class);
    }

    public static String matchJsonPathValueWithString(String jsonString, String jsonPath) {
        Object obj = JsonPathUtils.jsonPathParse(jsonString, jsonPath);
        if (obj == null) {
            return "null";
        }
        return obj.toString();
    }

    public static Object jsonPathParse(String jsonString, String jsonPath) {
        if (Strings.isNullOrEmpty((String)jsonPath) || Strings.isNullOrEmpty((String)jsonString)) {
            throw new EventMeshException("invalid config" + jsonPath);
        }
        Object obj = null;
        try {
            DocumentContext readContext = JsonPath.using((Configuration)JSON_PATH_CONFIG).parse(jsonString);
            obj = readContext.read(jsonPath, new Predicate[0]);
        }
        catch (InvalidPathException invalidPathException) {
            return null;
        }
        return obj;
    }

    public static String matchJsonPathValue(String jsonString, String jsonPath) throws JsonProcessingException {
        Object obj = JsonPathUtils.jsonPathParse(jsonString, jsonPath);
        return STRICT_OBJECT_MAPPER.writer().writeValueAsString(obj);
    }
}

