/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.common.protocol.http;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.protocol.ProtocolTransportObject;
import org.apache.eventmesh.common.protocol.http.common.EventMeshRetCode;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.common.protocol.http.common.RequestURI;
import org.apache.eventmesh.common.utils.JsonUtils;

public class HttpEventWrapper
implements ProtocolTransportObject {
    public static final long serialVersionUID = -8547334421415366981L;
    private transient Map<String, Object> headerMap = new HashMap<String, Object>();
    private transient Map<String, Object> sysHeaderMap = new HashMap<String, Object>();
    private byte[] body;
    private String requestURI;
    private String httpMethod;
    private String httpVersion;
    private long reqTime;
    private long resTime;
    private HttpResponseStatus httpResponseStatus = HttpResponseStatus.OK;

    public HttpEventWrapper() {
        this(null, null, null);
    }

    public HttpEventWrapper(String httpMethod, String httpVersion, String requestURI) {
        this.httpMethod = httpMethod;
        this.httpVersion = httpVersion;
        this.reqTime = System.currentTimeMillis();
        this.requestURI = requestURI;
    }

    public HttpEventWrapper createHttpResponse(Map<String, Object> responseHeaderMap, Map<String, Object> responseBodyMap) {
        if (StringUtils.isBlank((CharSequence)this.requestURI)) {
            return null;
        }
        HttpEventWrapper response = new HttpEventWrapper(this.httpMethod, this.httpVersion, this.requestURI);
        response.setReqTime(this.reqTime);
        response.setHeaderMap(responseHeaderMap);
        response.setBody(Objects.requireNonNull(JsonUtils.toJSONString(responseBodyMap)).getBytes(Constants.DEFAULT_CHARSET));
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public HttpEventWrapper createHttpResponse(EventMeshRetCode eventMeshRetCode) {
        if (StringUtils.isBlank((CharSequence)this.requestURI)) {
            return null;
        }
        HttpEventWrapper response = new HttpEventWrapper(this.httpMethod, this.httpVersion, this.requestURI);
        response.setReqTime(this.reqTime);
        HashMap<String, Object> responseHeaderMap = new HashMap<String, Object>();
        responseHeaderMap.put("requestURI", response.requestURI);
        response.setHeaderMap(responseHeaderMap);
        HashMap<String, Object> responseBodyMap = new HashMap<String, Object>();
        responseBodyMap.put("retCode", eventMeshRetCode.getRetCode());
        responseBodyMap.put("retMessage", eventMeshRetCode.getErrMsg());
        response.setBody(Objects.requireNonNull(JsonUtils.toJSONString(responseBodyMap)).getBytes(Constants.DEFAULT_CHARSET));
        response.setResTime(System.currentTimeMillis());
        return response;
    }

    public long getReqTime() {
        return this.reqTime;
    }

    public void setReqTime(long reqTime) {
        this.reqTime = reqTime;
    }

    public long getResTime() {
        return this.resTime;
    }

    public void setResTime(long resTime) {
        this.resTime = resTime;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public Map<String, Object> getHeaderMap() {
        return this.headerMap;
    }

    public void setHeaderMap(Map<String, Object> headerMap) {
        this.headerMap = headerMap;
    }

    public Map<String, Object> getSysHeaderMap() {
        return this.sysHeaderMap;
    }

    public void setSysHeaderMap(Map<String, Object> sysHeaderMap) {
        this.sysHeaderMap = sysHeaderMap;
    }

    public byte[] getBody() {
        int len = this.body.length;
        byte[] b = new byte[len];
        System.arraycopy(this.body, 0, b, 0, len);
        return b;
    }

    public void setBody(byte[] newBody) {
        if (newBody == null || newBody.length == 0) {
            return;
        }
        int len = newBody.length;
        this.body = new byte[len];
        System.arraycopy(newBody, 0, this.body, 0, len);
    }

    public DefaultFullHttpResponse httpResponse() throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.httpResponseStatus, Unpooled.wrappedBuffer((byte[])this.body));
        HttpHeaders headers = response.headers();
        headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)("text/plain; charset=" + Constants.DEFAULT_CHARSET));
        headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        headers.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        Optional.of(this.headerMap).ifPresent(customerHeader -> customerHeader.forEach((arg_0, arg_1) -> ((HttpHeaders)headers).add(arg_0, arg_1)));
        return response;
    }

    public void buildSysHeaderForClient() {
        this.sysHeaderMap.put("protocoltype", "http");
        this.sysHeaderMap.put("protocoldesc", "http");
        EnumSet<ProtocolKey.ClientInstanceKey> clientInstanceKeys = EnumSet.allOf(ProtocolKey.ClientInstanceKey.class);
        block3: for (ProtocolKey.ClientInstanceKey clientInstanceKey : clientInstanceKeys) {
            switch (clientInstanceKey) {
                case BIZSEQNO: 
                case UNIQUEID: {
                    continue block3;
                }
            }
            this.sysHeaderMap.put(clientInstanceKey.getKey(), this.headerMap.getOrDefault(clientInstanceKey.getKey(), clientInstanceKey.getValue()));
        }
    }

    public void buildSysHeaderForCE() {
        this.sysHeaderMap.put("id", UUID.randomUUID().toString());
        this.sysHeaderMap.put("source", this.headerMap.getOrDefault("source", URI.create("/")));
        this.sysHeaderMap.put("type", this.headerMap.getOrDefault("type", "http_request"));
        String topic = this.headerMap.getOrDefault("subject", "").toString();
        if (this.requestURI.startsWith(RequestURI.PUBLISH.getRequestURI())) {
            topic = this.requestURI.substring(RequestURI.PUBLISH.getRequestURI().length() + 1);
        }
        if (StringUtils.isEmpty((CharSequence)topic)) {
            topic = "TEST-HTTP-TOPIC";
        }
        this.sysHeaderMap.put("subject", topic);
    }

    public void setHttpResponseStatus(HttpResponseStatus httpResponseStatus) {
        this.httpResponseStatus = httpResponseStatus;
    }
}

