/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public class MessageRequest {
    @NonNull
    String role;
    @NonNull
    String content;
    @JsonProperty(value="file_ids")
    List<String> fileIds;
    Map<String, String> metadata;

    private static String $default$role() {
        return "user";
    }

    public static MessageRequestBuilder builder() {
        return new MessageRequestBuilder();
    }

    public MessageRequest() {
        this.role = MessageRequest.$default$role();
    }

    public MessageRequest(@NonNull String role, @NonNull String content, List<String> fileIds, Map<String, String> metadata) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.role = role;
        this.content = content;
        this.fileIds = fileIds;
        this.metadata = metadata;
    }

    @NonNull
    public String getRole() {
        return this.role;
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    public List<String> getFileIds() {
        return this.fileIds;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public void setRole(@NonNull String role) {
        if (role == null) {
            throw new NullPointerException("role is marked non-null but is null");
        }
        this.role = role;
    }

    public void setContent(@NonNull String content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
    }

    @JsonProperty(value="file_ids")
    public void setFileIds(List<String> fileIds) {
        this.fileIds = fileIds;
    }

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageRequest)) {
            return false;
        }
        MessageRequest other = (MessageRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$fileIds = this.getFileIds();
        List<String> other$fileIds = other.getFileIds();
        if (this$fileIds == null ? other$fileIds != null : !((Object)this$fileIds).equals(other$fileIds)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        return !(this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $fileIds = this.getFileIds();
        result = result * 59 + ($fileIds == null ? 43 : ((Object)$fileIds).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        return result;
    }

    public String toString() {
        return "MessageRequest(role=" + this.getRole() + ", content=" + this.getContent() + ", fileIds=" + this.getFileIds() + ", metadata=" + this.getMetadata() + ")";
    }

    public static class MessageRequestBuilder {
        private boolean role$set;
        private String role$value;
        private String content;
        private List<String> fileIds;
        private Map<String, String> metadata;

        MessageRequestBuilder() {
        }

        public MessageRequestBuilder role(@NonNull String role) {
            if (role == null) {
                throw new NullPointerException("role is marked non-null but is null");
            }
            this.role$value = role;
            this.role$set = true;
            return this;
        }

        public MessageRequestBuilder content(@NonNull String content) {
            if (content == null) {
                throw new NullPointerException("content is marked non-null but is null");
            }
            this.content = content;
            return this;
        }

        @JsonProperty(value="file_ids")
        public MessageRequestBuilder fileIds(List<String> fileIds) {
            this.fileIds = fileIds;
            return this;
        }

        public MessageRequestBuilder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public MessageRequest build() {
            String role$value = this.role$value;
            if (!this.role$set) {
                role$value = MessageRequest.$default$role();
            }
            return new MessageRequest(role$value, this.content, this.fileIds, this.metadata);
        }

        public String toString() {
            return "MessageRequest.MessageRequestBuilder(role$value=" + this.role$value + ", content=" + this.content + ", fileIds=" + this.fileIds + ", metadata=" + this.metadata + ")";
        }
    }
}

