/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicStampedReference;

public final class RandomXoshiro256PlusPlus
extends Random {
    private static final long serialVersionUID = -2837799889588687855L;
    private static final long SPLITMIX1_MAGIC = -7046029254386353131L;
    AtomicStampedReference<long[]> stateRef;

    public static Random create() {
        byte[] seed = SecureRandom.getSeed(32);
        ByteBuffer bbw = ByteBuffer.wrap(seed);
        return new RandomXoshiro256PlusPlus(bbw.getLong(), bbw.getLong(), bbw.getLong(), bbw.getLong());
    }

    RandomXoshiro256PlusPlus(long s1, long s2, long s3, long s4) {
        this.setState(s1, s2, s3, s4);
    }

    private static long splitmix64v1(long x) {
        return x + -7046029254386353131L;
    }

    private static long splitmix64v2(long z) {
        z = (z ^ z >> 30) * -4658895280553007687L;
        z = (z ^ z >> 27) * -7723592293110705685L;
        return z ^ z >> 31;
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        int[] stamp = new int[]{0};
        this.stateRef = new AtomicStampedReference<long[]>(new long[4], 0);
        long[] oldState = this.stateRef.get(stamp);
        long[] state = new long[4];
        long sms = RandomXoshiro256PlusPlus.splitmix64v1(seed);
        state[0] = RandomXoshiro256PlusPlus.splitmix64v2(sms);
        sms = RandomXoshiro256PlusPlus.splitmix64v1(sms);
        state[1] = RandomXoshiro256PlusPlus.splitmix64v2(sms);
        sms = RandomXoshiro256PlusPlus.splitmix64v1(sms);
        state[2] = RandomXoshiro256PlusPlus.splitmix64v2(sms);
        sms = RandomXoshiro256PlusPlus.splitmix64v1(sms);
        state[3] = RandomXoshiro256PlusPlus.splitmix64v2(sms);
        if (!this.stateRef.compareAndSet(oldState, state, stamp[0], 1)) {
            throw new IllegalStateException();
        }
    }

    void setState(long s0, long s1, long s2, long s4) {
        long[] state;
        if (s0 == 0L && s1 == 0L && s2 == 0L && s4 == 0L) {
            throw new IllegalArgumentException("xoshiro256++ state cannot be all zeroes");
        }
        int[] stamp = new int[]{0};
        long[] oldState = this.stateRef.get(stamp);
        if (!this.stateRef.compareAndSet(oldState, state = new long[]{s0, s1, s2, s4}, stamp[0], 1)) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected int next(int bits) {
        return (int)(this.nextLong() & (1L << bits) - 1L);
    }

    @Override
    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public int nextInt(int bound) {
        return (int)this.nextLong(bound);
    }

    @Override
    public long nextLong(long bound) {
        if (bound <= 0L) {
            throw new IllegalArgumentException("bound must be positive");
        }
        return (this.nextLong() & Long.MAX_VALUE) % bound;
    }

    @Override
    public double nextDouble() {
        return (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
    }

    @Override
    public float nextFloat() {
        return (float)(this.nextLong() >>> 40) * 5.9604645E-8f;
    }

    @Override
    public boolean nextBoolean() {
        return (this.nextLong() & 1L) != 0L;
    }

    @Override
    public void nextBytes(byte[] buf) {
        this.nextBytes(buf, 0, buf.length);
    }

    public void nextBytes(byte[] buf, int ofs, int len) {
        if (ofs < 0) {
            throw new ArrayIndexOutOfBoundsException("Offset " + ofs + " is negative");
        }
        if (ofs >= buf.length) {
            throw new ArrayIndexOutOfBoundsException("Offset " + ofs + " is greater than buffer length");
        }
        if (ofs + len > buf.length) {
            throw new ArrayIndexOutOfBoundsException("Length " + len + " with offset " + ofs + " is past end of buffer");
        }
        int j = 8;
        long l = 0L;
        for (int i = ofs; i < ofs + len; ++i) {
            if (j >= 8) {
                l = this.nextLong();
                j = 0;
            }
            buf[i] = (byte)(l & 0xFFL);
            l >>>= 8;
            ++j;
        }
    }

    @Override
    public long nextLong() {
        long result;
        int[] stamp;
        long[] state;
        long[] oldState;
        do {
            stamp = new int[]{0};
            oldState = this.stateRef.get(stamp);
            state = Arrays.copyOf(oldState, oldState.length);
            result = Long.rotateLeft(state[0] + state[3], 23) + state[0];
            long t = state[1] << 17;
            state[2] = state[2] ^ state[0];
            state[3] = state[3] ^ state[1];
            state[1] = state[1] ^ state[2];
            state[0] = state[0] ^ state[3];
            state[2] = state[2] ^ t;
            state[3] = Long.rotateLeft(state[3], 45);
        } while (!this.stateRef.compareAndSet(oldState, state, stamp[0], stamp[0] + 1));
        return result;
    }
}

