/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongConsumer;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import reactor.core.publisher.FluxSink;

public abstract class IteratorConsumer<V>
implements LongConsumer {
    private final FluxSink<V> emitter;
    private String nextIterPos = "0";
    private RedisClient client;
    private final AtomicLong requested = new AtomicLong();

    public IteratorConsumer(FluxSink<V> emitter) {
        this.emitter = emitter;
    }

    @Override
    public void accept(long value) {
        if (this.requested.addAndGet(value) == value) {
            this.nextValues();
        }
    }

    protected void nextValues() {
        this.scanIterator(this.client, this.nextIterPos).whenComplete((res, e) -> {
            if (e != null) {
                this.emitter.error(e);
                return;
            }
            this.client = res.getRedisClient();
            this.nextIterPos = res.getPos();
            for (Object val : res.getValues()) {
                Object v = this.transformValue(val);
                this.emitter.next(v);
                this.requested.decrementAndGet();
            }
            if ("0".equals(this.nextIterPos) && !this.tryAgain()) {
                this.emitter.complete();
                return;
            }
            this.nextValues();
        });
    }

    protected Object transformValue(Object value) {
        return value;
    }

    protected abstract boolean tryAgain();

    protected abstract RFuture<ScanResult<Object>> scanIterator(RedisClient var1, String var2);
}

