/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.Objects;

public final class ClassLoaderUtils {
    public static final ClassLoaderCallable DEFAULT_CLASS_LOADER_CALLABLE = new ClassLoaderCallable(){

        @Override
        public ClassLoader getClassLoader() {
            return ClassLoaderUtils.class.getClassLoader();
        }
    };
    private static final ClassLoader SYSTEM_CLASS_LOADER;
    private static final ClassLoader EXT_CLASS_LOADER;
    private static final ClassLoader BOOT_CLASS_LOADER;

    private static ClassLoader findChildClassLoader(ClassLoader parent, ClassLoader searchTarget) {
        ClassLoader prev = searchTarget;
        while (parent != prev.getParent()) {
            prev = prev.getParent();
        }
        return prev;
    }

    private ClassLoaderUtils() {
    }

    public static ClassLoader getDefaultClassLoader() {
        return ClassLoaderUtils.getDefaultClassLoader(DEFAULT_CLASS_LOADER_CALLABLE);
    }

    public static ClassLoader getDefaultClassLoader(ClassLoaderCallable defaultClassLoaderCallable) {
        Objects.requireNonNull(defaultClassLoaderCallable, "defaultClassLoaderCallable");
        try {
            Thread th = Thread.currentThread();
            ClassLoader contextClassLoader = th.getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultClassLoaderCallable.getClassLoader();
    }

    public static boolean isJvmClassLoader(ClassLoader classLoader) {
        return BOOT_CLASS_LOADER == classLoader || SYSTEM_CLASS_LOADER == classLoader || EXT_CLASS_LOADER == classLoader;
    }

    public static String dumpStandardClassLoader() {
        StringBuilder buffer = new StringBuilder();
        ClassLoaderUtils.appendClassLoaderLog(buffer, "SYSTEM_CLASS_LOADER", SYSTEM_CLASS_LOADER);
        ClassLoaderUtils.appendClassLoaderLog(buffer, "EXT_CLASS_LOADER", EXT_CLASS_LOADER);
        ClassLoaderUtils.appendClassLoaderLog(buffer, "BOOT_CLASS_LOADER", BOOT_CLASS_LOADER);
        return buffer.toString();
    }

    private static void appendClassLoaderLog(StringBuilder buffer, String classLoaderName, ClassLoader classLoader) {
        buffer.append(classLoaderName);
        buffer.append(':');
        if (classLoader == null) {
            buffer.append("null");
        } else {
            buffer.append(classLoader);
        }
        buffer.append(", ");
    }

    static {
        BOOT_CLASS_LOADER = Object.class.getClassLoader();
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        EXT_CLASS_LOADER = ClassLoaderUtils.findChildClassLoader(BOOT_CLASS_LOADER, systemClassLoader);
        SYSTEM_CLASS_LOADER = ClassLoaderUtils.findChildClassLoader(EXT_CLASS_LOADER, systemClassLoader);
    }

    public static interface ClassLoaderCallable {
        public ClassLoader getClassLoader();
    }
}

