/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IdValidateUtils {
    private static final int DEFAULT_MAX_LENGTH = 24;
    public static String STABLE_VERSION_PATTERN_VALUE = "[0-9]+\\.[0-9]+\\.[0-9](-p[0-9]+)?";
    public static final String ID_PATTERN_VALUE = "[a-zA-Z0-9\\._\\-]+";
    private static final Pattern ID_PATTERN = Pattern.compile("[a-zA-Z0-9\\._\\-]+");

    private IdValidateUtils() {
    }

    public static boolean validateId(String id) {
        return IdValidateUtils.validateId(id, 24);
    }

    public static boolean validateId(String id, int maxLength) {
        CheckResult result = IdValidateUtils.checkId(id, maxLength);
        return result == CheckResult.SUCCESS;
    }

    public static CheckResult checkId(String id, int maxLength) {
        Objects.requireNonNull(id, "id");
        if (maxLength <= 0) {
            throw new IllegalArgumentException("negative maxLength:" + maxLength);
        }
        if (!IdValidateUtils.checkLength(id, maxLength)) {
            return CheckResult.FAIL_LENGTH;
        }
        if (!IdValidateUtils.checkPattern(id)) {
            return CheckResult.FAIL_PATTERN;
        }
        return CheckResult.SUCCESS;
    }

    public static boolean checkPattern(String id) {
        Matcher matcher = ID_PATTERN.matcher(id);
        return matcher.matches();
    }

    public static boolean checkLength(String id, int maxLength) {
        Objects.requireNonNull(id, "id");
        int idLength = id.length();
        if (idLength <= 0) {
            return false;
        }
        return idLength <= maxLength;
    }

    public static boolean checkId(String id, int offset, int length) {
        Matcher matcher = ID_PATTERN.matcher(id);
        matcher.region(offset, length);
        return matcher.matches();
    }

    public static enum CheckResult {
        SUCCESS,
        FAIL_LENGTH,
        FAIL_PATTERN;

    }
}

