/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.asm.tree;

import com.googlecode.aviator.asm.MethodVisitor;
import com.googlecode.aviator.asm.tree.LabelNode;
import java.util.List;
import java.util.Map;

public abstract class AbstractInsnNode {
    public static final int INSN = 0;
    public static final int INT_INSN = 1;
    public static final int VAR_INSN = 2;
    public static final int TYPE_INSN = 3;
    public static final int FIELD_INSN = 4;
    public static final int METHOD_INSN = 5;
    public static final int JUMP_INSN = 6;
    public static final int LABEL = 7;
    public static final int LDC_INSN = 8;
    public static final int IINC_INSN = 9;
    public static final int TABLESWITCH_INSN = 10;
    public static final int LOOKUPSWITCH_INSN = 11;
    public static final int MULTIANEWARRAY_INSN = 12;
    public static final int FRAME = 13;
    public static final int LINE = 14;
    protected int opcode;
    AbstractInsnNode prev;
    AbstractInsnNode next;
    int index;

    protected AbstractInsnNode(int opcode) {
        this.opcode = opcode;
        this.index = -1;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public abstract int getType();

    public AbstractInsnNode getPrevious() {
        return this.prev;
    }

    public AbstractInsnNode getNext() {
        return this.next;
    }

    public abstract void accept(MethodVisitor var1);

    public abstract AbstractInsnNode clone(Map var1);

    static LabelNode clone(LabelNode label, Map map) {
        return (LabelNode)map.get(label);
    }

    static LabelNode[] clone(List labels, Map map) {
        LabelNode[] clones = new LabelNode[labels.size()];
        for (int i = 0; i < clones.length; ++i) {
            clones[i] = (LabelNode)map.get(labels.get(i));
        }
        return clones;
    }
}

