/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator.runtime.type;

import com.googlecode.aviator.runtime.type.AviatorNumber;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.runtime.type.AviatorType;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AviatorDouble
extends AviatorNumber {
    public AviatorDouble(Number number) {
        super(number);
    }

    public static AviatorDouble valueOf(double value) {
        return new AviatorDouble(value);
    }

    public static AviatorDouble valueOf(Double value) {
        return new AviatorDouble(value);
    }

    @Override
    public int innerCompare(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        return Double.compare(this.number.doubleValue(), otherNum.doubleValue());
    }

    @Override
    public AviatorObject neg(Map<String, Object> env) {
        return new AviatorDouble(-this.number.doubleValue());
    }

    @Override
    public AviatorObject innerDiv(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        return new AviatorDouble(this.number.doubleValue() / otherNum.doubleValue());
    }

    @Override
    public AviatorNumber innerAdd(AviatorNumber other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = other;
        return new AviatorDouble(this.number.doubleValue() + otherNum.doubleValue());
    }

    @Override
    public AviatorObject innerMod(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        return new AviatorDouble(this.number.doubleValue() % otherNum.doubleValue());
    }

    @Override
    public AviatorObject innerMult(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        return new AviatorDouble(this.number.doubleValue() * otherNum.doubleValue());
    }

    @Override
    public AviatorType getAviatorType() {
        return AviatorType.Double;
    }

    @Override
    public AviatorObject innerSub(AviatorObject other) {
        this.ensureNumber(other);
        AviatorNumber otherNum = (AviatorNumber)other;
        return new AviatorDouble(this.number.doubleValue() - otherNum.doubleValue());
    }
}

