/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.scim.impl;

import com.slack.api.SlackConfig;
import com.slack.api.methods.impl.MethodsClientImpl;
import com.slack.api.methods.impl.TeamIdCache;
import com.slack.api.rate_limits.metrics.MetricsDatastore;
import com.slack.api.rate_limits.queue.MessageIdGenerator;
import com.slack.api.rate_limits.queue.MessageIdGeneratorUUIDImpl;
import com.slack.api.scim.SCIMApiCompletionException;
import com.slack.api.scim.SCIMApiException;
import com.slack.api.scim.SCIMApiResponse;
import com.slack.api.scim.SCIMConfig;
import com.slack.api.scim.SCIMEndpointName;
import com.slack.api.scim.impl.AsyncExecutionSupplier;
import com.slack.api.scim.impl.AsyncRateLimitQueue;
import com.slack.api.scim.impl.ThreadPools;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncRateLimitExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncRateLimitExecutor.class);
    private static final ConcurrentMap<String, AsyncRateLimitExecutor> ALL_EXECUTORS = new ConcurrentHashMap<String, AsyncRateLimitExecutor>();
    private SCIMConfig config;
    private MetricsDatastore metricsDatastore;
    private final TeamIdCache teamIdCache;
    private final MessageIdGenerator messageIdGenerator;
    private static final List<String> NO_TOKEN_METHOD_NAMES = Collections.emptyList();

    private AsyncRateLimitExecutor(MethodsClientImpl methods, SlackConfig config) {
        this.config = config.getSCIMConfig();
        this.metricsDatastore = config.getSCIMConfig().getMetricsDatastore();
        this.teamIdCache = new TeamIdCache(methods);
        this.messageIdGenerator = new MessageIdGeneratorUUIDImpl();
    }

    public static AsyncRateLimitExecutor get(String executorName) {
        return (AsyncRateLimitExecutor)ALL_EXECUTORS.get(executorName);
    }

    public static AsyncRateLimitExecutor getOrCreate(MethodsClientImpl methods, SlackConfig config) {
        AsyncRateLimitExecutor executor = (AsyncRateLimitExecutor)ALL_EXECUTORS.get(config.getSCIMConfig().getExecutorName());
        if (executor != null && executor.metricsDatastore != config.getSCIMConfig().getMetricsDatastore()) {
            executor.config = config.getSCIMConfig();
            executor.metricsDatastore = config.getSCIMConfig().getMetricsDatastore();
        }
        if (executor == null) {
            executor = new AsyncRateLimitExecutor(methods, config);
            ALL_EXECUTORS.putIfAbsent(config.getSCIMConfig().getExecutorName(), executor);
        }
        return executor;
    }

    public <T extends SCIMApiResponse> CompletableFuture<T> execute(SCIMEndpointName endpointName, Map<String, String> params, AsyncExecutionSupplier<T> methodsSupplier) {
        String token = params.get("token");
        String teamId = token != null ? this.teamIdCache.lookupOrResolve(token) : null;
        ExecutorService executorService = teamId != null ? ThreadPools.getOrCreate(this.config, teamId) : ThreadPools.getDefault(this.config);
        return CompletableFuture.supplyAsync(() -> {
            String messageId = this.messageIdGenerator.generate();
            this.addMessageId(teamId, endpointName, messageId);
            this.syncCurrentQueueSizeStats(teamId, endpointName);
            if (NO_TOKEN_METHOD_NAMES.contains((Object)endpointName) || teamId == null) {
                return this.runWithoutQueue(teamId, endpointName, methodsSupplier);
            }
            return this.enqueueThenRun(messageId, teamId, endpointName, params, methodsSupplier);
        }, executorService);
    }

    private void syncCurrentQueueSizeStats(String teamId, SCIMEndpointName endpointName) {
        if (teamId != null) {
            this.metricsDatastore.updateCurrentQueueSize(this.config.getExecutorName(), teamId, endpointName.name());
        }
    }

    private void addMessageId(String teamId, SCIMEndpointName endpointName, String messageId) {
        this.metricsDatastore.addToWaitingMessageIds(this.config.getExecutorName(), teamId, endpointName.name(), messageId);
    }

    private void removeMessageId(String teamId, SCIMEndpointName endpointName, String messageId) {
        this.metricsDatastore.deleteFromWaitingMessageIds(this.config.getExecutorName(), teamId, endpointName.name(), messageId);
    }

    public <T extends SCIMApiResponse> T runWithoutQueue(String teamId, SCIMEndpointName endpointName, AsyncExecutionSupplier<T> methodsSupplier) {
        try {
            return methodsSupplier.execute();
        }
        catch (RuntimeException e) {
            return AsyncRateLimitExecutor.handleRuntimeException(teamId, endpointName, e);
        }
        catch (IOException e) {
            return AsyncRateLimitExecutor.handleIOException(teamId, endpointName, e);
        }
        catch (SCIMApiException e) {
            AsyncRateLimitExecutor.logSCIMApiException(teamId, endpointName, e);
            throw new SCIMApiCompletionException(null, e, null);
        }
    }

    private <T extends SCIMApiResponse> T enqueueThenRun(String messageId, String teamId, SCIMEndpointName endpointName, Map<String, String> params, AsyncExecutionSupplier<T> methodsSupplier) {
        try {
            AsyncRateLimitQueue activeQueue = AsyncRateLimitQueue.getOrCreate(this.config, teamId);
            if (activeQueue == null) {
                log.warn("Queue for teamId: {} was not found. Going to run the API call immediately.", (Object)teamId);
            }
            AsyncExecutionSupplier supplier = null;
            activeQueue.enqueue(messageId, teamId, endpointName.name(), params, methodsSupplier);
            for (long consumedMillis = 0L; supplier == null && consumedMillis < (long)this.config.getMaxIdleMills(); consumedMillis += 10L) {
                Thread.sleep(10L);
                supplier = (AsyncExecutionSupplier)activeQueue.dequeueIfReady(messageId, teamId, endpointName.name(), params);
                this.removeMessageId(teamId, endpointName, messageId);
            }
            if (supplier == null) {
                activeQueue.remove(endpointName.name(), messageId);
                throw new RejectedExecutionException("Gave up executing the message after " + this.config.getMaxIdleMills() + " milliseconds.");
            }
            Object response = supplier.execute();
            return response;
        }
        catch (RuntimeException e) {
            return AsyncRateLimitExecutor.handleRuntimeException(teamId, endpointName, e);
        }
        catch (IOException e) {
            return AsyncRateLimitExecutor.handleIOException(teamId, endpointName, e);
        }
        catch (SCIMApiException e) {
            AsyncRateLimitExecutor.logSCIMApiException(teamId, endpointName, e);
            if (e.getResponse().code() == 429) {
                return this.enqueueThenRun(messageId, teamId, endpointName, params, methodsSupplier);
            }
            throw new SCIMApiCompletionException(null, e, null);
        }
        catch (InterruptedException e) {
            log.error("Got an InterruptedException (error: {})", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    private static <T extends SCIMApiResponse> T handleRuntimeException(String teamId, SCIMEndpointName endpointName, RuntimeException e) {
        log.error("Got an exception while calling {} API (team: {}, error: {})", new Object[]{endpointName, teamId, e.getMessage(), e});
        throw new SCIMApiCompletionException(null, null, e);
    }

    private static <T extends SCIMApiResponse> T handleIOException(String teamId, SCIMEndpointName endpointName, IOException e) {
        log.error("Failed to connect to {} API (team: {}, error: {})", new Object[]{endpointName, teamId, e.getMessage(), e});
        throw new SCIMApiCompletionException(e, null, null);
    }

    private static void logSCIMApiException(String teamId, SCIMEndpointName endpointName, SCIMApiException e) {
        if (e.getResponse().code() == 429) {
            String retryAfterSeconds = e.getResponse().header("Retry-After");
            log.error("Got a rate-limited response from {} API (team: {}, error: {}, retry-after: {})", new Object[]{endpointName, teamId, e.getMessage(), retryAfterSeconds, e});
        } else {
            log.error("Got an unsuccessful response from {} API (team: {}, error: {}, status code: {})", new Object[]{endpointName, teamId, e.getMessage(), e.getResponse().code(), e});
        }
    }
}

