/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.remote.job.SyncConsistency;
import org.apache.eventmesh.common.remote.job.SyncMode;
import org.apache.eventmesh.connector.canal.model.EventColumn;
import org.apache.eventmesh.connector.canal.model.EventType;

public class CanalConnectRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String schemaName;
    private String tableName;
    private String gtid;
    private String currentGtid;
    private EventType eventType;
    private long executeTime;
    private List<EventColumn> oldKeys = new ArrayList<EventColumn>();
    private List<EventColumn> keys = new ArrayList<EventColumn>();
    private List<EventColumn> columns = new ArrayList<EventColumn>();
    private long size = 1024L;
    private long pairId = -1L;
    private String sql;
    private String ddlSchemaName;
    private SyncMode syncMode;
    private SyncConsistency syncConsistency;
    private boolean remedy = false;
    private String hint;
    private boolean withoutSchema = false;
    private String journalName;
    private long binLogOffset;

    public List<EventColumn> getUpdatedColumns() {
        ArrayList<EventColumn> columns = new ArrayList<EventColumn>();
        for (EventColumn column : this.columns) {
            if (!column.isUpdate()) continue;
            columns.add(column);
        }
        return columns;
    }

    public List<EventColumn> getUpdatedKeys() {
        ArrayList<EventColumn> columns = new ArrayList<EventColumn>();
        for (EventColumn column : this.keys) {
            if (!column.isUpdate()) continue;
            columns.add(column);
        }
        return columns;
    }

    private List<EventColumn> cloneColumn(List<EventColumn> columns) {
        if (columns == null) {
            return null;
        }
        ArrayList<EventColumn> cloneColumns = new ArrayList<EventColumn>();
        for (EventColumn column : columns) {
            cloneColumns.add(column.clone());
        }
        return cloneColumns;
    }

    public CanalConnectRecord clone() {
        CanalConnectRecord record = new CanalConnectRecord();
        record.setTableName(this.tableName);
        record.setSchemaName(this.schemaName);
        record.setDdlSchemaName(this.ddlSchemaName);
        record.setEventType(this.eventType);
        record.setExecuteTime(this.executeTime);
        record.setKeys(this.cloneColumn(this.keys));
        record.setColumns(this.cloneColumn(this.columns));
        record.setOldKeys(this.cloneColumn(this.oldKeys));
        record.setSize(this.size);
        record.setPairId(this.pairId);
        record.setSql(this.sql);
        record.setSyncMode(this.syncMode);
        record.setSyncConsistency(this.syncConsistency);
        record.setRemedy(this.remedy);
        record.setHint(this.hint);
        record.setWithoutSchema(this.withoutSchema);
        return record;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columns == null ? 0 : this.columns.hashCode());
        result = 31 * result + (this.eventType == null ? 0 : this.eventType.hashCode());
        result = 31 * result + (int)(this.executeTime ^ this.executeTime >>> 32);
        result = 31 * result + (this.keys == null ? 0 : this.keys.hashCode());
        result = 31 * result + (this.oldKeys == null ? 0 : this.oldKeys.hashCode());
        result = 31 * result + (int)(this.pairId ^ this.pairId >>> 32);
        result = 31 * result + (this.schemaName == null ? 0 : this.schemaName.hashCode());
        result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CanalConnectRecord other = (CanalConnectRecord)obj;
        if (this.columns == null ? other.columns != null : !this.columns.equals(other.columns)) {
            return false;
        }
        if (this.eventType != other.eventType) {
            return false;
        }
        if (this.executeTime != other.executeTime) {
            return false;
        }
        if (this.keys == null ? other.keys != null : !this.keys.equals(other.keys)) {
            return false;
        }
        if (this.oldKeys == null ? other.oldKeys != null : !this.oldKeys.equals(other.oldKeys)) {
            return false;
        }
        if (this.pairId != other.pairId) {
            return false;
        }
        if (this.schemaName == null ? other.schemaName != null : !this.schemaName.equals(other.schemaName)) {
            return false;
        }
        return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
    }

    public String toString() {
        return "CanalConnectRecord{tableName='" + this.tableName + '\'' + ", schemaName='" + this.schemaName + '\'' + ", eventType=" + (Object)((Object)this.eventType) + ", executeTime=" + this.executeTime + ", oldKeys=" + this.oldKeys + ", keys=" + this.keys + ", columns=" + this.columns + ", size=" + this.size + ", pairId=" + this.pairId + ", sql='" + this.sql + '\'' + ", ddlSchemaName='" + this.ddlSchemaName + '\'' + ", syncMode=" + this.syncMode + ", syncConsistency=" + this.syncConsistency + ", remedy=" + this.remedy + ", hint='" + this.hint + '\'' + ", withoutSchema=" + this.withoutSchema + '}';
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public String getGtid() {
        return this.gtid;
    }

    @Generated
    public String getCurrentGtid() {
        return this.currentGtid;
    }

    @Generated
    public EventType getEventType() {
        return this.eventType;
    }

    @Generated
    public long getExecuteTime() {
        return this.executeTime;
    }

    @Generated
    public List<EventColumn> getOldKeys() {
        return this.oldKeys;
    }

    @Generated
    public List<EventColumn> getKeys() {
        return this.keys;
    }

    @Generated
    public List<EventColumn> getColumns() {
        return this.columns;
    }

    @Generated
    public long getSize() {
        return this.size;
    }

    @Generated
    public long getPairId() {
        return this.pairId;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getDdlSchemaName() {
        return this.ddlSchemaName;
    }

    @Generated
    public SyncMode getSyncMode() {
        return this.syncMode;
    }

    @Generated
    public SyncConsistency getSyncConsistency() {
        return this.syncConsistency;
    }

    @Generated
    public boolean isRemedy() {
        return this.remedy;
    }

    @Generated
    public String getHint() {
        return this.hint;
    }

    @Generated
    public boolean isWithoutSchema() {
        return this.withoutSchema;
    }

    @Generated
    public String getJournalName() {
        return this.journalName;
    }

    @Generated
    public long getBinLogOffset() {
        return this.binLogOffset;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setGtid(String gtid) {
        this.gtid = gtid;
    }

    @Generated
    public void setCurrentGtid(String currentGtid) {
        this.currentGtid = currentGtid;
    }

    @Generated
    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    @Generated
    public void setExecuteTime(long executeTime) {
        this.executeTime = executeTime;
    }

    @Generated
    public void setOldKeys(List<EventColumn> oldKeys) {
        this.oldKeys = oldKeys;
    }

    @Generated
    public void setKeys(List<EventColumn> keys) {
        this.keys = keys;
    }

    @Generated
    public void setColumns(List<EventColumn> columns) {
        this.columns = columns;
    }

    @Generated
    public void setSize(long size) {
        this.size = size;
    }

    @Generated
    public void setPairId(long pairId) {
        this.pairId = pairId;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setDdlSchemaName(String ddlSchemaName) {
        this.ddlSchemaName = ddlSchemaName;
    }

    @Generated
    public void setSyncMode(SyncMode syncMode) {
        this.syncMode = syncMode;
    }

    @Generated
    public void setSyncConsistency(SyncConsistency syncConsistency) {
        this.syncConsistency = syncConsistency;
    }

    @Generated
    public void setRemedy(boolean remedy) {
        this.remedy = remedy;
    }

    @Generated
    public void setHint(String hint) {
        this.hint = hint;
    }

    @Generated
    public void setWithoutSchema(boolean withoutSchema) {
        this.withoutSchema = withoutSchema;
    }

    @Generated
    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    @Generated
    public void setBinLogOffset(long binLogOffset) {
        this.binLogOffset = binLogOffset;
    }
}

