/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.source.connector;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.instance.core.CanalInstanceGenerator;
import com.alibaba.otter.canal.instance.manager.CanalInstanceWithManager;
import com.alibaba.otter.canal.instance.manager.model.Canal;
import com.alibaba.otter.canal.instance.manager.model.CanalParameter;
import com.alibaba.otter.canal.parse.CanalEventParser;
import com.alibaba.otter.canal.parse.ha.CanalHAController;
import com.alibaba.otter.canal.parse.inbound.mysql.MysqlEventParser;
import com.alibaba.otter.canal.protocol.CanalEntry;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.server.embedded.CanalServerWithEmbedded;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.Config;
import org.apache.eventmesh.common.config.connector.rdb.JdbcConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSourceIncrementConfig;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbDBDefinition;
import org.apache.eventmesh.common.config.connector.rdb.canal.RdbTableDefinition;
import org.apache.eventmesh.common.remote.datasource.DataSourceType;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.canal.CanalRecordOffset;
import org.apache.eventmesh.common.remote.offset.canal.CanalRecordPartition;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.DatabaseConnection;
import org.apache.eventmesh.connector.canal.source.EntryParser;
import org.apache.eventmesh.connector.canal.source.table.RdbTableMgr;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.util.ConfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CanalSourceIncrementConnector
implements Source {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CanalSourceIncrementConnector.class);
    private CanalSourceIncrementConfig sourceConfig;
    private CanalServerWithEmbedded canalServer;
    private ClientIdentity clientIdentity;
    private String tableFilter = null;
    private String fieldFilter = null;
    private volatile boolean running = false;
    private static final int maxEmptyTimes = 10;
    private RdbTableMgr tableMgr;
    private static final String SQL_SELECT_RDB_VERSION = "select version() as rdb_version";
    private static final String SQL_SELECT_SERVER_UUID_IN_MARIADB = "SELECT @@global.server_id as server_uuid";
    private static final String SQL_SHOW_SERVER_UUID_IN_MYSQL = "SELECT @@server_uuid as server_uuid";

    public Class<? extends Config> configClass() {
        return CanalSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (CanalSourceIncrementConfig)config;
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        CanalSourceConfig canalSourceConfig = (CanalSourceConfig)sourceConnectorContext.getSourceConfig();
        this.sourceConfig = (CanalSourceIncrementConfig)ConfigUtil.parse((Map)canalSourceConfig.getSourceConfig(), CanalSourceIncrementConfig.class);
        if (sourceConnectorContext.getRecordPositionList() != null) {
            this.sourceConfig.setRecordPositions(sourceConnectorContext.getRecordPositionList());
        }
        this.tableFilter = this.buildTableFilters(this.sourceConfig);
        if (StringUtils.isNotEmpty((CharSequence)this.sourceConfig.getFieldFilter())) {
            this.fieldFilter = this.sourceConfig.getFieldFilter();
        }
        DatabaseConnection.sourceConfig = this.sourceConfig.getSourceConnectorConfig();
        DatabaseConnection.initSourceConnection();
        DataSourceType dataSourceType = this.checkRDBDataSourceType(DatabaseConnection.sourceDataSource);
        String serverUUID = this.queryServerUUID(DatabaseConnection.sourceDataSource, dataSourceType);
        if (StringUtils.isNotEmpty((CharSequence)serverUUID)) {
            log.info("init source increment connector, serverUUID: {}", (Object)serverUUID);
            this.sourceConfig.setServerUUID(serverUUID);
        } else {
            log.warn("get source data source serverUUID empty please check");
        }
        this.tableMgr = new RdbTableMgr((JdbcConfig)this.sourceConfig.getSourceConnectorConfig(), (DataSource)DatabaseConnection.sourceDataSource);
        this.canalServer = CanalServerWithEmbedded.instance();
        this.canalServer.setCanalInstanceGenerator(new CanalInstanceGenerator(){

            public CanalInstance generate(String destination) {
                Canal canal = CanalSourceIncrementConnector.this.buildCanal(CanalSourceIncrementConnector.this.sourceConfig);
                CanalInstanceWithManager instance = new CanalInstanceWithManager(canal, CanalSourceIncrementConnector.this.tableFilter){

                    protected CanalHAController initHaController() {
                        return super.initHaController();
                    }

                    protected void startEventParserInternal(CanalEventParser parser, boolean isGroup) {
                        super.startEventParserInternal(parser, isGroup);
                        if (this.eventParser instanceof MysqlEventParser) {
                            CanalHAController haController;
                            ((MysqlEventParser)this.eventParser).setSupportBinlogFormats("ROW");
                            ((MysqlEventParser)this.eventParser).setSupportBinlogImages("FULL");
                            MysqlEventParser mysqlEventParser = (MysqlEventParser)this.eventParser;
                            mysqlEventParser.setParallel(false);
                            if (StringUtils.isNotEmpty((CharSequence)CanalSourceIncrementConnector.this.fieldFilter)) {
                                mysqlEventParser.setFieldFilter(CanalSourceIncrementConnector.this.fieldFilter);
                            }
                            if (!(haController = mysqlEventParser.getHaController()).isStart()) {
                                haController.start();
                            }
                        }
                    }
                };
                return instance;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String queryServerUUID(DruidDataSource sourceDataSource, DataSourceType dataSourceType) {
        String serverUUID = "";
        try {
            String queryServerUUIDSql = DataSourceType.MariaDB.equals((Object)dataSourceType) ? SQL_SELECT_SERVER_UUID_IN_MARIADB : SQL_SHOW_SERVER_UUID_IN_MYSQL;
            log.info("execute sql '{}' start.", (Object)queryServerUUIDSql);
            try (PreparedStatement preparedStatement = sourceDataSource.getConnection().prepareStatement(queryServerUUIDSql);){
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) return serverUUID;
                log.info("execute sql '{}' result:{}", (Object)queryServerUUIDSql, (Object)resultSet);
                serverUUID = resultSet.getString("server_uuid");
                log.info("execute sql '{}',query server_uuid result:{}", (Object)queryServerUUIDSql, (Object)serverUUID);
                String string = serverUUID;
                return string;
            }
        }
        catch (Exception e) {
            log.warn("select server_uuid failed,data source:{}", (Object)sourceDataSource, (Object)e);
            throw new RuntimeException("select server_uuid failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DataSourceType checkRDBDataSourceType(DruidDataSource sourceDataSource) {
        try {
            log.info("execute sql '{}' start.", (Object)SQL_SELECT_RDB_VERSION);
            try (PreparedStatement preparedStatement = sourceDataSource.getConnection().prepareStatement(SQL_SELECT_RDB_VERSION);){
                ResultSet resultSet = preparedStatement.executeQuery();
                if (!resultSet.next()) return DataSourceType.MYSQL;
                log.info("execute sql '{}' result:{}", (Object)SQL_SELECT_RDB_VERSION, (Object)resultSet);
                String rdbVersion = resultSet.getString("rdb_version");
                if (!StringUtils.isNotBlank((CharSequence)rdbVersion)) return DataSourceType.MYSQL;
                if (!rdbVersion.toLowerCase().contains(DataSourceType.MariaDB.getName().toLowerCase())) return DataSourceType.MYSQL;
                DataSourceType dataSourceType = DataSourceType.MariaDB;
                return dataSourceType;
            }
        }
        catch (Exception e) {
            log.warn("select rdb version failed,data source:{}", (Object)sourceDataSource, (Object)e);
            throw new RuntimeException("select rdb version failed");
        }
    }

    private String buildTableFilters(CanalSourceIncrementConfig sourceConfig) {
        StringBuilder tableFilterBuilder = new StringBuilder();
        Set dbDefinitions = sourceConfig.getSourceConnectorConfig().getDatabases();
        for (RdbDBDefinition dbDefinition : dbDefinitions) {
            Set tableDefinitions = dbDefinition.getTables();
            for (RdbTableDefinition rdbTableDefinition : tableDefinitions) {
                if (tableFilterBuilder.length() > 0) {
                    tableFilterBuilder.append(",");
                }
                String dbName = rdbTableDefinition.getSchemaName();
                String tableName = rdbTableDefinition.getTableName();
                tableFilterBuilder.append(dbName);
                tableFilterBuilder.append("\\.");
                tableFilterBuilder.append(tableName);
            }
        }
        return tableFilterBuilder.toString();
    }

    private Canal buildCanal(CanalSourceIncrementConfig sourceConfig) {
        long slaveId = 10000L;
        if (sourceConfig.getSlaveId() != null) {
            slaveId = sourceConfig.getSlaveId();
        }
        Canal canal = new Canal();
        canal.setId(sourceConfig.getCanalInstanceId());
        canal.setName(sourceConfig.getDestination());
        canal.setDesc(sourceConfig.getDesc());
        CanalParameter parameter = new CanalParameter();
        parameter.setRunMode(CanalParameter.RunMode.EMBEDDED);
        parameter.setClusterMode(CanalParameter.ClusterMode.STANDALONE);
        parameter.setMetaMode(CanalParameter.MetaMode.MEMORY);
        parameter.setHaMode(CanalParameter.HAMode.HEARTBEAT);
        parameter.setIndexMode(CanalParameter.IndexMode.MEMORY);
        parameter.setStorageMode(CanalParameter.StorageMode.MEMORY);
        parameter.setMemoryStorageBufferSize(Integer.valueOf(32768));
        parameter.setSourcingType(CanalParameter.SourcingType.MYSQL);
        parameter.setDbAddresses(Collections.singletonList(new InetSocketAddress(sourceConfig.getSourceConnectorConfig().getDbAddress(), sourceConfig.getSourceConnectorConfig().getDbPort())));
        parameter.setDbUsername(sourceConfig.getSourceConnectorConfig().getUserName());
        parameter.setDbPassword(sourceConfig.getSourceConnectorConfig().getPassWord());
        parameter.setGtidEnable(Boolean.valueOf(sourceConfig.isGTIDMode()));
        if (sourceConfig.getRecordPositions() != null && !sourceConfig.getRecordPositions().isEmpty()) {
            List recordPositions = sourceConfig.getRecordPositions();
            ArrayList positions = new ArrayList();
            recordPositions.forEach(recordPosition -> {
                String gtidRange;
                HashMap<String, Object> recordPositionMap = new HashMap<String, Object>();
                CanalRecordPartition canalRecordPartition = (CanalRecordPartition)recordPosition.getRecordPartition();
                CanalRecordOffset canalRecordOffset = (CanalRecordOffset)recordPosition.getRecordOffset();
                recordPositionMap.put("journalName", canalRecordPartition.getJournalName());
                recordPositionMap.put("timestamp", canalRecordPartition.getTimeStamp());
                recordPositionMap.put("position", canalRecordOffset.getOffset());
                if (sourceConfig.isGTIDMode() && !sourceConfig.isMariaDB() && (gtidRange = canalRecordOffset.getGtid()) != null) {
                    if (canalRecordOffset.getCurrentGtid() != null) {
                        gtidRange = EntryParser.replaceGtidRange(canalRecordOffset.getGtid(), canalRecordOffset.getCurrentGtid(), sourceConfig.getServerUUID());
                    }
                    recordPositionMap.put("gtid", gtidRange);
                }
                positions.add(JsonUtils.toJSONString(recordPositionMap));
            });
            parameter.setPositions(positions);
        }
        parameter.setSlaveId(Long.valueOf(slaveId));
        parameter.setDefaultConnectionTimeoutInSeconds(Integer.valueOf(30));
        parameter.setConnectionCharset("UTF-8");
        parameter.setConnectionCharsetNumber(Byte.valueOf((byte)33));
        parameter.setReceiveBufferSize(Integer.valueOf(8192));
        parameter.setSendBufferSize(Integer.valueOf(8192));
        parameter.setDetectingEnable(Boolean.valueOf(false));
        parameter.setDdlIsolation(Boolean.valueOf(sourceConfig.isDdlSync()));
        parameter.setFilterTableError(Boolean.valueOf(sourceConfig.isFilterTableError()));
        parameter.setMemoryStorageRawEntry(Boolean.valueOf(false));
        canal.setCanalParameter(parameter);
        return canal;
    }

    public void start() throws Exception {
        if (this.running) {
            return;
        }
        this.tableMgr.start();
        this.canalServer.start();
        this.canalServer.start(this.sourceConfig.getDestination());
        this.clientIdentity = new ClientIdentity(this.sourceConfig.getDestination(), this.sourceConfig.getClientId().shortValue(), this.tableFilter);
        this.canalServer.subscribe(this.clientIdentity);
        this.running = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getSourceConnectorConfig().getConnectorName();
    }

    public void onException(ConnectRecord record) {
    }

    public void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.canalServer.stop(this.sourceConfig.getDestination());
        this.canalServer.stop();
    }

    public List<ConnectRecord> poll() {
        ArrayList<CanalEntry.Entry> entries;
        int emptyTimes = 0;
        Message message = null;
        if (this.sourceConfig.getBatchTimeout() < 0L) {
            while (this.running && ((message = this.canalServer.getWithoutAck(this.clientIdentity, this.sourceConfig.getBatchSize().intValue())) == null || message.getId() == -1L)) {
                this.applyWait(emptyTimes++);
            }
        } else {
            while (this.running && ((message = this.canalServer.getWithoutAck(this.clientIdentity, this.sourceConfig.getBatchSize().intValue(), this.sourceConfig.getBatchTimeout(), TimeUnit.MILLISECONDS)) == null || message.getId() == -1L)) {
            }
        }
        assert (message != null);
        if (message.isRaw()) {
            entries = new ArrayList<CanalEntry.Entry>(message.getRawEntries().size());
            for (ByteString entry : message.getRawEntries()) {
                try {
                    entries.add(CanalEntry.Entry.parseFrom((ByteString)entry));
                }
                catch (InvalidProtocolBufferException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            entries = message.getEntries();
        }
        ArrayList<ConnectRecord> result = new ArrayList<ConnectRecord>();
        Map<Long, List<CanalConnectRecord>> connectorRecordMap = EntryParser.parse(this.sourceConfig, entries, this.tableMgr);
        if (!connectorRecordMap.isEmpty()) {
            Set<Map.Entry<Long, List<CanalConnectRecord>>> entrySet = connectorRecordMap.entrySet();
            for (Map.Entry<Long, List<CanalConnectRecord>> entry : entrySet) {
                int i;
                List<CanalConnectRecord> connectRecordList = entry.getValue();
                CanalConnectRecord lastRecord = entry.getValue().get(connectRecordList.size() - 1);
                CanalRecordPartition canalRecordPartition = new CanalRecordPartition();
                canalRecordPartition.setServerUUID(this.sourceConfig.getServerUUID());
                canalRecordPartition.setJournalName(lastRecord.getJournalName());
                canalRecordPartition.setTimeStamp(Long.valueOf(lastRecord.getExecuteTime()));
                Long binLogOffset = entry.getKey();
                CanalRecordOffset canalRecordOffset = new CanalRecordOffset();
                canalRecordOffset.setOffset(binLogOffset);
                if (StringUtils.isNotEmpty((CharSequence)lastRecord.getGtid()) && StringUtils.isNotEmpty((CharSequence)lastRecord.getCurrentGtid())) {
                    canalRecordOffset.setGtid(lastRecord.getGtid());
                    canalRecordOffset.setCurrentGtid(lastRecord.getCurrentGtid());
                }
                ArrayList<List<CanalConnectRecord>> splitLists = new ArrayList<List<CanalConnectRecord>>();
                for (i = 0; i < connectRecordList.size(); i += this.sourceConfig.getBatchSize().intValue()) {
                    int end = Math.min(i + this.sourceConfig.getBatchSize(), connectRecordList.size());
                    List<CanalConnectRecord> subList = connectRecordList.subList(i, end);
                    splitLists.add(subList);
                }
                for (i = 0; i < splitLists.size(); ++i) {
                    ConnectRecord connectRecord = new ConnectRecord((RecordPartition)canalRecordPartition, (RecordOffset)canalRecordOffset, Long.valueOf(System.currentTimeMillis()));
                    connectRecord.addExtension("messageId", (Object)String.valueOf(message.getId()));
                    connectRecord.addExtension("batchIndex", (Object)i);
                    connectRecord.addExtension("totalBatches", (Object)splitLists.size());
                    connectRecord.setData((Object)JsonUtils.toJSONString(splitLists.get(i)).getBytes(StandardCharsets.UTF_8));
                    result.add(connectRecord);
                }
            }
            log.debug("message {} has been processed", (Object)message);
        }
        log.debug("ack message, messageId {}", (Object)message.getId());
        this.canalServer.ack(this.clientIdentity, message.getId());
        return result;
    }

    private void applyWait(int emptyTimes) {
        int newEmptyTimes = Math.min(emptyTimes, 10);
        if (emptyTimes <= 3) {
            Thread.yield();
        } else {
            LockSupport.parkNanos(1000000L * (long)newEmptyTimes);
        }
    }
}

