/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.dialect.mysql;

import com.mysql.cj.MysqlType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcConfig;
import org.apache.eventmesh.connector.jdbc.DataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.JdbcDriverMetaData;
import org.apache.eventmesh.connector.jdbc.connection.mysql.MysqlJdbcConnection;
import org.apache.eventmesh.connector.jdbc.dialect.AbstractGeneralDatabaseDialect;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseType;
import org.apache.eventmesh.connector.jdbc.exception.CatalogException;
import org.apache.eventmesh.connector.jdbc.exception.DatabaseNotExistException;
import org.apache.eventmesh.connector.jdbc.exception.TableNotExistException;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDataTypeConvertor;
import org.apache.eventmesh.connector.jdbc.source.dialect.mysql.MysqlDialectSql;
import org.apache.eventmesh.connector.jdbc.table.catalog.CatalogTable;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.DefaultColumn;
import org.apache.eventmesh.connector.jdbc.table.catalog.Options;
import org.apache.eventmesh.connector.jdbc.table.catalog.PrimaryKey;
import org.apache.eventmesh.connector.jdbc.table.catalog.Table;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableSchema;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlColumn;
import org.apache.eventmesh.connector.jdbc.table.catalog.mysql.MysqlOptions;
import org.apache.eventmesh.connector.jdbc.type.Type;
import org.apache.eventmesh.connector.jdbc.type.mysql.BitType;
import org.apache.eventmesh.connector.jdbc.type.mysql.BytesType;
import org.apache.eventmesh.connector.jdbc.type.mysql.DecimalType;
import org.apache.eventmesh.connector.jdbc.type.mysql.EnumType;
import org.apache.eventmesh.connector.jdbc.type.mysql.GeometryCollectionType;
import org.apache.eventmesh.connector.jdbc.type.mysql.GeometryType;
import org.apache.eventmesh.connector.jdbc.type.mysql.IntType;
import org.apache.eventmesh.connector.jdbc.type.mysql.JsonType;
import org.apache.eventmesh.connector.jdbc.type.mysql.LineStringType;
import org.apache.eventmesh.connector.jdbc.type.mysql.MediumintType;
import org.apache.eventmesh.connector.jdbc.type.mysql.MultiLineStringType;
import org.apache.eventmesh.connector.jdbc.type.mysql.MultiPointType;
import org.apache.eventmesh.connector.jdbc.type.mysql.MultiPolygonType;
import org.apache.eventmesh.connector.jdbc.type.mysql.PointType;
import org.apache.eventmesh.connector.jdbc.type.mysql.PolygonType;
import org.apache.eventmesh.connector.jdbc.type.mysql.SetType;
import org.apache.eventmesh.connector.jdbc.type.mysql.TextType;
import org.apache.eventmesh.connector.jdbc.type.mysql.TinyIntType;
import org.apache.eventmesh.connector.jdbc.type.mysql.YearType;
import org.apache.eventmesh.connector.jdbc.utils.MysqlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlDatabaseDialect
extends AbstractGeneralDatabaseDialect<MysqlJdbcConnection, MysqlColumn> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MysqlDatabaseDialect.class);
    private MysqlJdbcConnection connection;
    private DataTypeConvertor<MysqlType> dataTypeConvertor = new MysqlDataTypeConvertor();
    private JdbcConfig config;

    public MysqlDatabaseDialect(JdbcConfig config) {
        super(config);
        this.config = config;
    }

    @Override
    public void init() {
        boolean initSuccess;
        do {
            try {
                this.connection = this.initJdbcConnection();
                initSuccess = true;
            }
            catch (Exception e) {
                log.error("Init jdbc connection error,The connection will be retried in three seconds", (Throwable)e);
                initSuccess = false;
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
        } while (!initSuccess);
        super.registerTypes();
        this.registerType(BitType.INSTANCE);
        this.registerType(SetType.INSTANCE);
        this.registerType(EnumType.INSTANCE);
        this.registerType(TinyIntType.INSTANCE);
        this.registerType(JsonType.INSTANCE);
        this.registerType(IntType.INSTANCE);
        this.registerType(MediumintType.INSTANCE);
        this.registerType(DecimalType.INSTANCE);
        this.registerType(TextType.INSTANCE);
        this.registerType(YearType.INSTANCE);
        this.registerType(BytesType.INSTANCE);
        this.registerType(PointType.INSTANCE);
        this.registerType(MultiPointType.INSTANCE);
        this.registerType(GeometryType.INSTANCE);
        this.registerType(GeometryCollectionType.INSTANCE);
        this.registerType(LineStringType.INSTANCE);
        this.registerType(MultiLineStringType.INSTANCE);
        this.registerType(PolygonType.INSTANCE);
        this.registerType(MultiPolygonType.INSTANCE);
    }

    @Override
    public void start() {
    }

    private MysqlJdbcConnection initJdbcConnection() {
        try {
            return new MysqlJdbcConnection(this.config, null, false);
        }
        catch (Exception e) {
            throw new CatalogException(e);
        }
    }

    @Override
    public void open() throws CatalogException {
    }

    @Override
    public String getDefaultDatabase() {
        return null;
    }

    @Override
    public boolean databaseExists(String databaseName) throws CatalogException {
        if (databaseName == null || databaseName.trim().isEmpty()) {
            return false;
        }
        List<String> databases = this.listDatabases();
        return databases.contains(databaseName);
    }

    @Override
    public List<String> listDatabases() throws CatalogException {
        ArrayList<String> databases = new ArrayList<String>(16);
        try {
            this.connection.query(MysqlDialectSql.SHOW_DATABASE.ofSQL(), resultSet -> {
                while (resultSet.next()) {
                    databases.add(resultSet.getString("Database"));
                }
            });
        }
        catch (SQLException e) {
            log.error("List Mysql database error", (Throwable)e);
            throw new CatalogException(e);
        }
        return databases;
    }

    @Override
    public List<TableId> listTables(String databaseName) throws CatalogException, DatabaseNotExistException, SQLException {
        ArrayList<TableId> tableIds = new ArrayList<TableId>(32);
        String sql = MysqlDialectSql.SHOW_DATABASE_TABLE.ofWrapperSQL("`" + databaseName + "`");
        log.debug("List tables SQL:{}", (Object)sql);
        this.connection.query(sql, resultSet -> {
            while (resultSet.next()) {
                TableId tableId = new TableId(databaseName, null, resultSet.getString(1));
                tableIds.add(tableId);
            }
        });
        return tableIds;
    }

    @Override
    public boolean tableExists(TableId tableId) throws CatalogException, SQLException {
        List<TableId> tableIds = this.listTables(tableId.getCatalogName());
        return tableIds.contains(tableId);
    }

    @Override
    public CatalogTable getTable(TableId tableId) throws CatalogException, TableNotExistException, SQLException {
        Objects.requireNonNull(tableId, "TableId is null");
        if (!this.tableExists(tableId)) {
            log.error("Table {} not exist in database", (Object)tableId);
            throw new CatalogException(String.format("Table %s not exist in database", tableId));
        }
        CatalogTable table = new CatalogTable();
        table.setTableId(tableId);
        TableSchema tableSchema = new TableSchema();
        table.setTableSchema(tableSchema);
        String createTableSql = MysqlDialectSql.SHOW_CREATE_TABLE.ofWrapperSQL(tableId.getId());
        log.debug("Show create table SQL:{}", (Object)createTableSql);
        this.connection.query(createTableSql, resultSet -> {
            boolean hasNext = resultSet.next();
            if (!hasNext) {
                throw new CatalogException(String.format("Table %s not exist in database", tableId.getId()));
            }
            String creatTableSql = resultSet.getString("Create Table");
        });
        String selectTableSql = MysqlDialectSql.SELECT_TABLE_COLUMNS.ofWrapperSQL(tableId.getId());
        log.debug("Select table SQL:{}", (Object)selectTableSql);
        HashMap columns = new HashMap(16);
        this.connection.query(selectTableSql, resultSet -> {
            ResultSetMetaData tableMetaData = resultSet.getMetaData();
            int columnCount = tableMetaData.getColumnCount();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String columnName = tableMetaData.getColumnName(columnIndex);
                DefaultColumn column = columns.computeIfAbsent(columnName, key -> new DefaultColumn());
                column.setName(columnName);
                int precision = tableMetaData.getPrecision(columnIndex);
                HashMap<String, Object> dataTypeProperties = new HashMap<String, Object>();
                dataTypeProperties.put("precision", precision);
                int scale = tableMetaData.getScale(columnIndex);
                dataTypeProperties.put("scale", scale);
                column.setDataType(this.dataTypeConvertor.toEventMeshType(MysqlType.getByJdbcType((int)tableMetaData.getColumnType(columnIndex)), dataTypeProperties));
                column.setDecimal(scale);
            }
        });
        String showTableSql = MysqlDialectSql.SHOW_TABLE_COLUMNS.ofWrapperSQL(tableId.getTableName(), tableId.getCatalogName());
        log.debug("Show table columns SQL:{}", (Object)showTableSql);
        ArrayList columnList = new ArrayList(columns.size());
        this.connection.query(showTableSql, resultSet -> {
            boolean hasNext = resultSet.next();
            if (!hasNext) {
                throw new CatalogException(String.format("Table %s without columns", tableId.getId()));
            }
            ArrayList<String> columnNames = new ArrayList<String>(4);
            do {
                String field = resultSet.getString("Field");
                DefaultColumn column = (DefaultColumn)columns.get(field);
                String comment = resultSet.getString("Comment");
                column.setComment(comment);
                String enableNull = resultSet.getString("Null");
                column.setNotNull("NO".equalsIgnoreCase(enableNull));
                String type = resultSet.getString("Type");
                Object defaultValue = resultSet.getObject("Default");
                column.setDefaultValue(defaultValue);
                String key = resultSet.getString("Key");
                if ("PRI".equalsIgnoreCase(key)) {
                    columnNames.add(field);
                }
                columnList.add(column);
            } while (resultSet.next());
            tableSchema.setColumns(columnList);
            tableSchema.setColumnMap(columns);
            if (!columnNames.isEmpty()) {
                tableSchema.setPrimaryKey(new PrimaryKey(columnNames));
            }
        });
        return table;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.MYSQL;
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        Objects.requireNonNull(connection, "Connection is null");
        Objects.requireNonNull(sql, "SQL is null");
        return connection.prepareStatement(sql);
    }

    @Override
    public String getQualifiedTableName(TableId tableId) {
        return MysqlUtils.wrapper(tableId);
    }

    @Override
    public String getQualifiedText(String text) {
        return MysqlUtils.wrapper(text);
    }

    @Override
    public JdbcDriverMetaData getJdbcDriverMetaData() {
        return this.connection.getJdbcDriverMetaData();
    }

    @Override
    public String jdbcProtocol() {
        return "jdbc:mysql://%s:%s/?useInformationSchema=true&nullCatalogMeansCurrent=false&useUnicode=true&characterEncoding=UTF-8&characterSetResults=UTF-8&zeroDateTimeBehavior=CONVERT_TO_NULL&connectTimeout=%s";
    }

    @Override
    public MysqlJdbcConnection getConnection() {
        return this.connection;
    }

    @Override
    public MysqlJdbcConnection newConnection() {
        return this.initJdbcConnection();
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    @Override
    public String getAutoIncrementFormatted(Column<?> column) {
        return " AUTO_INCREMENT ";
    }

    @Override
    public String getDefaultValueFormatted(Column<?> column) {
        Type type = this.getType(column);
        String defaultValue = type.getDefaultValue(this, column);
        return defaultValue;
    }

    @Override
    public String getCharsetOrCollateFormatted(Column<?> column) {
        String collationName;
        StringBuilder builder = new StringBuilder();
        String charsetName = column.getCharsetName();
        if (StringUtils.isNotBlank((CharSequence)charsetName)) {
            builder.append(" CHARACTER SET ").append(charsetName).append(" ");
        }
        if (StringUtils.isNotBlank((CharSequence)(collationName = column.getCollationName()))) {
            builder.append(" COLLATE ").append(collationName).append(" ");
        }
        return builder.toString();
    }

    @Override
    public String getTableOptionsFormatted(Table table) {
        String comment;
        String collate;
        String charset;
        String autoIncrementNumber;
        Options options = table.getOptions();
        if (Objects.isNull(options) || options.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String engine = (String)options.get(MysqlOptions.MysqlTableOptions.ENGINE);
        if (StringUtils.isNotBlank((CharSequence)engine)) {
            builder.append(String.format("ENGINE=%s ", engine));
        }
        if (StringUtils.isNotBlank((CharSequence)(autoIncrementNumber = (String)options.get(MysqlOptions.MysqlTableOptions.AUTO_INCREMENT)))) {
            builder.append(String.format("AUTO_INCREMENT=%s ", autoIncrementNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)(charset = (String)options.get(MysqlOptions.MysqlTableOptions.CHARSET)))) {
            builder.append(String.format("DEFAULT CHARSET=%s ", charset));
        }
        if (StringUtils.isNotBlank((CharSequence)(collate = (String)options.get(MysqlOptions.MysqlTableOptions.COLLATE)))) {
            builder.append(String.format(" COLLATE=%s ", collate));
        }
        if (StringUtils.isNotBlank((CharSequence)(comment = table.getComment()))) {
            builder.append(String.format(" COMMENT='%s' ", comment));
        }
        return builder.toString();
    }

    @Override
    public String getCommentFormatted(Column<?> column) {
        if (StringUtils.isEmpty((CharSequence)column.getComment())) {
            return "";
        }
        return "COMMENT '" + column.getComment() + "'";
    }
}

