/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.source;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcSourceConfig;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.jdbc.JdbcRecordOffset;
import org.apache.eventmesh.common.remote.offset.jdbc.JdbcRecordPartition;
import org.apache.eventmesh.connector.jdbc.JdbcConnectData;
import org.apache.eventmesh.connector.jdbc.event.Event;
import org.apache.eventmesh.connector.jdbc.source.AbstractJdbcTaskManager;
import org.apache.eventmesh.connector.jdbc.source.SourceEventMeshJdbcEventTask;
import org.apache.eventmesh.connector.jdbc.source.TaskManagerListener;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.RandomTaskSelectStrategy;
import org.apache.eventmesh.connector.jdbc.source.dialect.cdc.TaskSelectStrategy;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceJdbcTaskManager
extends AbstractJdbcTaskManager<SourceEventMeshJdbcEventTask> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SourceJdbcTaskManager.class);
    private final Set<TableId> includeDatabaseTable;
    private final JdbcSourceConfig jdbcSourceConfig;
    private TaskSelectStrategy<SourceEventMeshJdbcEventTask> cdcTaskSelectStrategy;

    public SourceJdbcTaskManager(Set<TableId> includeDatabaseTable, JdbcSourceConfig jdbcSourceConfig) {
        this.jdbcSourceConfig = jdbcSourceConfig;
        this.includeDatabaseTable = includeDatabaseTable == null ? new HashSet() : includeDatabaseTable;
    }

    @Override
    public void init() {
        int maxTaskNum = this.jdbcSourceConfig.getSourceConnectorConfig().getMaxTask();
        int taskNum = Math.min(maxTaskNum, this.includeDatabaseTable.size());
        log.info("Source jdbc task num {}", (Object)taskNum);
        for (int index = 0; index < taskNum; ++index) {
            SourceEventMeshJdbcEventTask eventTask = new SourceEventMeshJdbcEventTask("source-jdbc-task-" + (index + 1));
            eventTask.registerEventHandler(this::doHandleEvent);
            this.taskList.add(eventTask);
        }
        this.cdcTaskSelectStrategy = new RandomTaskSelectStrategy<SourceEventMeshJdbcEventTask>(this.taskList);
    }

    private void doHandleEvent(Event event) {
        if (event == null) {
            return;
        }
        JdbcConnectData jdbcConnectData = event.getJdbcConnectData();
        JdbcRecordPartition partition = new JdbcRecordPartition();
        JdbcRecordOffset offset = new JdbcRecordOffset();
        ConnectRecord record = new ConnectRecord((RecordPartition)partition, (RecordOffset)offset, Long.valueOf(System.currentTimeMillis()), (Object)jdbcConnectData);
        List<ConnectRecord> records = Collections.singletonList(record);
        for (TaskManagerListener listener : this.listeners) {
            listener.listen(records);
        }
    }

    @Override
    public SourceEventMeshJdbcEventTask select(TableId tableId) {
        return this.tableIdJdbcTaskMap.computeIfAbsent(tableId, key -> this.cdcTaskSelectStrategy.select(tableId));
    }

    public int getTaskCount() {
        return this.tableIdJdbcTaskMap.size();
    }
}

