/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.buffer;

import com.navercorp.pinpoint.common.buffer.Buffer;
import com.navercorp.pinpoint.common.buffer.FixedBuffer;
import com.navercorp.pinpoint.common.buffer.StringAllocator;
import java.util.Objects;

public class StringCacheableBuffer
extends FixedBuffer {
    private final StringAllocator stringAllocator;

    public StringCacheableBuffer(byte[] buffer, StringAllocator stringAllocator) {
        super(buffer);
        this.stringAllocator = Objects.requireNonNull(stringAllocator, "stringAllocator");
    }

    @Override
    protected String readString(int size) {
        this.checkBounds(this.buffer, this.offset, size);
        String newValue = this.stringAllocator.allocate(this.buffer, this.offset, size, Buffer.UTF8_CHARSET);
        this.offset += size;
        return newValue;
    }

    private void checkBounds(byte[] bytes, int offset, int size) {
        if (size < 0) {
            throw new StringIndexOutOfBoundsException(size);
        }
        if (offset < 0) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        if (bytes.length < offset + size) {
            throw new StringIndexOutOfBoundsException(offset + size);
        }
    }
}

