/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.packets.server;

import com.alibaba.otter.canal.parse.driver.mysql.packets.PacketWithHeaderPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.ByteHelper;
import java.io.IOException;

public class ErrorPacket
extends PacketWithHeaderPacket {
    public byte fieldCount;
    public int errorNumber;
    public byte sqlStateMarker;
    public byte[] sqlState;
    public String message;

    @Override
    public void fromBytes(byte[] data) {
        int index = 0;
        this.fieldCount = data[0];
        this.errorNumber = ByteHelper.readUnsignedShortLittleEndian(data, ++index);
        this.sqlStateMarker = data[index += 2];
        this.sqlState = ByteHelper.readFixedLengthBytes(data, ++index, 5);
        this.message = new String(ByteHelper.readFixedLengthBytes(data, index += 5, data.length - index));
    }

    @Override
    public byte[] toBytes() throws IOException {
        return null;
    }

    @Override
    public String toString() {
        return "ErrorPacket [errorNumber=" + this.errorNumber + ", fieldCount=" + this.fieldCount + ", message=" + this.message + ", sqlState=" + this.sqlStateToString() + ", sqlStateMarker=" + (char)this.sqlStateMarker + "]";
    }

    private String sqlStateToString() {
        StringBuilder builder = new StringBuilder(5);
        for (byte b : this.sqlState) {
            builder.append((char)b);
        }
        return builder.toString();
    }
}

