/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class CharsetUtil {
    private static final String[] INDEX_TO_CHARSET;
    private static final Map<String, Integer> CHARSET_TO_INDEX;

    public static final String getCharset(int index) {
        return INDEX_TO_CHARSET[index];
    }

    public static final int getIndex(String charset) {
        if (charset == null || charset.length() == 0) {
            return 0;
        }
        Integer i = CHARSET_TO_INDEX.get(charset.toLowerCase());
        return i == null ? 0 : i;
    }

    public static final String collateCharset(String charset) {
        String[] output = StringUtils.split((String)charset, (String)"COLLATE");
        return output[0].replace('\'', ' ').trim();
    }

    public static String getJavaCharset(String charset) {
        if ("utf8".equals(charset)) {
            return charset;
        }
        if (StringUtils.endsWithIgnoreCase((String)charset, (String)"utf8mb4")) {
            return "utf-8";
        }
        if (StringUtils.endsWithIgnoreCase((String)charset, (String)"binary")) {
            return "iso_8859_1";
        }
        return charset;
    }

    static {
        int i;
        INDEX_TO_CHARSET = new String[2048];
        CHARSET_TO_INDEX = new HashMap<String, Integer>();
        CharsetUtil.INDEX_TO_CHARSET[1] = "big5";
        CharsetUtil.INDEX_TO_CHARSET[84] = "big5";
        CharsetUtil.INDEX_TO_CHARSET[3] = "dec8";
        CharsetUtil.INDEX_TO_CHARSET[69] = "dec8";
        CharsetUtil.INDEX_TO_CHARSET[4] = "cp850";
        CharsetUtil.INDEX_TO_CHARSET[80] = "cp850";
        CharsetUtil.INDEX_TO_CHARSET[6] = "hp8";
        CharsetUtil.INDEX_TO_CHARSET[72] = "hp8";
        CharsetUtil.INDEX_TO_CHARSET[7] = "koi8r";
        CharsetUtil.INDEX_TO_CHARSET[74] = "koi8r";
        CharsetUtil.INDEX_TO_CHARSET[5] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[8] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[15] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[31] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[47] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[48] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[49] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[94] = "latin1";
        CharsetUtil.INDEX_TO_CHARSET[9] = "latin2";
        CharsetUtil.INDEX_TO_CHARSET[21] = "latin2";
        CharsetUtil.INDEX_TO_CHARSET[27] = "latin2";
        CharsetUtil.INDEX_TO_CHARSET[77] = "latin2";
        CharsetUtil.INDEX_TO_CHARSET[10] = "swe7";
        CharsetUtil.INDEX_TO_CHARSET[82] = "swe7";
        CharsetUtil.INDEX_TO_CHARSET[11] = "ascii";
        CharsetUtil.INDEX_TO_CHARSET[65] = "ascii";
        CharsetUtil.INDEX_TO_CHARSET[12] = "ujis";
        CharsetUtil.INDEX_TO_CHARSET[91] = "ujis";
        CharsetUtil.INDEX_TO_CHARSET[13] = "sjis";
        CharsetUtil.INDEX_TO_CHARSET[88] = "sjis";
        CharsetUtil.INDEX_TO_CHARSET[16] = "hebrew";
        CharsetUtil.INDEX_TO_CHARSET[71] = "hebrew";
        CharsetUtil.INDEX_TO_CHARSET[18] = "tis620";
        CharsetUtil.INDEX_TO_CHARSET[69] = "tis620";
        CharsetUtil.INDEX_TO_CHARSET[19] = "euckr";
        CharsetUtil.INDEX_TO_CHARSET[85] = "euckr";
        CharsetUtil.INDEX_TO_CHARSET[22] = "koi8u";
        CharsetUtil.INDEX_TO_CHARSET[75] = "koi8u";
        CharsetUtil.INDEX_TO_CHARSET[24] = "gb2312";
        CharsetUtil.INDEX_TO_CHARSET[86] = "gb2312";
        CharsetUtil.INDEX_TO_CHARSET[25] = "greek";
        CharsetUtil.INDEX_TO_CHARSET[70] = "greek";
        CharsetUtil.INDEX_TO_CHARSET[26] = "cp1250";
        CharsetUtil.INDEX_TO_CHARSET[34] = "cp1250";
        CharsetUtil.INDEX_TO_CHARSET[44] = "cp1250";
        CharsetUtil.INDEX_TO_CHARSET[66] = "cp1250";
        CharsetUtil.INDEX_TO_CHARSET[99] = "cp1250";
        CharsetUtil.INDEX_TO_CHARSET[28] = "gbk";
        CharsetUtil.INDEX_TO_CHARSET[87] = "gbk";
        CharsetUtil.INDEX_TO_CHARSET[30] = "latin5";
        CharsetUtil.INDEX_TO_CHARSET[78] = "latin5";
        CharsetUtil.INDEX_TO_CHARSET[32] = "armscii8";
        CharsetUtil.INDEX_TO_CHARSET[64] = "armscii8";
        CharsetUtil.INDEX_TO_CHARSET[33] = "utf8";
        CharsetUtil.INDEX_TO_CHARSET[83] = "utf8";
        for (i = 192; i <= 223; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8";
        }
        for (i = 336; i <= 337; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8";
        }
        for (i = 352; i <= 357; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8";
        }
        CharsetUtil.INDEX_TO_CHARSET[368] = "utf8";
        CharsetUtil.INDEX_TO_CHARSET[2047] = "utf8";
        CharsetUtil.INDEX_TO_CHARSET[35] = "ucs2";
        CharsetUtil.INDEX_TO_CHARSET[90] = "ucs2";
        for (i = 128; i <= 151; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "ucs2";
        }
        CharsetUtil.INDEX_TO_CHARSET[159] = "ucs2";
        for (i = 358; i <= 360; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "ucs2";
        }
        CharsetUtil.INDEX_TO_CHARSET[36] = "cp866";
        CharsetUtil.INDEX_TO_CHARSET[68] = "cp866";
        CharsetUtil.INDEX_TO_CHARSET[37] = "keybcs2";
        CharsetUtil.INDEX_TO_CHARSET[73] = "keybcs2";
        CharsetUtil.INDEX_TO_CHARSET[38] = "macce";
        CharsetUtil.INDEX_TO_CHARSET[43] = "macce";
        CharsetUtil.INDEX_TO_CHARSET[39] = "macroman";
        CharsetUtil.INDEX_TO_CHARSET[53] = "macroman";
        CharsetUtil.INDEX_TO_CHARSET[40] = "cp852";
        CharsetUtil.INDEX_TO_CHARSET[81] = "cp852";
        CharsetUtil.INDEX_TO_CHARSET[20] = "latin7";
        CharsetUtil.INDEX_TO_CHARSET[41] = "latin7";
        CharsetUtil.INDEX_TO_CHARSET[42] = "latin7";
        CharsetUtil.INDEX_TO_CHARSET[79] = "latin7";
        CharsetUtil.INDEX_TO_CHARSET[45] = "utf8mb4";
        CharsetUtil.INDEX_TO_CHARSET[46] = "utf8mb4";
        for (i = 224; i <= 247; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8mb4";
        }
        for (i = 255; i <= 271; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8mb4";
        }
        for (i = 273; i <= 275; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8mb4";
        }
        for (i = 277; i <= 294; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8mb4";
        }
        for (i = 296; i <= 298; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8mb4";
        }
        CharsetUtil.INDEX_TO_CHARSET[300] = "utf8mb4";
        for (i = 303; i <= 307; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf8mb4";
        }
        CharsetUtil.INDEX_TO_CHARSET[326] = "utf8mb4";
        CharsetUtil.INDEX_TO_CHARSET[328] = "utf8mb4";
        CharsetUtil.INDEX_TO_CHARSET[14] = "cp1251";
        CharsetUtil.INDEX_TO_CHARSET[23] = "cp1251";
        CharsetUtil.INDEX_TO_CHARSET[50] = "cp1251";
        CharsetUtil.INDEX_TO_CHARSET[51] = "cp1251";
        CharsetUtil.INDEX_TO_CHARSET[52] = "cp1251";
        CharsetUtil.INDEX_TO_CHARSET[54] = "utf16";
        CharsetUtil.INDEX_TO_CHARSET[55] = "utf16";
        for (i = 101; i <= 124; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf16";
        }
        CharsetUtil.INDEX_TO_CHARSET[327] = "utf16";
        CharsetUtil.INDEX_TO_CHARSET[56] = "utf16le";
        CharsetUtil.INDEX_TO_CHARSET[62] = "utf16le";
        CharsetUtil.INDEX_TO_CHARSET[57] = "cp1256";
        CharsetUtil.INDEX_TO_CHARSET[67] = "cp1256";
        CharsetUtil.INDEX_TO_CHARSET[29] = "cp1257";
        CharsetUtil.INDEX_TO_CHARSET[58] = "cp1257";
        CharsetUtil.INDEX_TO_CHARSET[59] = "cp1257";
        CharsetUtil.INDEX_TO_CHARSET[60] = "utf32";
        CharsetUtil.INDEX_TO_CHARSET[61] = "utf32";
        for (i = 160; i <= 183; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "utf32";
        }
        CharsetUtil.INDEX_TO_CHARSET[391] = "utf32";
        CharsetUtil.INDEX_TO_CHARSET[63] = "binary";
        CharsetUtil.INDEX_TO_CHARSET[92] = "geostd8";
        CharsetUtil.INDEX_TO_CHARSET[93] = "geostd8";
        CharsetUtil.INDEX_TO_CHARSET[95] = "cp932";
        CharsetUtil.INDEX_TO_CHARSET[96] = "cp932";
        CharsetUtil.INDEX_TO_CHARSET[97] = "eucjpms";
        CharsetUtil.INDEX_TO_CHARSET[98] = "eucjpms";
        for (i = 248; i <= 250; ++i) {
            CharsetUtil.INDEX_TO_CHARSET[i] = "gb18030";
        }
        for (i = 0; i < 2048; ++i) {
            String charset = INDEX_TO_CHARSET[i];
            if (charset == null || CHARSET_TO_INDEX.get(charset) != null) continue;
            CHARSET_TO_INDEX.put(charset, i);
        }
        CHARSET_TO_INDEX.put("iso-8859-1", 14);
        CHARSET_TO_INDEX.put("iso_8859_1", 14);
        CHARSET_TO_INDEX.put("utf-8", 33);
        CHARSET_TO_INDEX.put("utf8mb4", 45);
    }
}

