/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.api.search.query;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class Document {
    private final String id;
    private Map<String, Object> attributes;
    private byte[] payload;
    private Double score;

    public Document(String id) {
        this.id = id;
    }

    public Document(String id, Map<String, Object> attributes) {
        this.id = id;
        this.attributes = attributes;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public Double getScore() {
        return this.score;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return Objects.equals(this.id, document.id) && Objects.equals(this.attributes, document.attributes) && Arrays.equals(this.payload, document.payload) && Objects.equals(this.score, document.score);
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.attributes, this.score);
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }
}

