/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.data;

import java.net.URI;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.KeyValue;

public class DefaultKeyValue
implements KeyValue {
    private final Map<String, Object> properties = new ConcurrentHashMap<String, Object>();

    @Override
    public KeyValue put(String key, Boolean value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public KeyValue put(String key, Number value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public KeyValue put(String key, byte[] value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public KeyValue put(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public KeyValue put(String key, URI value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public KeyValue put(String key, OffsetDateTime value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public KeyValue put(String key, Object value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public boolean getBoolean(String key) {
        if (!this.properties.containsKey(key)) {
            return false;
        }
        Object val = this.properties.get(key);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return false;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.properties.containsKey(key) ? this.getBoolean(key) : defaultValue;
    }

    @Override
    public byte getByte(String key) {
        if (!this.properties.containsKey(key)) {
            return 0;
        }
        Object val = this.properties.get(key);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        return 0;
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.properties.containsKey(key) ? this.getByte(key) : defaultValue;
    }

    @Override
    public short getShort(String key) {
        if (!this.properties.containsKey(key)) {
            return 0;
        }
        Object val = this.properties.get(key);
        if (val instanceof Short) {
            return (Short)val;
        }
        return 0;
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.properties.containsKey(key) ? this.getShort(key) : defaultValue;
    }

    @Override
    public int getInt(String key) {
        if (!this.properties.containsKey(key)) {
            return 0;
        }
        Object val = this.properties.get(key);
        if (val instanceof Integer) {
            return (Integer)val;
        }
        return 0;
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return this.properties.containsKey(key) ? this.getInt(key) : defaultValue;
    }

    @Override
    public long getLong(String key) {
        if (!this.properties.containsKey(key)) {
            return 0L;
        }
        Object val = this.properties.get(key);
        if (val instanceof Long) {
            return (Long)val;
        }
        return 0L;
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.properties.containsKey(key) ? this.getLong(key) : defaultValue;
    }

    @Override
    public float getFloat(String key) {
        if (!this.properties.containsKey(key)) {
            return 0.0f;
        }
        Object val = this.properties.get(key);
        if (val instanceof Float) {
            return ((Float)val).floatValue();
        }
        return 0.0f;
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.properties.containsKey(key) ? this.getFloat(key) : defaultValue;
    }

    @Override
    public double getDouble(String key) {
        if (!this.properties.containsKey(key)) {
            return 0.0;
        }
        Object val = this.properties.get(key);
        if (val instanceof Double) {
            return (Double)val;
        }
        return 0.0;
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.properties.containsKey(key) ? this.getDouble(key) : defaultValue;
    }

    @Override
    public byte[] getBytes(String key) {
        if (!this.properties.containsKey(key)) {
            return new byte[0];
        }
        Object val = this.properties.get(key);
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        return new byte[0];
    }

    @Override
    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.properties.containsKey(key) ? this.getBytes(key) : defaultValue;
    }

    @Override
    public String getString(String key) {
        if (!this.properties.containsKey(key)) {
            return "";
        }
        Object val = this.properties.get(key);
        if (val instanceof String) {
            return (String)val;
        }
        return "";
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.properties.containsKey(key) ? this.getString(key) : defaultValue;
    }

    @Override
    public URI getURI(String key) {
        if (!this.properties.containsKey(key)) {
            return null;
        }
        Object val = this.properties.get(key);
        if (val instanceof URI) {
            return (URI)val;
        }
        return null;
    }

    @Override
    public URI getURI(String key, URI defaultValue) {
        return this.properties.containsKey(key) ? this.getURI(key) : defaultValue;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key) {
        if (!this.properties.containsKey(key)) {
            return null;
        }
        Object val = this.properties.get(key);
        if (val instanceof OffsetDateTime) {
            return (OffsetDateTime)val;
        }
        return null;
    }

    @Override
    public OffsetDateTime getOffsetDateTime(String key, OffsetDateTime defaultValue) {
        return this.properties.containsKey(key) ? this.getOffsetDateTime(key) : defaultValue;
    }

    @Override
    public Object getObject(String key) {
        return this.properties.getOrDefault(key, null);
    }

    @Override
    public Object getObject(String key, Object defaultValue) {
        return this.properties.getOrDefault(key, defaultValue);
    }

    @Override
    public <T> T getObject(String key, Class<T> c) {
        if (!this.properties.containsKey(key)) {
            return null;
        }
        Object val = this.properties.get(key);
        if (val.getClass() == c) {
            return (T)val;
        }
        return null;
    }

    @Override
    public <T> T getObject(String key, T defaultValue, Class<T> c) {
        return this.properties.containsKey(key) ? this.getObject(key, c) : defaultValue;
    }

    @Override
    public Set<String> keySet() {
        return this.properties.keySet();
    }

    @Override
    public boolean containsKey(String key) {
        return this.properties.containsKey(key);
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }
}

