/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.shell.osgi;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.karaf.shell.console.OsgiCommandSupport;
import org.apache.felix.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;

public abstract class BundleCommand
extends OsgiCommandSupport {
    @Argument(index=0, name="id", description="The bundle ID", required=true, multiValued=false)
    long id;
    @Option(name="--force", aliases={}, description="Forces the command to execute", required=false, multiValued=false)
    boolean force;

    protected Object doExecute() throws Exception {
        Bundle bundle = this.getBundleContext().getBundle(this.id);
        if (bundle == null) {
            System.out.println("Bundle " + this.id + " not found");
            return null;
        }
        if (!this.force && Util.isASystemBundle(this.getBundleContext(), bundle) && !Util.accessToSystemBundleIsAllowed(bundle.getBundleId(), this.session)) {
            return null;
        }
        this.doExecute(bundle);
        return null;
    }

    protected abstract void doExecute(Bundle var1) throws Exception;
}

