/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkConsole;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.util.NLS;

public class ConsoleManager {
    public static final String PROP_CONSOLE = "osgi.console";
    private static final String CONSOLE_NAME = "OSGi Console";
    private FrameworkConsole console;

    public static ConsoleManager startConsole(Framework equinox) {
        String consolePort = FrameworkProperties.getProperty(PROP_CONSOLE);
        if (consolePort != null) {
            ConsoleManager consoleMgr = new ConsoleManager();
            consoleMgr.startConsole(equinox, new String[0], consolePort);
            return consoleMgr;
        }
        return null;
    }

    public void startConsole(Framework equinox, String[] consoleArgs, String consolePort) {
        try {
            this.console = consolePort.length() == 0 ? new FrameworkConsole(equinox, consoleArgs) : new FrameworkConsole(equinox, Integer.parseInt(consolePort), consoleArgs);
            Thread t = new Thread((Runnable)this.console, CONSOLE_NAME);
            t.setDaemon(false);
            t.start();
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println(NLS.bind(EclipseAdaptorMsg.ECLIPSE_STARTUP_INVALID_PORT, consolePort));
        }
    }

    public void stopConsole() {
        if (this.console == null) {
            return;
        }
        this.console.shutdown();
    }
}

