/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.felix.connect.Revision;
import org.apache.felix.connect.felix.framework.capabilityset.SimpleFilter;

class EntryFilterEnumeration<T>
implements Enumeration<T> {
    private final Enumeration<String> m_enumeration;
    private final Revision m_revision;
    private final String m_path;
    private final List<String> m_filePattern;
    private final boolean m_recurse;
    private final boolean m_isURLValues;
    private final Set<String> m_dirEntries = new HashSet<String>();
    private final List<T> m_nextEntries = new ArrayList<T>(2);

    public EntryFilterEnumeration(Revision rev, boolean includeFragments, String path, String filePattern, boolean recurse, boolean isURLValues) {
        this.m_revision = rev;
        this.m_enumeration = rev.getEntries();
        this.m_recurse = recurse;
        this.m_isURLValues = isURLValues;
        if (path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        this.m_path = path;
        filePattern = filePattern == null ? "*" : filePattern;
        this.m_filePattern = SimpleFilter.parseSubstring(filePattern);
        this.findNext();
    }

    @Override
    public synchronized boolean hasMoreElements() {
        return this.m_nextEntries.size() != 0;
    }

    @Override
    public synchronized T nextElement() {
        if (this.m_nextEntries.size() == 0) {
            throw new NoSuchElementException("No more entries.");
        }
        T last = this.m_nextEntries.remove(0);
        this.findNext();
        return last;
    }

    private void findNext() {
        if (this.m_enumeration == null) {
            return;
        }
        if (this.m_nextEntries.size() == 0) {
            while (this.m_enumeration.hasMoreElements() && this.m_nextEntries.size() == 0) {
                String entryName = this.m_enumeration.nextElement();
                if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path)) continue;
                URL entryURL = null;
                int dirSlashIdx = entryName.indexOf(47, this.m_path.length());
                if (dirSlashIdx >= 0) {
                    int subDirSlashIdx = dirSlashIdx;
                    do {
                        String dir;
                        if (!this.m_dirEntries.contains(dir = entryName.substring(0, subDirSlashIdx + 1))) {
                            this.m_dirEntries.add(dir);
                            if (entryName.length() != subDirSlashIdx + 1 && SimpleFilter.compareSubstring(this.m_filePattern, EntryFilterEnumeration.getLastPathElement(dir))) {
                                if (this.m_isURLValues) {
                                    entryURL = entryURL == null ? this.m_revision.getEntry(entryName) : entryURL;
                                    try {
                                        this.m_nextEntries.add(new URL(entryURL, "/" + dir));
                                    }
                                    catch (MalformedURLException malformedURLException) {}
                                } else {
                                    this.m_nextEntries.add(dir);
                                }
                            }
                        }
                        subDirSlashIdx = entryName.indexOf(47, dir.length());
                    } while (this.m_recurse && subDirSlashIdx >= 0);
                }
                if (!this.m_recurse && dirSlashIdx >= 0 && dirSlashIdx != entryName.length() - 1 || !SimpleFilter.compareSubstring(this.m_filePattern, EntryFilterEnumeration.getLastPathElement(entryName))) continue;
                if (this.m_isURLValues) {
                    entryURL = entryURL == null ? this.m_revision.getEntry(entryName) : entryURL;
                    this.m_nextEntries.add(entryURL);
                    continue;
                }
                this.m_nextEntries.add(entryName);
            }
        }
    }

    private static String getLastPathElement(String entryName) {
        int endIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.length() - 1 : entryName.length();
        int startIdx = entryName.charAt(entryName.length() - 1) == '/' ? entryName.lastIndexOf(47, endIdx - 1) + 1 : entryName.lastIndexOf(47, endIdx) + 1;
        return entryName.substring(startIdx, endIdx);
    }
}

