/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect.felix.framework;

import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.apache.felix.connect.felix.framework.ServiceRegistry;
import org.apache.felix.connect.felix.framework.util.MapToDictionary;
import org.apache.felix.connect.felix.framework.util.StringMap;
import org.apache.felix.connect.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;

class ServiceRegistrationImpl<T>
implements ServiceRegistration<T> {
    private final ServiceRegistry m_registry;
    private final Bundle m_bundle;
    private final String[] m_classes;
    private final Long m_serviceId;
    private volatile Object m_svcObj;
    private volatile ServiceFactory<T> m_factory;
    private volatile Map m_propMap = new StringMap(false);
    private final ServiceReferenceImpl<T> m_ref;
    private volatile boolean m_isUnregistering = false;

    public ServiceRegistrationImpl(ServiceRegistry registry, Bundle bundle, String[] classes, Long serviceId, Object svcObj, Dictionary dict) {
        this.m_registry = registry;
        this.m_bundle = bundle;
        this.m_classes = classes;
        this.m_serviceId = serviceId;
        this.m_svcObj = svcObj;
        this.m_factory = this.m_svcObj instanceof ServiceFactory ? (ServiceFactory)this.m_svcObj : null;
        this.initializeProperties(dict);
        this.m_ref = new ServiceReferenceImpl();
    }

    protected synchronized boolean isValid() {
        return this.m_svcObj != null;
    }

    protected synchronized void invalidate() {
        this.m_svcObj = null;
    }

    @Override
    public synchronized ServiceReferenceImpl<T> getReference() {
        if (!this.isValid()) {
            throw new IllegalStateException("The service registration is no longer valid.");
        }
        return this.m_ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Dictionary dict) {
        Map oldProps;
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid()) {
                throw new IllegalStateException("The service registration is no longer valid.");
            }
            oldProps = this.m_propMap;
            this.initializeProperties(dict);
        }
        this.m_registry.servicePropertiesModified(this, new MapToDictionary(oldProps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister() {
        ServiceRegistrationImpl serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            if (!this.isValid() || this.m_isUnregistering) {
                throw new IllegalStateException("Service already unregistered.");
            }
            this.m_isUnregistering = true;
        }
        this.m_registry.unregisterService(this.m_bundle, this);
        serviceRegistrationImpl = this;
        synchronized (serviceRegistrationImpl) {
            this.m_svcObj = null;
            this.m_factory = null;
        }
    }

    Object getProperty(String key) {
        return this.m_propMap.get(key);
    }

    private String[] getPropertyKeys() {
        Set s = this.m_propMap.keySet();
        return s.toArray(new String[s.size()]);
    }

    private Bundle[] getUsingBundles() {
        return this.m_registry.getUsingBundles(this.m_ref);
    }

    Object getService() {
        return this.m_svcObj;
    }

    Object getService(Bundle acqBundle) {
        if (this.m_factory != null) {
            Object svcObj = null;
            svcObj = this.getFactoryUnchecked(acqBundle);
            return svcObj;
        }
        return this.m_svcObj;
    }

    void ungetService(Bundle relBundle, T svcObj) {
        if (this.m_factory != null) {
            try {
                this.ungetFactoryUnchecked(relBundle, svcObj);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void initializeProperties(Dictionary dict) {
        StringMap props = new StringMap(false);
        if (dict != null) {
            Enumeration keys = dict.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                if (props.get(key) == null) {
                    props.put(key, dict.get(key));
                    continue;
                }
                throw new IllegalArgumentException("Duplicate service property: " + key);
            }
        }
        props.put("objectClass", this.m_classes);
        props.put("service.id", this.m_serviceId);
        this.m_propMap = props;
    }

    private Object getFactoryUnchecked(Bundle bundle) {
        Object svcObj = null;
        try {
            svcObj = this.m_factory.getService(bundle, this);
        }
        catch (Throwable th) {
            throw new ServiceException("Service factory exception: " + th.getMessage(), 3, th);
        }
        if (svcObj != null) {
            for (String className : this.m_classes) {
                Class clazz = Util.loadClassUsingClass(svcObj.getClass(), className);
                if (clazz != null && clazz.isAssignableFrom(svcObj.getClass())) continue;
                if (clazz == null) {
                    throw new ServiceException("Service cannot be cast due to missing class: " + className, 2);
                }
                throw new ServiceException("Service cannot be cast: " + className, 2);
            }
        } else {
            throw new ServiceException("Service factory returned null.", 2);
        }
        return svcObj;
    }

    private void ungetFactoryUnchecked(Bundle bundle, T svcObj) {
        this.m_factory.ungetService(bundle, this, svcObj);
    }

    private class ServiceReferenceMap
    implements Map<String, Object> {
        private ServiceReferenceMap() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsKey(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean containsValue(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object get(Object o) {
            return ServiceRegistrationImpl.this.getProperty((String)o);
        }

        @Override
        public Object put(String k, Object v) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object remove(Object o) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> map) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<String> keySet() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<Object> values() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return Collections.emptySet();
        }
    }

    class ServiceReferenceImpl<T>
    implements ServiceReference<T>,
    BundleCapability {
        private final ServiceReferenceMap m_map;

        private ServiceReferenceImpl() {
            this.m_map = new ServiceReferenceMap();
        }

        ServiceRegistrationImpl getRegistration() {
            return ServiceRegistrationImpl.this;
        }

        @Override
        public BundleRevision getResource() {
            return this.getRevision();
        }

        @Override
        public BundleRevision getRevision() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getNamespace() {
            return "service-reference";
        }

        @Override
        public Map<String, String> getDirectives() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, Object> getAttributes() {
            return this.m_map;
        }

        @Override
        public Object getProperty(String s) {
            return ServiceRegistrationImpl.this.getProperty(s);
        }

        @Override
        public String[] getPropertyKeys() {
            return ServiceRegistrationImpl.this.getPropertyKeys();
        }

        @Override
        public Bundle getBundle() {
            return ServiceRegistrationImpl.this.isValid() ? ServiceRegistrationImpl.this.m_bundle : null;
        }

        @Override
        public Bundle[] getUsingBundles() {
            return ServiceRegistrationImpl.this.getUsingBundles();
        }

        public String toString() {
            String[] ocs = (String[])this.getProperty("objectClass");
            String oc = "[";
            for (int i = 0; i < ocs.length; ++i) {
                oc = oc + ocs[i];
                if (i >= ocs.length - 1) continue;
                oc = oc + ", ";
            }
            oc = oc + "]";
            return oc;
        }

        @Override
        public boolean isAssignableTo(Bundle requester, String className) {
            if (requester == ServiceRegistrationImpl.this.m_bundle) {
                return true;
            }
            boolean allow = true;
            return allow;
        }

        @Override
        public int compareTo(Object reference) {
            Integer otherRank;
            Long otherId;
            ServiceReference other = (ServiceReference)reference;
            Long id = (Long)this.getProperty("service.id");
            if (id.equals(otherId = (Long)other.getProperty("service.id"))) {
                return 0;
            }
            Object rankObj = this.getProperty("service.ranking");
            Object otherRankObj = other.getProperty("service.ranking");
            rankObj = rankObj == null ? new Integer(0) : rankObj;
            otherRankObj = otherRankObj == null ? new Integer(0) : otherRankObj;
            Integer rank = rankObj instanceof Integer ? (Integer)rankObj : new Integer(0);
            Integer n = otherRank = otherRankObj instanceof Integer ? (Integer)otherRankObj : new Integer(0);
            if (rank.compareTo(otherRank) < 0) {
                return -1;
            }
            if (rank.compareTo(otherRank) > 0) {
                return 1;
            }
            return id.compareTo(otherId) < 0 ? 1 : -1;
        }
    }
}

