/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.AbstractInfo;
import org.apache.felix.deploymentadmin.BundleInfoImpl;
import org.apache.felix.deploymentadmin.DeploymentAdminImpl;
import org.apache.felix.deploymentadmin.NonCloseableStream;
import org.apache.felix.deploymentadmin.ResourceInfoImpl;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.DeploymentException;

public class StreamDeploymentPackage
extends AbstractDeploymentPackage {
    private final JarInputStream m_input;
    private final List m_names = new ArrayList();
    private boolean m_inMetaInf = true;

    public StreamDeploymentPackage(JarInputStream input, BundleContext bundleContext, DeploymentAdminImpl deploymentAdmin) throws DeploymentException {
        super(input.getManifest(), bundleContext, deploymentAdmin);
        this.m_input = input;
    }

    public InputStream getBundleStream(String symbolicName) {
        throw new UnsupportedOperationException("Not applicable for stream-based deployment package");
    }

    public InputStream getCurrentEntryStream() {
        return new NonCloseableStream(this.m_input);
    }

    public AbstractInfo getNextEntry() throws IOException {
        String name;
        boolean metaInfFile = true;
        do {
            JarEntry nextEntry;
            if ((nextEntry = this.m_input.getNextJarEntry()) == null) {
                return null;
            }
            name = nextEntry.getName();
            metaInfFile = this.isMetaInfFile(name);
            if (!metaInfFile || this.m_inMetaInf) continue;
            throw new IOException("Unexpected signature file found after manifest files: " + name);
        } while (metaInfFile);
        this.m_inMetaInf = false;
        this.m_names.add(name);
        return this.getAbstractInfoByPath(name);
    }

    public BundleInfoImpl[] getOrderedBundleInfos() {
        ArrayList<BundleInfoImpl> result = new ArrayList<BundleInfoImpl>();
        for (String indexEntry : this.m_names) {
            BundleInfoImpl bundleInfo = this.getBundleInfoByPath(indexEntry);
            if (bundleInfo == null) continue;
            result.add(bundleInfo);
        }
        BundleInfoImpl[] bundleInfoImpls = this.getBundleInfoImpls();
        for (int i = 0; i < bundleInfoImpls.length; ++i) {
            if (!bundleInfoImpls[i].isMissing()) continue;
            result.add(bundleInfoImpls[i]);
        }
        return result.toArray(new BundleInfoImpl[result.size()]);
    }

    public ResourceInfoImpl[] getOrderedResourceInfos() {
        throw new UnsupportedOperationException("Not applicable for stream-based deployment package");
    }
}

