/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.deploymentadmin.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.felix.deploymentadmin.AbstractDeploymentPackage;
import org.apache.felix.deploymentadmin.Utils;
import org.apache.felix.deploymentadmin.spi.AbstractAction;
import org.apache.felix.deploymentadmin.spi.Command;
import org.apache.felix.deploymentadmin.spi.DeploymentSessionImpl;
import org.apache.felix.deploymentadmin.spi.GetStorageAreaCommand;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentException;

public class SnapshotCommand
extends Command {
    static final String FORWARD_SLASH = "/";
    private final GetStorageAreaCommand m_getStorageAreaCommand;

    public SnapshotCommand(GetStorageAreaCommand getStorageAreaCommand) {
        this.m_getStorageAreaCommand = getStorageAreaCommand;
    }

    protected void doExecute(DeploymentSessionImpl session) throws Exception {
        AbstractDeploymentPackage target = session.getTargetAbstractDeploymentPackage();
        BundleContext context = session.getBundleContext();
        BundleInfo[] infos = target.getBundleInfos();
        Map storageAreas = this.m_getStorageAreaCommand.getStorageAreas();
        for (int i = 0; i < infos.length; ++i) {
            if (this.isCancelled()) {
                throw new DeploymentException(401);
            }
            String symbolicName = infos[i].getSymbolicName();
            Bundle bundle = target.getBundle(symbolicName);
            if (bundle == null) continue;
            File root = (File)storageAreas.get(symbolicName);
            if (root != null) {
                File snapshot = context.getDataFile("snapshots");
                snapshot.mkdirs();
                snapshot = new File(snapshot, infos[i].getSymbolicName());
                try {
                    snapshot.createNewFile();
                    SnapshotCommand.store(root, snapshot);
                    this.addRollback(new RestoreSnapshotRunnable(session, snapshot, root));
                    this.addCommit(new DeleteSnapshotRunnable(session, snapshot));
                }
                catch (Exception e) {
                    session.getLog().log(2, "Could not access storage area of bundle '" + symbolicName + "'!", (Throwable)e);
                    snapshot.delete();
                }
                continue;
            }
            session.getLog().log(2, "Could not retrieve storage area of bundle '" + symbolicName + "', skipping it.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void restore(File archiveFile, File targetDir) throws IOException {
        ZipInputStream input = null;
        try {
            ZipEntry entry;
            input = new ZipInputStream(new FileInputStream(archiveFile));
            while ((entry = input.getNextEntry()) != null) {
                File targetEntry = new File(targetDir, entry.getName());
                if (entry.isDirectory()) {
                    if (!targetEntry.mkdirs()) {
                        throw new IOException("Failed to create one or more sub-directories!");
                    }
                } else {
                    FileOutputStream output = null;
                    try {
                        output = new FileOutputStream(targetEntry);
                        SnapshotCommand.copy(input, output);
                    }
                    catch (Throwable throwable) {
                        SnapshotCommand.closeSilently(output);
                        throw throwable;
                    }
                    SnapshotCommand.closeSilently(output);
                }
                input.closeEntry();
            }
        }
        catch (Throwable throwable) {
            SnapshotCommand.closeSilently(input);
            throw throwable;
        }
        SnapshotCommand.closeSilently(input);
    }

    protected static void store(File sourceDir, File archiveFile) throws IOException {
        ZipOutputStream output = null;
        try {
            output = new ZipOutputStream(new FileOutputStream(archiveFile));
            SnapshotCommand.store(output, sourceDir, "");
        }
        catch (Throwable throwable) {
            SnapshotCommand.closeSilently(output);
            throw throwable;
        }
        SnapshotCommand.closeSilently(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[8192];
        try {
            int read;
            while ((read = is.read(buffer)) != -1) {
                os.write(buffer, 0, read);
            }
        }
        finally {
            os.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store(ZipOutputStream output, File sourceDir, String entryName) throws IOException {
        block7: {
            File entry;
            block6: {
                entry = new File(sourceDir, entryName);
                if (!entry.isFile()) break block6;
                ZipEntry zipEntry = new ZipEntry(entryName);
                zipEntry.setSize(entry.length());
                zipEntry.setTime(entry.lastModified());
                output.putNextEntry(zipEntry);
                FileInputStream input = null;
                try {
                    input = new FileInputStream(entry);
                    SnapshotCommand.copy(input, output);
                }
                catch (Throwable throwable) {
                    SnapshotCommand.closeSilently(input);
                    output.closeEntry();
                    throw throwable;
                }
                SnapshotCommand.closeSilently(input);
                output.closeEntry();
                break block7;
            }
            if (entry.isDirectory()) {
                String baseDir = "";
                if (!"".equals(entryName)) {
                    baseDir = entryName;
                    if (!baseDir.endsWith(FORWARD_SLASH)) {
                        baseDir = baseDir.concat(FORWARD_SLASH);
                    }
                    output.putNextEntry(new ZipEntry(baseDir));
                    output.closeEntry();
                }
                String[] entries = entry.list();
                for (int i = 0; i < entries.length; ++i) {
                    SnapshotCommand.store(output, sourceDir, baseDir.concat(entries[i]));
                }
            }
        }
    }

    private static class RestoreSnapshotRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;
        private final File m_root;

        private RestoreSnapshotRunnable(DeploymentSessionImpl session, File snapshot, File root) {
            this.m_session = session;
            this.m_snapshot = snapshot;
            this.m_root = root;
        }

        protected void doRun() throws Exception {
            try {
                Utils.delete(this.m_root, false);
                SnapshotCommand.restore(this.m_snapshot, this.m_root);
            }
            finally {
                this.m_snapshot.delete();
            }
        }

        protected void onFailure(Exception e) {
            this.m_session.getLog().log(2, "Failed to restore snapshot!", (Throwable)e);
        }
    }

    private static class DeleteSnapshotRunnable
    extends AbstractAction {
        private final DeploymentSessionImpl m_session;
        private final File m_snapshot;

        private DeleteSnapshotRunnable(DeploymentSessionImpl session, File snapshot) {
            this.m_session = session;
            this.m_snapshot = snapshot;
        }

        protected void doRun() {
            if (!this.m_snapshot.delete()) {
                this.m_session.getLog().log(2, "Failed to delete snapshot in " + this.m_snapshot + "!");
            }
        }
    }
}

