/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.feature.impl;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonGeneratorFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.felix.cm.json.io.ConfigurationReader;
import org.apache.felix.cm.json.io.ConfigurationWriter;
import org.apache.felix.cm.json.io.Configurations;
import org.apache.felix.feature.impl.BuilderFactoryImpl;
import org.apache.felix.feature.impl.IDImpl;
import org.osgi.service.feature.BuilderFactory;
import org.osgi.service.feature.Feature;
import org.osgi.service.feature.FeatureArtifact;
import org.osgi.service.feature.FeatureArtifactBuilder;
import org.osgi.service.feature.FeatureBuilder;
import org.osgi.service.feature.FeatureBundle;
import org.osgi.service.feature.FeatureBundleBuilder;
import org.osgi.service.feature.FeatureConfiguration;
import org.osgi.service.feature.FeatureConfigurationBuilder;
import org.osgi.service.feature.FeatureExtension;
import org.osgi.service.feature.FeatureExtensionBuilder;
import org.osgi.service.feature.FeatureService;
import org.osgi.service.feature.ID;

public class FeatureServiceImpl
implements FeatureService {
    private final BuilderFactoryImpl builderFactory = new BuilderFactoryImpl();

    public BuilderFactory getBuilderFactory() {
        return this.builderFactory;
    }

    public ID getIDfromMavenCoordinates(String mavenID) {
        return IDImpl.fromMavenID(mavenID);
    }

    public ID getID(String groupId, String artifactId, String version) {
        return new IDImpl(groupId, artifactId, version, null, null);
    }

    public ID getID(String groupId, String artifactId, String version, String type) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        return new IDImpl(groupId, artifactId, version, type, null);
    }

    public ID getID(String groupId, String artifactId, String version, String type, String classifier) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (classifier == null) {
            throw new NullPointerException("classifier must not be null");
        }
        return new IDImpl(groupId, artifactId, version, type, classifier);
    }

    public Feature readFeature(Reader jsonReader) throws IOException {
        JsonObject json = Json.createReader((Reader)Configurations.jsonCommentAwareReader((Reader)jsonReader)).readObject();
        String id = json.getString("id");
        FeatureBuilder builder = this.builderFactory.newFeatureBuilder(this.getIDfromMavenCoordinates(id));
        builder.setName(json.getString("name", null));
        builder.setDescription(json.getString("description", null));
        builder.setDocURL(json.getString("docURL", null));
        builder.setLicense(json.getString("license", null));
        builder.setSCM(json.getString("scm", null));
        builder.setVendor(json.getString("vendor", null));
        builder.setComplete(json.getBoolean("complete", false));
        builder.addVariables(this.getVariables(json));
        builder.addBundles(this.getBundles(json));
        builder.addCategories(this.getCategories(json));
        builder.addConfigurations(this.getConfigurations(json));
        builder.addExtensions(this.getExtensions(json));
        return builder.build();
    }

    private Map<String, Object> getVariables(JsonObject json) {
        LinkedHashMap<String, Object> variables = new LinkedHashMap<String, Object>();
        JsonObject jo = json.getJsonObject("variables");
        if (jo == null) {
            return Collections.emptyMap();
        }
        for (Map.Entry entry : jo.entrySet()) {
            Object value;
            JsonValue val = (JsonValue)entry.getValue();
            switch (val.getValueType()) {
                case STRING: {
                    value = ((JsonString)val).getString();
                    break;
                }
                case NUMBER: {
                    value = ((JsonNumber)val).bigDecimalValue();
                    break;
                }
                case TRUE: {
                    value = true;
                    break;
                }
                case FALSE: {
                    value = false;
                    break;
                }
                case NULL: {
                    value = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Variables can only contain singular values, not objects or arrays.");
                }
            }
            variables.put((String)entry.getKey(), value);
        }
        return variables;
    }

    private FeatureBundle[] getBundles(JsonObject json) {
        JsonArray ja = json.getJsonArray("bundles");
        if (ja == null) {
            return new FeatureBundle[0];
        }
        ArrayList<FeatureBundle> bundles = new ArrayList<FeatureBundle>();
        for (JsonValue val : ja) {
            if (val.getValueType() != JsonValue.ValueType.OBJECT) continue;
            JsonObject jo = val.asJsonObject();
            String bid = jo.getString("id");
            FeatureBundleBuilder builder = this.builderFactory.newBundleBuilder(this.getIDfromMavenCoordinates(bid));
            for (Map.Entry entry : jo.entrySet()) {
                Object v;
                if (((String)entry.getKey()).equals("id")) continue;
                JsonValue value = (JsonValue)entry.getValue();
                switch (value.getValueType()) {
                    case NUMBER: {
                        v = ((JsonNumber)value).longValueExact();
                        break;
                    }
                    case STRING: {
                        v = ((JsonString)value).getString();
                        break;
                    }
                    default: {
                        v = value.toString();
                    }
                }
                builder.addMetadata((String)entry.getKey(), v);
            }
            bundles.add(builder.build());
        }
        return bundles.toArray(new FeatureBundle[0]);
    }

    private String[] getCategories(JsonObject json) {
        JsonArray ja = json.getJsonArray("categories");
        if (ja == null) {
            return new String[0];
        }
        List cats = ja.getValuesAs(JsonString::getString);
        return cats.toArray(new String[0]);
    }

    private FeatureConfiguration[] getConfigurations(JsonObject json) throws IOException {
        JsonObject jo = json.getJsonObject("configurations");
        if (jo == null) {
            return new FeatureConfiguration[0];
        }
        ArrayList<FeatureConfiguration> configs = new ArrayList<FeatureConfiguration>();
        for (Map.Entry entry : jo.entrySet()) {
            String p = (String)entry.getKey();
            String factoryPid = null;
            int idx = p.indexOf(126);
            if (idx > 0) {
                factoryPid = p.substring(0, idx);
                p = p.substring(idx + 1);
            }
            FeatureConfigurationBuilder builder = factoryPid == null ? this.builderFactory.newConfigurationBuilder(p) : this.builderFactory.newConfigurationBuilder(factoryPid, p);
            JsonObject values = ((JsonValue)entry.getValue()).asJsonObject();
            ConfigurationReader cr = Configurations.buildReader().build(values);
            Hashtable cmap = cr.readConfiguration();
            for (Map.Entry cme : cmap.entrySet()) {
                builder.addValue((String)cme.getKey(), cme.getValue());
            }
            configs.add(builder.build());
        }
        return configs.toArray(new FeatureConfiguration[0]);
    }

    private FeatureExtension[] getExtensions(JsonObject json) {
        JsonObject jo = json.getJsonObject("extensions");
        if (jo == null) {
            return new FeatureExtension[0];
        }
        ArrayList<FeatureExtension> extensions = new ArrayList<FeatureExtension>();
        for (Map.Entry entry : jo.entrySet()) {
            FeatureExtension.Type type;
            JsonObject exData = ((JsonValue)entry.getValue()).asJsonObject();
            if (exData.containsKey((Object)"text")) {
                type = FeatureExtension.Type.TEXT;
            } else if (exData.containsKey((Object)"artifacts")) {
                type = FeatureExtension.Type.ARTIFACTS;
            } else if (exData.containsKey((Object)"json")) {
                type = FeatureExtension.Type.JSON;
            } else {
                throw new IllegalStateException("Invalid extension: " + entry);
            }
            String k = exData.getString("kind", "optional");
            FeatureExtension.Kind kind = FeatureExtension.Kind.valueOf((String)k.toUpperCase());
            FeatureExtensionBuilder builder = this.builderFactory.newExtensionBuilder((String)entry.getKey(), type, kind);
            switch (type) {
                case TEXT: {
                    exData.getJsonArray("text").stream().filter(jv -> jv.getValueType() == JsonValue.ValueType.STRING).map(jv -> ((JsonString)jv).getString()).forEach(arg_0 -> ((FeatureExtensionBuilder)builder).addText(arg_0));
                    break;
                }
                case ARTIFACTS: {
                    exData.getJsonArray("artifacts").stream().filter(jv -> jv.getValueType() == JsonValue.ValueType.OBJECT).map(jv -> (JsonObject)jv).forEach(md -> {
                        HashMap v = new HashMap(md);
                        JsonString idVal = (JsonString)v.remove("id");
                        ID id = this.getIDfromMavenCoordinates(idVal.getString());
                        FeatureArtifactBuilder fab = this.builderFactory.newArtifactBuilder(id);
                        for (Map.Entry mde : v.entrySet()) {
                            JsonValue val = (JsonValue)mde.getValue();
                            switch (val.getValueType()) {
                                case STRING: {
                                    fab.addMetadata((String)mde.getKey(), (Object)((JsonString)val).getString());
                                    break;
                                }
                                case FALSE: {
                                    fab.addMetadata((String)mde.getKey(), (Object)false);
                                    break;
                                }
                                case TRUE: {
                                    fab.addMetadata((String)mde.getKey(), (Object)true);
                                    break;
                                }
                                case NUMBER: {
                                    JsonNumber num = (JsonNumber)val;
                                    if (num.toString().contains(".")) {
                                        fab.addMetadata((String)mde.getKey(), (Object)num.doubleValue());
                                        break;
                                    }
                                    fab.addMetadata((String)mde.getKey(), (Object)num.longValue());
                                    break;
                                }
                            }
                        }
                        builder.addArtifact(fab.build());
                    });
                    break;
                }
                case JSON: {
                    builder.setJSON(exData.getJsonObject("json").toString());
                }
            }
            extensions.add(builder.build());
        }
        return extensions.toArray(new FeatureExtension[0]);
    }

    public void writeFeature(Feature feature, Writer jsonWriter) throws IOException {
        JsonObject extensions;
        JsonObject configs;
        JsonArray bundles;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("id", feature.getID().toString());
        feature.getName().ifPresent(n -> attrs.put("name", (String)n));
        feature.getDescription().ifPresent(d -> attrs.put("description", (String)d));
        feature.getDocURL().ifPresent(d -> attrs.put("docURL", (String)d));
        feature.getLicense().ifPresent(l -> attrs.put("license", (String)l));
        feature.getSCM().ifPresent(s -> attrs.put("scm", (String)s));
        feature.getVendor().ifPresent(v -> attrs.put("vendor", (String)v));
        JsonObjectBuilder json = Json.createObjectBuilder(attrs);
        JsonObject variables = this.getVariables(feature);
        if (variables != null) {
            json.add("variables", (JsonValue)variables);
        }
        if ((bundles = this.getBundles(feature)) != null) {
            json.add("bundles", (JsonValue)bundles);
        }
        if ((configs = this.getConfigurations(feature)) != null) {
            json.add("configurations", (JsonValue)configs);
        }
        if ((extensions = this.getExtensions(feature)) != null) {
            json.add("extensions", (JsonValue)extensions);
        }
        JsonObject fo = json.build();
        JsonGeneratorFactory gf = Json.createGeneratorFactory(Collections.singletonMap("jakarta.json.stream.JsonGenerator.prettyPrinting", true));
        try (JsonGenerator gr = gf.createGenerator(jsonWriter);){
            gr.write((JsonValue)fo);
        }
    }

    private JsonObject getVariables(Feature feature) {
        Map vars = feature.getVariables();
        if (vars == null || vars.size() == 0) {
            return null;
        }
        JsonObjectBuilder jo = Json.createObjectBuilder((Map)vars);
        return jo.build();
    }

    private JsonArray getBundles(Feature feature) {
        List bundles = feature.getBundles();
        if (bundles == null || bundles.size() == 0) {
            return null;
        }
        JsonArrayBuilder ab = Json.createArrayBuilder();
        for (FeatureBundle bundle : bundles) {
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("id", bundle.getID().toString());
            attrs.putAll(bundle.getMetadata());
            ab.add(Json.createObjectBuilder(attrs));
        }
        return ab.build();
    }

    private JsonObject getConfigurations(Feature feature) throws IOException {
        Map configs = feature.getConfigurations();
        if (configs == null || configs.size() == 0) {
            return null;
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        for (Map.Entry cfg : configs.entrySet()) {
            StringWriter sw = new StringWriter();
            ConfigurationWriter cw = Configurations.buildWriter().build((Writer)sw);
            Hashtable dict = Configurations.newConfiguration();
            ((FeatureConfiguration)cfg.getValue()).getValues().entrySet().forEach(e -> dict.put((String)e.getKey(), e.getValue()));
            cw.writeConfiguration((Dictionary)dict);
            sw.close();
            JsonReader jr = Json.createReader((Reader)new StringReader(sw.toString()));
            JsonObject jo = jr.readObject();
            ob.add((String)cfg.getKey(), (JsonValue)jo);
        }
        return ob.build();
    }

    private JsonObject getExtensions(Feature feature) {
        Map extensions = feature.getExtensions();
        if (extensions == null || extensions.size() == 0) {
            return null;
        }
        JsonObjectBuilder ob = Json.createObjectBuilder();
        for (Map.Entry entry : extensions.entrySet()) {
            FeatureExtension extVal = (FeatureExtension)entry.getValue();
            JsonObjectBuilder vb = Json.createObjectBuilder();
            vb.add("kind", extVal.getKind().toString().toLowerCase());
            switch (extVal.getType()) {
                case TEXT: {
                    vb.add("text", (JsonValue)Json.createArrayBuilder((Collection)extVal.getText()).build());
                    break;
                }
                case ARTIFACTS: {
                    JsonArrayBuilder arr = Json.createArrayBuilder();
                    for (FeatureArtifact art : extVal.getArtifacts()) {
                        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
                        attrs.put("id", art.getID().toString());
                        attrs.putAll(art.getMetadata());
                        arr.add(Json.createObjectBuilder(attrs)).build();
                    }
                    vb.add("artifacts", (JsonValue)arr.build());
                    break;
                }
                case JSON: {
                    vb.add("json", Json.createReader((Reader)new StringReader(extVal.getJSON())).readValue());
                }
            }
            ob.add((String)entry.getKey(), (JsonValue)vb.build());
        }
        return ob.build();
    }
}

