/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.generalchecks.util;

import java.util.Arrays;
import java.util.Calendar;
import org.apache.felix.hc.core.impl.util.lang.StringUtils;

public class SimpleConstraintChecker {
    public static final String GREATER_THAN = ">";
    public static final String LESS_THAN = "<";
    public static final String EQUALS = "=";
    public static final String BETWEEN = "between";
    public static final String AND = "and";
    public static final String CONTAINS = "contains";
    public static final String STARTS_WITH = "starts_with";
    public static final String ENDS_WITH = "ends_with";
    public static final String MATCHES = "matches";
    public static final String OLDER_THAN = "older_than";

    public boolean check(Object inputValue, String constraint) throws NumberFormatException {
        String pattern;
        String stringValue;
        if (inputValue == null) {
            return false;
        }
        String string = stringValue = inputValue == null ? "" : inputValue.toString();
        if (StringUtils.isBlank(constraint)) {
            throw new IllegalArgumentException("Empty constraint, cannot evaluate");
        }
        CharSequence[] parts = constraint.split(" +");
        boolean matches = false;
        boolean inverseResult = false;
        if (parts[0].equalsIgnoreCase("not")) {
            inverseResult = true;
            String[] newParts = new String[parts.length - 1];
            System.arraycopy(parts, 1, newParts, 0, newParts.length);
            parts = newParts;
        }
        if (parts[0].equals(GREATER_THAN) && parts.length == 2) {
            long value = Long.valueOf(stringValue);
            matches = value > Long.valueOf(parts[1]);
        } else if (parts[0].equals(LESS_THAN) && parts.length == 2) {
            long value = Long.valueOf(stringValue);
            matches = value < Long.valueOf(parts[1]);
        } else if (parts[0].equals(EQUALS) && parts.length == 2) {
            Long longValue = SimpleConstraintChecker.getLongObject(stringValue);
            matches = longValue != null ? longValue.longValue() == Long.valueOf(parts[1]).longValue() : stringValue.equals(parts[1]);
        } else if (parts.length == 4 && BETWEEN.equalsIgnoreCase(parts[0]) && AND.equalsIgnoreCase(parts[2])) {
            long value = Long.valueOf(stringValue);
            long lowerBound = Long.valueOf(parts[1]);
            long upperBound = Long.valueOf((String)parts[3]);
            matches = value > lowerBound && value < upperBound;
        } else if (parts.length > 1 && CONTAINS.equalsIgnoreCase(parts[0])) {
            pattern = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
            matches = stringValue.contains(pattern);
        } else if (parts.length > 1 && STARTS_WITH.equalsIgnoreCase(parts[0])) {
            pattern = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
            matches = stringValue.startsWith(pattern);
        } else if (parts.length > 1 && ENDS_WITH.equalsIgnoreCase(parts[0])) {
            pattern = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
            matches = stringValue.endsWith(pattern);
        } else if (parts.length > 1 && MATCHES.equalsIgnoreCase(parts[0])) {
            pattern = String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length));
            matches = stringValue.matches(pattern);
        } else if (parts.length > 1 && OLDER_THAN.equalsIgnoreCase((String)parts[0]) && parts.length == 3) {
            int unit = this.stringToUnit((String)parts[2]);
            long timestamp = Long.valueOf(stringValue);
            int timeDiff = Integer.valueOf((String)parts[1]);
            Calendar cal = Calendar.getInstance();
            cal.add(unit, -timeDiff);
            long compareTimestamp = cal.getTime().getTime();
            matches = timestamp < compareTimestamp;
        } else {
            matches = String.join((CharSequence)"", parts).equals(stringValue);
        }
        boolean result = matches ^ inverseResult;
        return result;
    }

    private int stringToUnit(String unitString) {
        int unit;
        switch (unitString) {
            case "ms": {
                unit = 14;
                break;
            }
            case "min": 
            case "minute": 
            case "minutes": {
                unit = 12;
                break;
            }
            case "h": 
            case "hour": 
            case "hours": {
                unit = 10;
                break;
            }
            case "d": 
            case "day": 
            case "days": {
                unit = 6;
                break;
            }
            case "s": 
            case "sec": 
            case "second": 
            case "seconds": {
                unit = 13;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected unit '" + unitString + "'");
            }
        }
        return unit;
    }

    private static Long getLongObject(String strNum) {
        if (strNum == null) {
            return null;
        }
        try {
            return Long.valueOf(strNum);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

