/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.jetty.internal.webapp;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.jetty.internal.JettyConfig;
import org.apache.felix.http.jetty.internal.webapp.WebAppBundleContext;
import org.apache.felix.http.jetty.internal.webapp.WebEvent;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class WebAppBundleTracker
extends AbstractLifeCycle.AbstractLifeCycleListener {
    private static final String HEADER_WEB_CONTEXT_PATH = "Web-ContextPath";
    private static final String HEADER_ACTIVATION_POLICY = "Bundle-ActivationPolicy";
    private static final String POLICY_LAZY = "Lazy";
    private static final String OSGI_BUNDLE_CONTEXT = "osgi-bundlecontext";
    private static final String WEB_SYMBOLIC_NAME = "osgi.web.symbolicname";
    private static final String WEB_VERSION = "osgi.web.version";
    private static final String WEB_CONTEXT_PATH = "osgi.web.contextpath";
    private final Map<String, Deployment> deployments = new LinkedHashMap<String, Deployment>();
    private final BundleContext context;
    private final ExecutorService executor;
    private final JettyConfig config;
    private volatile BundleTracker<Deployment> bundleTracker;
    private volatile ServiceTracker<Object, Object> eventAdmintTracker;
    private volatile Object eventAdmin;
    private volatile ContextHandlerCollection parent;

    public WebAppBundleTracker(BundleContext bundleContext, JettyConfig config) {
        this.context = bundleContext;
        this.config = config;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread t = new Thread(runnable);
                t.setName("Jetty HTTP Service");
                return t;
            }
        });
    }

    public void start(ContextHandlerCollection parent) throws Exception {
        this.parent = parent;
        this.eventAdmintTracker = new ServiceTracker(this.context, "org.osgi.service.event.EventAdmin", (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Object, Object>(){

            public Object addingService(ServiceReference<Object> reference) {
                Object service = WebAppBundleTracker.this.context.getService(reference);
                WebAppBundleTracker.this.eventAdmin = service;
                return service;
            }

            public void modifiedService(ServiceReference<Object> reference, Object service) {
            }

            public void removedService(ServiceReference<Object> reference, Object service) {
                WebAppBundleTracker.this.eventAdmin = null;
                WebAppBundleTracker.this.context.ungetService(reference);
            }
        });
        this.eventAdmintTracker.open();
        this.bundleTracker = new BundleTracker(this.context, 40, (BundleTrackerCustomizer)new BundleTrackerCustomizer<Deployment>(){

            public Deployment addingBundle(Bundle bundle, BundleEvent event) {
                return this.detectWebAppBundle(bundle);
            }

            public void modifiedBundle(Bundle bundle, BundleEvent event, Deployment object) {
                this.detectWebAppBundle(bundle);
            }

            private Deployment detectWebAppBundle(Bundle bundle) {
                String contextPath;
                if ((bundle.getState() == 32 || bundle.getState() == 8 && WebAppBundleTracker.POLICY_LAZY.equals(bundle.getHeaders().get(WebAppBundleTracker.HEADER_ACTIVATION_POLICY))) && (contextPath = (String)bundle.getHeaders().get(WebAppBundleTracker.HEADER_WEB_CONTEXT_PATH)) != null) {
                    return WebAppBundleTracker.this.startWebAppBundle(bundle, contextPath);
                }
                return null;
            }

            public void removedBundle(Bundle bundle, BundleEvent event, Deployment object) {
                String contextPath = (String)bundle.getHeaders().get(WebAppBundleTracker.HEADER_WEB_CONTEXT_PATH);
                if (contextPath == null) {
                    return;
                }
                Deployment deployment = (Deployment)WebAppBundleTracker.this.deployments.remove(contextPath);
                if (deployment != null && deployment.getContext() != null) {
                    deployment.setRegistration(null);
                    WebAppBundleTracker.this.undeploy(deployment, deployment.getContext());
                }
            }
        });
        this.bundleTracker.open();
    }

    public void stop() throws Exception {
        if (this.bundleTracker != null) {
            this.bundleTracker.close();
            this.bundleTracker = null;
        }
        if (this.eventAdmintTracker != null) {
            this.eventAdmintTracker.close();
            this.eventAdmintTracker = null;
        }
        if (this.isExecutorServiceAvailable()) {
            this.executor.shutdown();
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        this.parent = null;
    }

    private Deployment startWebAppBundle(Bundle bundle, String contextPath) {
        this.postEvent("org/osgi/service/web/DEPLOYING", bundle, this.context.getBundle(), null, null, null);
        Deployment deployment = this.deployments.get(contextPath);
        if (deployment != null) {
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which is already registered", bundle.getSymbolicName(), contextPath), null);
            this.postEvent("org/osgi/service/web/FAILED", bundle, this.context.getBundle(), null, contextPath, deployment.getBundle().getBundleId());
            return null;
        }
        if (contextPath.equals("/")) {
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which is reserved", bundle.getSymbolicName(), contextPath), null);
            this.postEvent("org/osgi/service/web/FAILED", bundle, this.context.getBundle(), null, contextPath, this.context.getBundle().getBundleId());
            return null;
        }
        for (String path : this.config.getPathExclusions()) {
            if (!contextPath.startsWith(path)) continue;
            SystemLogger.warning(String.format("Web application bundle %s has context path %s which clashes with excluded path prefix %s", bundle.getSymbolicName(), contextPath, path), null);
            this.postEvent("org/osgi/service/web/FAILED", bundle, this.context.getBundle(), null, path, null);
            return null;
        }
        deployment = new Deployment(contextPath, bundle);
        this.deployments.put(contextPath, deployment);
        WebAppBundleContext context = new WebAppBundleContext(contextPath, bundle, this.getClass().getClassLoader());
        this.deploy(deployment, context);
        return deployment;
    }

    public void deploy(final Deployment deployment, final WebAppBundleContext context) {
        if (!this.isExecutorServiceAvailable()) {
            return;
        }
        this.executor.submit(new JettyOperation(){

            @Override
            protected void doExecute() {
                Bundle webAppBundle = deployment.getBundle();
                Bundle extenderBundle = WebAppBundleTracker.this.context.getBundle();
                try {
                    context.getServletContext().setAttribute(WebAppBundleTracker.OSGI_BUNDLE_CONTEXT, webAppBundle.getBundleContext());
                    WebAppBundleTracker.this.parent.addHandler(context);
                    context.start();
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put(WebAppBundleTracker.WEB_SYMBOLIC_NAME, webAppBundle.getSymbolicName());
                    ((Dictionary)props).put(WebAppBundleTracker.WEB_VERSION, (String)webAppBundle.getVersion());
                    ((Dictionary)props).put(WebAppBundleTracker.WEB_CONTEXT_PATH, deployment.getContextPath());
                    deployment.setRegistration((ServiceRegistration<ServletContext>)webAppBundle.getBundleContext().registerService(ServletContext.class, (Object)context.getServletContext(), props));
                    WebAppBundleTracker.this.postEvent("org/osgi/service/web/DEPLOYED", webAppBundle, extenderBundle, null, null, null);
                }
                catch (Exception e) {
                    SystemLogger.error(String.format("Deploying web application bundle %s failed.", webAppBundle.getSymbolicName()), e);
                    WebAppBundleTracker.this.postEvent("org/osgi/service/web/FAILED", webAppBundle, extenderBundle, e, null, null);
                    deployment.setContext(null);
                }
            }
        });
        deployment.setContext(context);
    }

    public void undeploy(final Deployment deployment, final WebAppBundleContext context) {
        if (!this.isExecutorServiceAvailable()) {
            return;
        }
        this.executor.submit(new JettyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doExecute() {
                Bundle webAppBundle = deployment.getBundle();
                Bundle extenderBundle = WebAppBundleTracker.this.context.getBundle();
                try {
                    WebAppBundleTracker.this.postEvent("org/osgi/service/web/UNDEPLOYING", webAppBundle, extenderBundle, null, null, null);
                    context.getServletContext().removeAttribute(WebAppBundleTracker.OSGI_BUNDLE_CONTEXT);
                    ServiceRegistration<ServletContext> registration = deployment.getRegistration();
                    if (registration != null) {
                        registration.unregister();
                    }
                    deployment.setRegistration(null);
                    deployment.setContext(null);
                    context.stop();
                }
                catch (Exception e) {
                    SystemLogger.error(String.format("Undeploying web application bundle %s failed.", webAppBundle.getSymbolicName()), e);
                }
                finally {
                    WebAppBundleTracker.this.postEvent("org/osgi/service/web/UNDEPLOYED", webAppBundle, extenderBundle, null, null, null);
                }
            }
        });
    }

    private void postEvent(String topic, Bundle webAppBundle, Bundle extenderBundle, Throwable exception, String collision, Long collisionBundles) {
        Object ea = this.eventAdmin;
        if (ea != null) {
            WebEvent.postEvent(ea, topic, webAppBundle, extenderBundle, exception, collision, collisionBundles);
        }
    }

    @Override
    public void lifeCycleStarted(LifeCycle event) {
        for (Deployment deployment : this.deployments.values()) {
            if (deployment.getContext() != null) continue;
            this.postEvent("org/osgi/service/web/DEPLOYING", deployment.getBundle(), this.context.getBundle(), null, null, null);
            WebAppBundleContext context = new WebAppBundleContext(deployment.getContextPath(), deployment.getBundle(), this.getClass().getClassLoader());
            this.deploy(deployment, context);
        }
    }

    @Override
    public void lifeCycleStopping(LifeCycle event) {
        for (Deployment deployment : this.deployments.values()) {
            if (deployment.getContext() == null) continue;
            this.undeploy(deployment, deployment.getContext());
        }
    }

    private boolean isExecutorServiceAvailable() {
        return this.executor != null && !this.executor.isShutdown();
    }

    static abstract class JettyOperation
    implements Callable<Void> {
        JettyOperation() {
        }

        @Override
        public Void call() throws Exception {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                this.doExecute();
                Void void_ = null;
                return void_;
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }

        protected abstract void doExecute() throws Exception;
    }

    public static class Deployment {
        private String contextPath;
        private Bundle bundle;
        private WebAppBundleContext context;
        private ServiceRegistration<ServletContext> registration;

        public Deployment(String contextPath, Bundle bundle) {
            this.contextPath = contextPath;
            this.bundle = bundle;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public WebAppBundleContext getContext() {
            return this.context;
        }

        public void setContext(WebAppBundleContext context) {
            this.context = context;
        }

        public ServiceRegistration<ServletContext> getRegistration() {
            return this.registration;
        }

        public void setRegistration(ServiceRegistration<ServletContext> registration) {
            this.registration = registration;
        }
    }
}

