/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.felix.inventory.impl.webconsole;

public class ConsoleConstants
{

    public static final String INTERFACE_SERVLET = "jakarta.servlet.Servlet"; //$NON-NLS-1$

    public static final String INTERFACE_CONFIGURATION_PRINTER = "org.apache.felix.webconsole.ConfigurationPrinter"; //$NON-NLS-1$

    public static final String PLUGIN_LABEL = "felix.webconsole.label"; //$NON-NLS-1$

    public static final String PLUGIN_TITLE = "felix.webconsole.title"; //$NON-NLS-1$

    public static final String PLUGIN_CATEGORY = "felix.webconsole.category"; //$NON-NLS-1$

    public static final String CONFIG_PRINTER_MODES = "felix.webconsole.configprinter.modes"; //$NON-NLS-1$

    public static final String CONFIG_PRINTER_WEB_UNESCAPED = "felix.webconsole.configprinter.web.unescaped"; //$NON-NLS-1$

    public static final String MODE_ALWAYS = "always"; //$NON-NLS-1$

    public static final String MODE_WEB = "web"; //$NON-NLS-1$

    public static final String MODE_ZIP = "zip"; //$NON-NLS-1$

    public static final String MODE_TXT = "txt"; //$NON-NLS-1$

    public static final String PROPERTY_MODES = "modes"; //$NON-NLS-1$

    public static final String WEB_CONSOLE_CATEGORY = "Status"; //$NON-NLS-1$

    public static final String NAME = "config"; //$NON-NLS-1$

    public static final String TITLE = "Overview"; //$NON-NLS-1$
}
