/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.deployer.obr;

import aQute.bnd.service.Refreshable;
import aQute.bnd.service.RepositoryPlugin;
import aQute.lib.deployer.FileRepo;
import aQute.lib.deployer.obr.OBR;
import aQute.lib.deployer.obr.UniqueResourceFilter;
import aQute.lib.io.IO;
import aQute.lib.osgi.Jar;
import aQute.libg.reporter.Reporter;
import aQute.libg.sax.SAXUtil;
import aQute.libg.sax.filters.MergeContentFilter;
import aQute.libg.version.Version;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.stream.StreamResult;
import org.osgi.service.bindex.BundleIndexer;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalOBR
extends OBR
implements Refreshable {
    public static final String PROP_LOCAL_DIR = "local";
    public static final String PROP_READONLY = "readonly";
    private final FileRepo storageRepo = new FileRepo();
    private File storageDir;
    private File localIndex;
    private List<URL> indexUrls;

    @Override
    public void setReporter(Reporter reporter) {
        super.setReporter(reporter);
        this.storageRepo.setReporter(reporter);
    }

    @Override
    public void setProperties(Map<String, String> map) {
        super.setProperties(map);
        String localDirPath = map.get(PROP_LOCAL_DIR);
        if (localDirPath == null) {
            throw new IllegalArgumentException(String.format("Attribute '%s' must be set on LocalOBR plugin.", PROP_LOCAL_DIR));
        }
        this.storageDir = new File(localDirPath);
        if (!this.storageDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Local path '%s' does not exist or is not a directory.", localDirPath));
        }
        HashMap<String, String> storageRepoConfig = new HashMap<String, String>(2);
        storageRepoConfig.put(FileRepo.LOCATION, localDirPath);
        storageRepoConfig.put(FileRepo.READONLY, map.get(PROP_READONLY));
        this.storageRepo.setProperties(storageRepoConfig);
        this.localIndex = new File(this.storageDir, "repository.xml");
        if (this.localIndex.exists() && !this.localIndex.isFile()) {
            throw new IllegalArgumentException(String.format("Cannot build local repository index: '%s' already exists but is not a plain file.", this.localIndex.getAbsolutePath()));
        }
        this.cacheDir = new File(this.storageDir, ".obrcache");
        if (this.cacheDir.exists() && !this.cacheDir.isDirectory()) {
            throw new IllegalArgumentException(String.format("Cannot create repository cache: '%s' already exists but is not directory.", this.cacheDir.getAbsolutePath()));
        }
    }

    @Override
    protected void initialiseIndexes() throws Exception {
        if (!this.localIndex.exists()) {
            this.regenerateIndex();
        }
        try {
            Collection remotes = super.getOBRIndexes();
            this.indexUrls = new ArrayList<URL>(remotes.size() + 1);
            this.indexUrls.add(this.localIndex.toURI().toURL());
            this.indexUrls.addAll(remotes);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error initialising local index URL", e);
        }
    }

    private void regenerateIndex() throws Exception {
        BundleIndexer indexer = this.registry.getPlugin(BundleIndexer.class);
        if (indexer == null) {
            throw new IllegalStateException("Cannot index repository: no Bundle Indexer service or plugin found.");
        }
        HashSet<File> allFiles = new HashSet<File>();
        this.gatherFiles(allFiles);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.localIndex);
            if (!allFiles.isEmpty()) {
                HashMap<String, String> config = new HashMap<String, String>();
                config.put("repository.name", this.getName());
                config.put("root.url", ((Object)this.localIndex.getCanonicalFile().toURI().toURL()).toString());
                indexer.index(allFiles, out, config);
            } else {
                ByteArrayInputStream emptyRepo = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>\n<repository lastmodified='0'/>".getBytes());
                IO.copy((InputStream)emptyRepo, (OutputStream)out);
            }
        }
        finally {
            out.close();
        }
    }

    private void gatherFiles(Set<File> allFiles) throws Exception {
        List<String> bsns = this.storageRepo.list(null);
        if (bsns != null) {
            for (String bsn : bsns) {
                List<Version> versions = this.storageRepo.versions(bsn);
                if (versions == null) continue;
                for (Version version : versions) {
                    File file = this.storageRepo.get(bsn, version.toString(), RepositoryPlugin.Strategy.HIGHEST, null);
                    if (file == null) continue;
                    allFiles.add(file.getCanonicalFile());
                }
            }
        }
    }

    @Override
    public List<URL> getOBRIndexes() {
        return this.indexUrls;
    }

    @Override
    public boolean canWrite() {
        return this.storageRepo.canWrite();
    }

    @Override
    public synchronized File put(Jar jar) throws Exception {
        File newFile = this.storageRepo.put(jar);
        BundleIndexer indexer = this.registry.getPlugin(BundleIndexer.class);
        if (indexer == null) {
            throw new IllegalStateException("Cannot index repository: no Bundle Indexer service or plugin found.");
        }
        ByteArrayOutputStream newIndexBuffer = new ByteArrayOutputStream();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("repository.name", this.getName());
        config.put("root.url", ((Object)this.localIndex.getCanonicalFile().toURI().toURL()).toString());
        indexer.index(Collections.singleton(newFile.getCanonicalFile()), newIndexBuffer, null);
        File tempIndex = File.createTempFile("repository", ".xml");
        FileOutputStream tempIndexOutput = new FileOutputStream(tempIndex);
        MergeContentFilter merger = new MergeContentFilter();
        XMLReader reader = SAXUtil.buildPipeline(new StreamResult(tempIndexOutput), new UniqueResourceFilter(), merger);
        try {
            reader.parse(new InputSource(new ByteArrayInputStream(newIndexBuffer.toByteArray())));
            try {
                reader.parse(new InputSource(new FileInputStream(this.localIndex)));
            }
            catch (Exception e) {
                this.reporter.warning("Existing local index is invalid or missing, overwriting (%s).", this.localIndex.getAbsolutePath());
            }
            merger.closeRootAndDocument();
        }
        finally {
            tempIndexOutput.flush();
            tempIndexOutput.close();
        }
        IO.copy(tempIndex, this.localIndex);
        this.reset();
        this.init();
        return newFile;
    }

    @Override
    public boolean refresh() {
        this.reset();
        return true;
    }

    @Override
    public File getRoot() {
        return this.storageDir;
    }
}

