/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.service.Plugin;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.lib.io.IO;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.Constants;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Macro;
import aQute.lib.osgi.Verifier;
import aQute.libg.generics.Create;
import aQute.libg.header.OSGiHeader;
import aQute.libg.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Processor
implements Reporter,
Registry,
Constants,
Closeable {
    static ThreadLocal<Processor> current = new ThreadLocal();
    static ExecutorService executor = Executors.newCachedThreadPool();
    static Random random = new Random();
    public static String LIST_SPLITTER = "\\s*,\\s*";
    final List<String> errors = new ArrayList<String>();
    final List<String> warnings = new ArrayList<String>();
    final Set<Object> basicPlugins = new HashSet<Object>();
    final Set<Closeable> toBeClosed = new HashSet<Closeable>();
    Set<Object> plugins;
    boolean pedantic;
    boolean trace;
    boolean exceptions;
    boolean fileMustExist = true;
    private File base = new File("").getAbsoluteFile();
    Properties properties;
    private Macro replacer;
    private long lastModified;
    private File propertiesFile;
    private boolean fixup = true;
    long modified;
    Processor parent;
    Set<File> included;
    CL pluginLoader;
    Collection<String> filter;
    HashSet<String> missingCommand;

    public Processor() {
        this.properties = new Properties();
    }

    public Processor(Properties parent) {
        this.properties = new Properties(parent);
    }

    public Processor(Processor parent) {
        this(parent.properties);
        this.parent = parent;
    }

    public void setParent(Processor processor) {
        this.parent = processor;
        Properties ext = new Properties(processor.properties);
        ext.putAll((Map<?, ?>)this.properties);
        this.properties = ext;
    }

    public Processor getParent() {
        return this.parent;
    }

    public Processor getTop() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getTop();
    }

    public void getInfo(Processor processor, String prefix) {
        if (this.isFailOk()) {
            this.addAll(this.warnings, processor.getErrors(), prefix);
        } else {
            this.addAll(this.errors, processor.getErrors(), prefix);
        }
        this.addAll(this.warnings, processor.getWarnings(), prefix);
        processor.errors.clear();
        processor.warnings.clear();
    }

    public void getInfo(Processor processor) {
        this.getInfo(processor, "");
    }

    private <T> void addAll(List<String> to, List<? extends T> from, String prefix) {
        for (T x : from) {
            to.add(String.valueOf(prefix) + x);
        }
    }

    private Processor current() {
        Processor p = current.get();
        if (p == null) {
            return this;
        }
        return p;
    }

    @Override
    public void warning(String string, Object ... args) {
        Processor p = this.current();
        String s = Processor.formatArrays(string, args);
        if (!p.warnings.contains(s)) {
            p.warnings.add(s);
        }
        p.signal();
    }

    @Override
    public void error(String string, Object ... args) {
        Processor p = this.current();
        if (p.isFailOk()) {
            p.warning(string, args);
        } else {
            String s = Processor.formatArrays(string, args);
            if (!p.errors.contains(s)) {
                p.errors.add(s);
            }
        }
        p.signal();
    }

    public void error(String string, Throwable t, Object ... args) {
        Processor p = this.current();
        if (p.isFailOk()) {
            p.warning(String.valueOf(string) + ": " + t, args);
        } else {
            p.errors.add("Exception: " + t.getMessage());
            String s = Processor.formatArrays(string, args);
            if (!p.errors.contains(s)) {
                p.errors.add(s);
            }
        }
        if (p.exceptions) {
            t.printStackTrace();
        }
        p.signal();
    }

    public void signal() {
    }

    @Override
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public Map<String, Map<String, String>> parseHeader(String value) {
        return Processor.parseHeader(value, this);
    }

    public static Map<String, Map<String, String>> parseHeader(String value, Processor logger) {
        return OSGiHeader.parseHeader(value, logger);
    }

    Map<String, Map<String, String>> getClauses(String header) {
        return this.parseHeader(this.getProperty(header));
    }

    public void addClose(Closeable jar) {
        this.toBeClosed.add(jar);
    }

    static <T> Map<String, T> removeKeys(Map<String, T> source, String prefix) {
        TreeMap<String, T> temp = new TreeMap<String, T>(source);
        Iterator p = temp.keySet().iterator();
        while (p.hasNext()) {
            String pack = (String)p.next();
            if (!pack.startsWith(prefix)) continue;
            p.remove();
        }
        return temp;
    }

    @Override
    public void progress(String s, Object ... args) {
        this.trace(s, args);
    }

    @Override
    public boolean isPedantic() {
        return this.current().pedantic;
    }

    public void setPedantic(boolean pedantic) {
        this.pedantic = pedantic;
    }

    public static File getFile(File base, String file) {
        return IO.getFile(base, file);
    }

    public File getFile(String file) {
        return Processor.getFile(this.base, file);
    }

    @Override
    public <T> List<T> getPlugins(Class<T> clazz) {
        ArrayList<T> l = new ArrayList<T>();
        Set<Object> all = this.getPlugins();
        for (Object plugin : all) {
            if (!clazz.isInstance(plugin)) continue;
            l.add(clazz.cast(plugin));
        }
        return l;
    }

    @Override
    public <T> T getPlugin(Class<T> clazz) {
        Set<Object> all = this.getPlugins();
        for (Object plugin : all) {
            if (!clazz.isInstance(plugin)) continue;
            return clazz.cast(plugin);
        }
        return null;
    }

    protected synchronized Set<Object> getPlugins() {
        if (this.plugins != null) {
            return this.plugins;
        }
        this.missingCommand = new HashSet();
        LinkedHashSet<Object> list = new LinkedHashSet<Object>();
        list.add(this);
        this.setTypeSpecificPlugins(list);
        if (this.parent != null) {
            list.addAll(this.parent.getPlugins());
        }
        if (this.properties.containsKey("-plugin")) {
            String spe = this.getProperty("-plugin");
            if (spe.equals("none")) {
                return new LinkedHashSet<Object>();
            }
            this.loadPlugins(list, spe);
        }
        this.plugins = list;
        return this.plugins;
    }

    protected void loadPlugins(Set<Object> list, String spe) {
        Map<String, Map<String, String>> plugins = this.parseHeader(spe);
        for (Map.Entry<String, Map<String, String>> entry : plugins.entrySet()) {
            String key = entry.getKey();
            try {
                CL loader = this.getLoader();
                String path = entry.getValue().get("path:");
                if (path != null) {
                    String[] parts;
                    String[] stringArray = parts = path.split("\\s*,\\s*");
                    int n = parts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String p = stringArray[n2];
                        File f = this.getFile(p).getAbsoluteFile();
                        loader.add(f.toURI().toURL());
                        ++n2;
                    }
                }
                this.trace("Using plugin %s", key);
                key = Processor.removeDuplicateMarker(key);
                try {
                    Class<?> c = loader.loadClass(key);
                    Object plugin = c.newInstance();
                    this.customize(plugin, entry.getValue());
                    list.add(plugin);
                }
                catch (Throwable t) {
                    String commands = entry.getValue().get("command:");
                    if (commands == null) {
                        this.error("Problem loading the plugin: %s exception: (%s)", key, t);
                        continue;
                    }
                    Collection<String> cs = Processor.split(commands);
                    this.missingCommand.addAll(cs);
                }
            }
            catch (Throwable e) {
                this.error("Problem loading the plugin: " + key + " exception: " + e, new Object[0]);
            }
        }
    }

    protected void setTypeSpecificPlugins(Set<Object> list) {
        list.add(executor);
        list.add(random);
        list.addAll(this.basicPlugins);
    }

    protected <T> T customize(T plugin, Map<String, String> map) {
        if (plugin instanceof Plugin) {
            if (map != null) {
                ((Plugin)plugin).setProperties(map);
            }
            ((Plugin)plugin).setReporter(this);
        }
        if (plugin instanceof RegistryPlugin) {
            ((RegistryPlugin)plugin).setRegistry(this);
        }
        return plugin;
    }

    public boolean isFailOk() {
        String v = this.getProperty("-failok", null);
        return v != null && v.equalsIgnoreCase("true");
    }

    public File getBase() {
        return this.base;
    }

    public void setBase(File base) {
        this.base = base;
    }

    public void clear() {
        this.errors.clear();
        this.warnings.clear();
    }

    @Override
    public void trace(String msg, Object ... parms) {
        Processor p = this.current();
        if (p.trace) {
            System.out.printf("# " + msg + "\n", parms);
        }
    }

    public <T> List<T> newList() {
        return new ArrayList();
    }

    public <T> Set<T> newSet() {
        return new TreeSet();
    }

    public static <K, V> Map<K, V> newMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public <T> List<T> newList(Collection<T> t) {
        return new ArrayList<T>(t);
    }

    public <T> Set<T> newSet(Collection<T> t) {
        return new TreeSet<T>(t);
    }

    public <K, V> Map<K, V> newMap(Map<K, V> t) {
        return new LinkedHashMap<K, V>(t);
    }

    @Override
    public void close() {
        for (Closeable c : this.toBeClosed) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.toBeClosed.clear();
    }

    public String _basedir(String[] args) {
        if (this.base == null) {
            throw new IllegalArgumentException("No base dir set");
        }
        return this.base.getAbsolutePath();
    }

    public Properties getProperties() {
        if (this.fixup) {
            this.fixup = false;
            this.begin();
        }
        return this.properties;
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    public void mergeProperties(File file, boolean override) {
        if (file.isFile()) {
            try {
                Properties properties = this.loadProperties(file);
                this.mergeProperties(properties, override);
            }
            catch (Exception e) {
                this.error("Error loading properties file: " + file, new Object[0]);
            }
        } else if (!file.exists()) {
            this.error("Properties file does not exist: " + file, new Object[0]);
        } else {
            this.error("Properties file must a file, not a directory: " + file, new Object[0]);
        }
    }

    public void mergeProperties(Properties properties, boolean override) {
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            if (!override && this.getProperties().containsKey(key)) continue;
            this.setProperty(key, value);
        }
    }

    public void setProperties(Properties properties) {
        this.doIncludes(this.getBase(), properties);
        this.properties.putAll((Map<?, ?>)properties);
    }

    public void addProperties(File file) throws Exception {
        this.addIncluded(file);
        Properties p = this.loadProperties(file);
        this.setProperties(p);
    }

    public synchronized void addIncluded(File file) {
        if (this.included == null) {
            this.included = new HashSet<File>();
        }
        this.included.add(file);
    }

    private void doIncludes(File ubase, Properties p) {
        String includes = p.getProperty("-include");
        if (includes != null) {
            includes = this.getReplacer().process(includes);
            p.remove("-include");
            Set<String> clauses = this.parseHeader(includes).keySet();
            for (String value : clauses) {
                boolean fileMustExist = true;
                boolean overwrite = true;
                while (true) {
                    if (value.startsWith("-")) {
                        fileMustExist = false;
                        value = value.substring(1).trim();
                        continue;
                    }
                    if (!value.startsWith("~")) break;
                    overwrite = false;
                    value = value.substring(1).trim();
                }
                try {
                    File file = Processor.getFile(ubase, value).getAbsoluteFile();
                    if (!file.isFile() && fileMustExist) {
                        this.error("Included file " + file + (file.exists() ? " does not exist" : " is directory"), new Object[0]);
                        continue;
                    }
                    this.doIncludeFile(file, overwrite, p);
                }
                catch (Exception e) {
                    if (!fileMustExist) continue;
                    this.error("Error in processing included file: " + value, e, new Object[0]);
                }
            }
        }
    }

    public void doIncludeFile(File file, boolean overwrite, Properties target) throws Exception {
        if (this.included != null && this.included.contains(file)) {
            this.error("Cyclic or multiple include of " + file, new Object[0]);
        } else {
            this.addIncluded(file);
            this.updateModified(file.lastModified(), ((Object)file).toString());
            FileInputStream in = new FileInputStream(file);
            Properties sub = file.getName().toLowerCase().endsWith(".mf") ? Processor.getManifestAsProperties(in) : this.loadProperties(in, file.getAbsolutePath());
            ((InputStream)in).close();
            this.doIncludes(file.getParentFile(), sub);
            for (Map.Entry<Object, Object> entry : sub.entrySet()) {
                if (!overwrite && target.containsKey(entry.getKey())) continue;
                target.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public void unsetProperty(String string) {
        this.getProperties().remove(string);
    }

    public boolean refresh() {
        this.plugins = null;
        if (this.propertiesFile == null) {
            return false;
        }
        boolean changed = this.updateModified(this.propertiesFile.lastModified(), "properties file");
        if (this.included != null) {
            for (File file : this.included) {
                if (changed) break;
                changed |= !file.exists() || this.updateModified(file.lastModified(), "include file: " + file);
            }
        }
        if (changed) {
            this.forceRefresh();
            return true;
        }
        return false;
    }

    public void forceRefresh() {
        this.included = null;
        this.properties.clear();
        this.setProperties(this.propertiesFile, this.base);
        this.propertiesChanged();
    }

    public void propertiesChanged() {
    }

    public void setProperties(File propertiesFile) throws IOException {
        propertiesFile = propertiesFile.getAbsoluteFile();
        this.setProperties(propertiesFile, propertiesFile.getParentFile());
    }

    public void setProperties(File propertiesFile, File base) {
        this.propertiesFile = propertiesFile.getAbsoluteFile();
        this.setBase(base);
        try {
            if (propertiesFile.isFile()) {
                long modified = propertiesFile.lastModified();
                if (modified > System.currentTimeMillis() + 100L) {
                    System.out.println("Huh? This is in the future " + propertiesFile);
                    this.modified = System.currentTimeMillis();
                } else {
                    this.modified = modified;
                }
                this.included = null;
                Properties p = this.loadProperties(propertiesFile);
                this.setProperties(p);
            } else if (this.fileMustExist) {
                this.error("No such properties file: " + propertiesFile, new Object[0]);
            }
        }
        catch (IOException e) {
            this.error("Could not load properties " + propertiesFile, new Object[0]);
        }
    }

    protected void begin() {
        if (Processor.isTrue(this.getProperty("-pedantic"))) {
            this.setPedantic(true);
        }
    }

    public static boolean isTrue(String value) {
        if (value == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(value);
    }

    /*
     * Unable to fully structure code
     */
    public String getProperty(String key, String deflt) {
        block3: {
            value = null;
            source = this;
            if (this.filter == null || !this.filter.contains(key)) ** GOTO lbl8
            value = (String)this.getProperties().get(key);
            break block3;
            while ((value = (String)source.getProperties().get(key)) == null) {
                source = source.getParent();
lbl8:
                // 2 sources

                if (source != null) continue;
            }
        }
        if (value != null) {
            return this.getReplacer().process(value, source);
        }
        if (deflt != null) {
            return this.getReplacer().process(deflt, this);
        }
        return null;
    }

    public Properties loadProperties(File file) throws IOException {
        this.updateModified(file.lastModified(), "Properties file: " + file);
        FileInputStream in = new FileInputStream(file);
        Properties p = this.loadProperties(in, file.getAbsolutePath());
        ((InputStream)in).close();
        return p;
    }

    Properties loadProperties(InputStream in, String name) throws IOException {
        int n = name.lastIndexOf(47);
        if (n > 0) {
            name = name.substring(0, n);
        }
        if (name.length() == 0) {
            name = ".";
        }
        try {
            Properties p = new Properties();
            p.load(in);
            return Processor.replaceAll(p, "\\$\\{\\.\\}", name);
        }
        catch (Exception e) {
            this.error("Error during loading properties file: " + name + ", error:" + e, new Object[0]);
            return new Properties();
        }
    }

    public static Properties replaceAll(Properties p, String pattern, String replacement) {
        Properties result = new Properties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            value = value.replaceAll(pattern, replacement);
            result.put(key, value);
        }
        return result;
    }

    public static Map<String, Map<String, String>> merge(String type, Map<String, Map<String, String>> instructions, Map<String, Map<String, String>> actual, Set<String> superfluous, Map<String, Map<String, String>> ignored) {
        HashMap<String, Map<String, String>> toVisit = new HashMap<String, Map<String, String>>(actual);
        Map<String, Map<String, String>> result = Processor.newMap();
        Iterator<String> i = instructions.keySet().iterator();
        while (i.hasNext()) {
            String instruction;
            String originalInstruction = instruction = i.next();
            Map<String, String> instructedAttributes = instructions.get(instruction);
            if (instruction.startsWith("=")) {
                result.put(instruction.substring(1), instructedAttributes);
                superfluous.remove(originalInstruction);
                continue;
            }
            if (Processor.isDuplicate(instruction)) {
                result.put(instruction, instructedAttributes);
                superfluous.remove(originalInstruction);
                continue;
            }
            Instruction instr = Instruction.getPattern(instruction);
            Iterator p = toVisit.keySet().iterator();
            while (p.hasNext()) {
                String packageName = (String)p.next();
                if (!instr.matches(packageName)) continue;
                superfluous.remove(originalInstruction);
                if (!instr.isNegated()) {
                    HashMap<String, String> newAttributes = new HashMap<String, String>();
                    newAttributes.putAll(actual.get(packageName));
                    newAttributes.putAll(instructedAttributes);
                    result.put(packageName, newAttributes);
                } else if (ignored != null) {
                    ignored.put(packageName, new HashMap());
                }
                p.remove();
            }
        }
        return result;
    }

    public static String printClauses(Map<String, Map<String, String>> exports) {
        return Processor.printClauses(exports, false);
    }

    public static String printClauses(Map<String, Map<String, String>> exports, boolean checkMultipleVersions) {
        StringBuffer sb = new StringBuffer();
        String del = "";
        for (String name : exports.keySet()) {
            Map<String, String> clause = exports.get(name);
            String outname = Processor.removeDuplicateMarker(name);
            sb.append(del);
            sb.append(outname);
            Processor.printClause(clause, sb);
            del = ",";
        }
        return sb.toString();
    }

    public static void printClause(Map<String, String> map, StringBuffer sb) {
        for (String key : map.keySet()) {
            boolean clean;
            if (key.equals("-noimport:") || key.equals("provide:") || key.equals("-split-package:") || key.equals("from:")) continue;
            String value = map.get(key).trim();
            sb.append(";");
            sb.append(key);
            sb.append("=");
            boolean bl = clean = value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"' || Verifier.TOKEN.matcher(value).matches();
            if (!clean) {
                sb.append("\"");
            }
            sb.append(value);
            if (clean) continue;
            sb.append("\"");
        }
    }

    public Macro getReplacer() {
        if (this.replacer == null) {
            this.replacer = new Macro(this, this.getMacroDomains());
            return this.replacer;
        }
        return this.replacer;
    }

    protected Object[] getMacroDomains() {
        return new Object[0];
    }

    public Properties getFlattenedProperties() {
        return this.getReplacer().getFlattenedProperties();
    }

    public boolean updateModified(long time, String reason) {
        if (time > this.lastModified) {
            this.lastModified = time;
            return true;
        }
        return false;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public void setProperty(String key, String value) {
        int i = 0;
        while (i < headers.length) {
            if (headers[i].equalsIgnoreCase(value)) {
                value = headers[i];
                break;
            }
            ++i;
        }
        this.getProperties().put(key, value);
    }

    public static Properties getManifestAsProperties(InputStream in) throws IOException {
        Properties p = new Properties();
        Manifest manifest = new Manifest(in);
        for (Attributes.Name name : manifest.getMainAttributes().keySet()) {
            String value = manifest.getMainAttributes().getValue(name);
            p.put(((Object)name).toString(), value);
        }
        return p;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setFileMustExist(boolean mustexist) {
        this.fileMustExist = mustexist;
    }

    public static String read(InputStream in) throws Exception {
        InputStreamReader ir = new InputStreamReader(in, "UTF8");
        StringBuilder sb = new StringBuilder();
        try {
            char[] chars = new char[1000];
            int size = ir.read(chars);
            while (size > 0) {
                sb.append(chars, 0, size);
                size = ir.read(chars);
            }
        }
        finally {
            ir.close();
        }
        return sb.toString();
    }

    public static String join(Collection<?> list, String delimeter) {
        return Processor.join(delimeter, list);
    }

    public static String join(String delimeter, Collection<?> ... list) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        Collection<?>[] collectionArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<?> l = collectionArray[n2];
            if (list != null) {
                for (Object item : l) {
                    sb.append(del);
                    sb.append(item);
                    del = delimeter;
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String join(Object[] list, String delimeter) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        Object[] objectArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            sb.append(del);
            sb.append(item);
            del = delimeter;
            ++n2;
        }
        return sb.toString();
    }

    public static String join(Collection<?> ... list) {
        return Processor.join(",", list);
    }

    public static <T> String join(T[] list) {
        return Processor.join(list, ",");
    }

    public static void split(String s, Collection<String> set) {
        String[] elements;
        String[] stringArray = elements = s.trim().split(LIST_SPLITTER);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.length() > 0) {
                set.add(element);
            }
            ++n2;
        }
    }

    public static Collection<String> split(String s) {
        return Processor.split(s, LIST_SPLITTER);
    }

    public static Collection<String> split(String s, String splitter) {
        if (s != null) {
            s = s.trim();
        }
        if (s == null || s.trim().length() == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(s.split(splitter));
    }

    public static String merge(String ... strings) {
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s != null) {
                Processor.split(s, result);
            }
            ++n2;
        }
        return Processor.join(result);
    }

    public boolean isExceptions() {
        return this.exceptions;
    }

    public void setExceptions(boolean exceptions) {
        this.exceptions = exceptions;
    }

    public String normalize(String f) {
        if (f.startsWith(String.valueOf(this.base.getAbsolutePath()) + "/")) {
            return f.substring(this.base.getAbsolutePath().length() + 1);
        }
        return f;
    }

    public String normalize(File f) {
        return this.normalize(f.getAbsolutePath());
    }

    public static String removeDuplicateMarker(String key) {
        int i = key.length() - 1;
        while (i >= 0 && key.charAt(i) == '~') {
            --i;
        }
        return key.substring(0, i + 1);
    }

    public static boolean isDuplicate(String name) {
        return name.length() > 0 && name.charAt(name.length() - 1) == '~';
    }

    public void setTrace(boolean x) {
        this.trace = x;
    }

    private CL getLoader() {
        if (this.pluginLoader == null) {
            this.pluginLoader = new CL();
        }
        return this.pluginLoader;
    }

    public boolean exists() {
        return this.base != null && this.base.isDirectory() && this.propertiesFile != null && this.propertiesFile.isFile();
    }

    public boolean isOk() {
        return this.isFailOk() || this.getErrors().size() == 0;
    }

    public boolean isPerfect() {
        return this.getErrors().size() == 0 && this.getWarnings().size() == 0;
    }

    public void setForceLocal(Collection<String> local) {
        this.filter = local;
    }

    public boolean isMissingPlugin(String name) {
        this.getPlugins();
        return this.missingCommand != null && this.missingCommand.contains(name);
    }

    public static String appendPath(String ... parts) {
        StringBuilder sb = new StringBuilder();
        boolean lastSlash = true;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            int i = 0;
            while (i < part.length()) {
                char c = part.charAt(i);
                if (c == '/') {
                    if (!lastSlash) {
                        sb.append('/');
                    }
                    lastSlash = true;
                } else {
                    sb.append(c);
                    lastSlash = false;
                }
                ++i;
            }
            if (!lastSlash & sb.length() > 0) {
                sb.append('/');
                lastSlash = true;
            }
            ++n2;
        }
        if (lastSlash && sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static Map<String, String> doAttrbutes(Object[] attrs, Clazz clazz, Macro macro) {
        if (attrs == null || attrs.length == 0) {
            return Collections.emptyMap();
        }
        Map<String, String> map = Processor.newMap();
        Object[] objectArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            Object a = objectArray[n2];
            String attr = (String)a;
            int n3 = attr.indexOf("=");
            if (n3 <= 0) {
                throw new IllegalArgumentException(Processor.formatArrays("Invalid attribute on package-info.java in %s , %s. Must be <key>=<name> ", clazz, attr));
            }
            map.put(attr.substring(0, n3), macro.process(attr.substring(n3 + 1)));
            ++n2;
        }
        return map;
    }

    public static String formatArrays(String string, Object ... parms) {
        Object[] parms2 = parms;
        Object[] output = new Object[parms.length];
        int i = 0;
        while (i < parms.length) {
            output[i] = Processor.makePrintable(parms[i]);
            ++i;
        }
        return String.format(string, parms2);
    }

    public static Object makePrintable(Object object) {
        if (object == null) {
            return object;
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            Object[] output = new Object[array.length];
            int i = 0;
            while (i < array.length) {
                output[i] = Processor.makePrintable(array[i]);
                ++i;
            }
            return Arrays.toString(output);
        }
        return object;
    }

    public static String append(String ... strings) {
        List result = Create.list();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            result.addAll(Processor.split(s));
            ++n2;
        }
        return Processor.join(result);
    }

    public synchronized Class<?> getClass(String type, File jar) throws Exception {
        CL cl = this.getLoader();
        cl.add(jar.toURI().toURL());
        return cl.loadClass(type);
    }

    public boolean isTrace() {
        return this.current().trace;
    }

    public static long getDuration(String tm, long dflt) {
        if (tm == null) {
            return dflt;
        }
        tm = tm.toUpperCase();
        TimeUnit unit = TimeUnit.MILLISECONDS;
        Matcher m = Pattern.compile("\\s*(\\d+)\\s*(NANOSECONDS|MICROSECONDS|MILLISECONDS|SECONDS|MINUTES|HOURS|DAYS)?").matcher(tm);
        if (m.matches()) {
            long duration = Long.parseLong(tm);
            String u = m.group(2);
            if (u != null) {
                unit = TimeUnit.valueOf(u);
            }
            duration = TimeUnit.MILLISECONDS.convert(duration, unit);
            return duration;
        }
        return dflt;
    }

    public String _random(String[] args) {
        int numchars = 8;
        if (args.length > 1) {
            try {
                numchars = Integer.parseInt(args[1]);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid character count parameter in ${random} macro.");
            }
        }
        if (random == null) {
            random = new Random();
        }
        char[] letters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
        char[] alphanums = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        char[] array = new char[numchars];
        int i = 0;
        while (i < numchars) {
            char c = i == 0 ? letters[random.nextInt(letters.length)] : alphanums[random.nextInt(alphanums.length)];
            array[i] = c;
            ++i;
        }
        return new String(array);
    }

    protected Processor beginHandleErrors(String message) {
        this.trace("begin %s", message);
        Processor previous = current.get();
        current.set(this);
        return previous;
    }

    protected void endHandleErrors(Processor previous) {
        this.trace("end", new Object[0]);
        current.set(previous);
    }

    public static Executor getExecutor() {
        return executor;
    }

    public synchronized void addBasicPlugin(Object plugin) {
        this.basicPlugins.add(plugin);
        if (this.plugins != null) {
            this.plugins.add(plugin);
        }
    }

    public synchronized void removeBasicPlugin(Object plugin) {
        this.basicPlugins.remove(plugin);
        if (this.plugins != null) {
            this.plugins.remove(plugin);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CL
    extends URLClassLoader {
        CL() {
            super(new URL[0], Processor.class.getClassLoader());
        }

        void add(URL url) {
            URL[] urls;
            URL[] uRLArray = urls = this.getURLs();
            int n = urls.length;
            int n2 = 0;
            while (n2 < n) {
                URL u = uRLArray[n2];
                if (((Object)u).equals(url)) {
                    return;
                }
                ++n2;
            }
            super.addURL(url);
        }

        @Override
        public Class<?> loadClass(String name) throws NoClassDefFoundError {
            try {
                Class<?> c = super.loadClass(name);
                return c;
            }
            catch (Throwable t) {
                StringBuilder sb = new StringBuilder();
                sb.append(name);
                sb.append(" not found, parent:  ");
                sb.append(this.getParent());
                sb.append(" urls:");
                sb.append(Arrays.toString(this.getURLs()));
                sb.append(" exception:");
                sb.append(t);
                throw new NoClassDefFoundError(sb.toString());
            }
        }
    }
}

