/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.extender.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.ipojo.extender.internal.BundleProcessor;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainedBundleProcessor
implements BundleProcessor {
    private final List<BundleProcessor> m_processors = new ArrayList<BundleProcessor>();

    private ChainedBundleProcessor() {
    }

    public static ChainedBundleProcessor create(BundleProcessor ... processors) {
        if (processors == null || processors.length == 0) {
            throw new IllegalArgumentException("Chained processor cannot be created without processors");
        }
        ChainedBundleProcessor chain = new ChainedBundleProcessor();
        Collections.addAll(chain.m_processors, processors);
        return chain;
    }

    public List<BundleProcessor> getProcessors() {
        ArrayList<BundleProcessor> list = new ArrayList<BundleProcessor>();
        list.addAll(this.m_processors);
        return list;
    }

    @Override
    public void activate(Bundle bundle) {
        for (BundleProcessor processor : this.m_processors) {
            processor.activate(bundle);
        }
    }

    @Override
    public void deactivate(Bundle bundle) {
        ArrayList<BundleProcessor> reverse = new ArrayList<BundleProcessor>(this.m_processors);
        Collections.reverse(reverse);
        for (BundleProcessor processor : reverse) {
            processor.deactivate(bundle);
        }
    }

    @Override
    public void start() {
        for (BundleProcessor processor : this.m_processors) {
            processor.start();
        }
    }

    @Override
    public void stop() {
        ArrayList<BundleProcessor> reverse = new ArrayList<BundleProcessor>(this.m_processors);
        Collections.reverse(reverse);
        for (BundleProcessor processor : reverse) {
            processor.stop();
        }
    }
}

