/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.test.scenarios.annotations;

import org.apache.felix.ipojo.junit4osgi.OSGiTestCase;
import org.apache.felix.ipojo.junit4osgi.helpers.IPOJOHelper;
import org.apache.felix.ipojo.metadata.Element;

public class Dependency
extends OSGiTestCase {
    private IPOJOHelper helper;

    public void setUp() {
        this.helper = new IPOJOHelper((OSGiTestCase)this);
    }

    public void testDependencyDeclaration() {
        Element meta = this.helper.getMetadata("org.apache.felix.ipojo.test.scenarios.component.Dependency");
        Element[] deps = meta.getElements("requires");
        Element dep = this.getDependencyById(deps, "fs");
        String field = dep.getAttribute("field");
        String id = dep.getAttribute("id");
        String bind = this.getBind(dep);
        String unbind = this.getUnbind(dep);
        Dependency.assertNotNull((String)"Check fs field", (Object)field);
        Dependency.assertEquals((String)"Check fs field", (String)"fs", (String)field);
        Dependency.assertNull((String)"Check fs bind", (Object)bind);
        Dependency.assertNull((String)"Check fs unbind", (Object)unbind);
        Dependency.assertNull((String)"Check fs id", (Object)id);
        dep = this.getDependencyById(deps, "Bar");
        field = dep.getAttribute("field");
        id = dep.getAttribute("id");
        bind = this.getBind(dep);
        unbind = this.getUnbind(dep);
        Dependency.assertNull((String)"Check bar field", (Object)field);
        Dependency.assertEquals((String)"Check bar bind", (String)"bindBar", (String)bind);
        Dependency.assertEquals((String)"Check bar unbind", (String)"unbindBar", (String)unbind);
        Dependency.assertEquals((String)"Check bar id", (String)"Bar", (String)id);
        dep = this.getDependencyById(deps, "Baz");
        field = dep.getAttribute("field");
        id = dep.getAttribute("id");
        bind = this.getBind(dep);
        unbind = this.getUnbind(dep);
        Dependency.assertNull((String)"Check baz field", (Object)field);
        Dependency.assertEquals((String)"Check baz bind", (String)"bindBaz", (String)bind);
        Dependency.assertEquals((String)"Check baz unbind", (String)"unbindBaz", (String)unbind);
        Dependency.assertEquals((String)"Check baz id", (String)"Baz", (String)id);
        dep = this.getDependencyById(deps, "fs2");
        field = dep.getAttribute("field");
        id = dep.getAttribute("id");
        bind = this.getBind(dep);
        unbind = this.getUnbind(dep);
        Dependency.assertNotNull((String)"Check fs2 field", (Object)field);
        Dependency.assertEquals((String)"Check fs2 field", (String)"fs2", (String)field);
        Dependency.assertEquals((String)"Check fs2 bind", (String)"bindFS2", (String)bind);
        Dependency.assertEquals((String)"Check fs2 unbind", (String)"unbindFS2", (String)unbind);
        dep = this.getDependencyById(deps, "fs2inv");
        field = dep.getAttribute("field");
        id = dep.getAttribute("id");
        bind = this.getBind(dep);
        unbind = this.getUnbind(dep);
        Dependency.assertNotNull((String)"Check fs2inv field", (Object)field);
        Dependency.assertEquals((String)"Check fs2 field", (String)"fs2inv", (String)field);
        Dependency.assertEquals((String)"Check fs2 bind", (String)"bindFS2Inv", (String)bind);
        Dependency.assertEquals((String)"Check fs2 unbind", (String)"unbindFS2Inv", (String)unbind);
        Dependency.assertEquals((String)"Check fs2 id", (String)"inv", (String)id);
        dep = this.getDependencyById(deps, "mod");
        id = dep.getAttribute("id");
        bind = this.getBind(dep);
        unbind = this.getUnbind(dep);
        String mod = this.getModified(dep);
        Dependency.assertEquals((String)"Check mod bind", (String)"bindMod", (String)bind);
        Dependency.assertEquals((String)"Check mod unbind", (String)"unbindMod", (String)unbind);
        Dependency.assertEquals((String)"Check mod modified", (String)"modifiedMod", (String)mod);
        Dependency.assertEquals((String)"Check mod id", (String)"mod", (String)id);
        dep = this.getDependencyById(deps, "notproxied");
        Dependency.assertEquals((String)"Check not proxied", (String)"false", (String)dep.getAttribute("proxy"));
    }

    private Element getDependencyById(Element[] deps, String name) {
        int i = 0;
        while (i < deps.length) {
            String na = deps[i].getAttribute("id");
            String field = deps[i].getAttribute("field");
            if (na != null && na.equalsIgnoreCase(name)) {
                return deps[i];
            }
            if (field != null && field.equalsIgnoreCase(name)) {
                return deps[i];
            }
            ++i;
        }
        Dependency.fail((String)("Dependency  " + name + " not found"));
        return null;
    }

    private String getBind(Element dep) {
        Element[] elem = dep.getElements("callback");
        int i = 0;
        while (elem != null && i < elem.length) {
            if (elem[i].getAttribute("type").equalsIgnoreCase("bind")) {
                return elem[i].getAttribute("method");
            }
            ++i;
        }
        return null;
    }

    private String getUnbind(Element dep) {
        Element[] elem = dep.getElements("callback");
        int i = 0;
        while (elem != null && i < elem.length) {
            if (elem[i].getAttribute("type").equalsIgnoreCase("unbind")) {
                return elem[i].getAttribute("method");
            }
            ++i;
        }
        return null;
    }

    private String getModified(Element dep) {
        Element[] elem = dep.getElements("callback");
        int i = 0;
        while (elem != null && i < elem.length) {
            if (elem[i].getAttribute("type").equalsIgnoreCase("modified")) {
                return elem[i].getAttribute("method");
            }
            ++i;
        }
        return null;
    }
}

