/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.metadata.Attribute;

public class Element {
    private String m_name;
    private String m_nameSpace;
    private Map m_attributes = new LinkedHashMap();
    private Map m_elements = new LinkedHashMap();

    public Element(String name, String ns) {
        this.m_name = name.toLowerCase();
        if (ns != null && ns.length() > 0) {
            this.m_nameSpace = ns.toLowerCase();
        }
    }

    public Element[] getElements() {
        Collection col = this.m_elements.values();
        Iterator it = col.iterator();
        ArrayList<Element> list = new ArrayList<Element>();
        while (it.hasNext()) {
            Element[] v = (Element[])it.next();
            for (int i = 0; i < v.length; ++i) {
                list.add(v[i]);
            }
        }
        return list.toArray(new Element[list.size()]);
    }

    public Attribute[] getAttributes() {
        return this.m_attributes.values().toArray(new Attribute[0]);
    }

    public String getName() {
        return this.m_name;
    }

    public String getNameSpace() {
        return this.m_nameSpace;
    }

    public String getAttribute(String name) {
        Attribute att = (Attribute)this.m_attributes.get(name = name.toLowerCase());
        if (att == null) {
            return null;
        }
        return att.getValue();
    }

    public String getAttribute(String name, String ns) {
        name = ns.toLowerCase() + ":" + name.toLowerCase();
        return this.getAttribute(name);
    }

    private String getQualifiedName() {
        if (this.m_nameSpace == null) {
            return this.m_name;
        }
        return this.m_nameSpace + ":" + this.m_name;
    }

    public void addElement(Element elem) {
        Element[] array = (Element[])this.m_elements.get(elem.getQualifiedName());
        if (array == null) {
            this.m_elements.put(elem.getQualifiedName(), new Element[]{elem});
        } else {
            Element[] newElementsList = new Element[array.length + 1];
            System.arraycopy(array, 0, newElementsList, 0, array.length);
            newElementsList[array.length] = elem;
            this.m_elements.put(elem.getQualifiedName(), newElementsList);
        }
    }

    public void removeElement(Element elem) {
        Element[] array = (Element[])this.m_elements.get(elem.getQualifiedName());
        if (array == null) {
            return;
        }
        int idx = -1;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != elem) continue;
            idx = i;
            break;
        }
        if (idx >= 0) {
            if (array.length - 1 == 0) {
                this.m_elements.remove(elem.getQualifiedName());
            } else {
                Element[] newElementsList = new Element[array.length - 1];
                System.arraycopy(array, 0, newElementsList, 0, idx);
                if (idx < newElementsList.length) {
                    System.arraycopy(array, idx + 1, newElementsList, idx, newElementsList.length - idx);
                }
                this.m_elements.put(elem.getQualifiedName(), newElementsList);
            }
        }
    }

    public void addAttribute(Attribute att) {
        String name = att.getName().toLowerCase();
        if (att.getNameSpace() != null) {
            name = att.getNameSpace().toLowerCase() + ":" + name;
        }
        this.m_attributes.put(name, att);
    }

    public void removeAttribute(Attribute att) {
        String name = att.getName();
        if (att.getNameSpace() != null) {
            name = att.getNameSpace() + ":" + name;
        }
        this.m_attributes.remove(name);
    }

    public Element[] getElements(String name) {
        Element[] elems = (Element[])this.m_elements.get(name.toLowerCase());
        return elems;
    }

    public Element[] getElements(String name, String ns) {
        if (ns == null || ns.length() == 0) {
            return this.getElements(name);
        }
        name = ns + ":" + name;
        return this.getElements(name);
    }

    public boolean containsElement(String name) {
        return this.m_elements.containsKey(name.toLowerCase());
    }

    public boolean containsElement(String name, String ns) {
        if (ns != null && ns.length() != 0) {
            name = ns + ":" + name;
        }
        return this.containsElement(name);
    }

    public boolean containsAttribute(String name) {
        return this.m_attributes.containsKey(name.toLowerCase());
    }

    public String toXMLString() {
        return this.toXMLString(0);
    }

    private String toXMLString(int indent) {
        StringBuffer xml = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        for (int j = 0; j < indent; ++j) {
            tabs.append("\t");
        }
        xml.append(tabs);
        if (this.m_nameSpace == null) {
            xml.append("<" + this.m_name);
        } else {
            xml.append("<" + this.m_nameSpace + ":" + this.m_name);
        }
        Set keys = this.m_attributes.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Attribute current = (Attribute)this.m_attributes.get(it.next());
            if (current.getNameSpace() == null) {
                xml.append(" " + current.getName() + "=\"" + current.getValue() + "\"");
                continue;
            }
            xml.append(" " + current.getNameSpace() + ":" + current.getName() + "=\"" + current.getValue() + "\"");
        }
        if (this.m_elements.size() == 0) {
            xml.append("/>");
            return xml.toString();
        }
        xml.append(">");
        keys = this.m_elements.keySet();
        it = keys.iterator();
        while (it.hasNext()) {
            Element[] e = (Element[])this.m_elements.get(it.next());
            for (int i = 0; i < e.length; ++i) {
                xml.append("\n");
                xml.append(e[i].toXMLString(indent + 1));
            }
        }
        xml.append("\n" + tabs + "</" + this.m_name + ">");
        return xml.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    private String toString(int indent) {
        StringBuffer xml = new StringBuffer();
        StringBuffer tabs = new StringBuffer();
        for (int j = 0; j < indent; ++j) {
            tabs.append("\t");
        }
        xml.append(tabs);
        if (this.m_nameSpace == null) {
            xml.append(this.m_name);
        } else {
            xml.append(this.m_nameSpace + ":" + this.m_name);
        }
        Set keys = this.m_attributes.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Attribute current = (Attribute)this.m_attributes.get(it.next());
            if (current.getNameSpace() == null) {
                xml.append(" " + current.getName() + "=\"" + current.getValue() + "\"");
                continue;
            }
            xml.append(" " + current.getNameSpace() + ":" + current.getName() + "=\"" + current.getValue() + "\"");
        }
        if (this.m_elements.size() == 0) {
            return xml.toString();
        }
        keys = this.m_elements.keySet();
        it = keys.iterator();
        while (it.hasNext()) {
            Element[] e = (Element[])this.m_elements.get(it.next());
            for (int i = 0; i < e.length; ++i) {
                xml.append("\n");
                xml.append(e[i].toString(indent + 1));
            }
        }
        return xml.toString();
    }
}

