/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.threaddump.internal;

import org.apache.felix.threaddump.internal.ThreadDumper;
import org.apache.felix.threaddump.internal.ThreadWriter;

final class Jdk14ThreadDumper
implements ThreadDumper {
    Jdk14ThreadDumper() {
    }

    public void printThreads(ThreadWriter threadWriter) {
        ThreadGroup rootGroup = Jdk14ThreadDumper.getRootThreadGroup();
        Jdk14ThreadDumper.printThreadGroup(threadWriter, rootGroup);
        int numGroups = rootGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[2 * numGroups];
        rootGroup.enumerate(groups);
        for (int i = 0; i < groups.length; ++i) {
            Jdk14ThreadDumper.printThreadGroup(threadWriter, groups[i]);
        }
    }

    private static ThreadGroup getRootThreadGroup() {
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while (rootGroup.getParent() != null) {
            rootGroup = rootGroup.getParent();
        }
        return rootGroup;
    }

    private static void printThreadGroup(ThreadWriter threadWriter, ThreadGroup group) {
        if (group != null) {
            int numThreads = group.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            group.enumerate(threads, false);
            for (int i = 0; i < threads.length; ++i) {
                Jdk14ThreadDumper.printThread(threadWriter, threads[i]);
            }
        }
    }

    private static void printThread(ThreadWriter threadWriter, Thread thread) {
        if (thread != null) {
            short status = 0;
            if (thread.isAlive()) {
                status = 1;
            } else if (thread.isInterrupted()) {
                status = 5;
            }
            threadWriter.printThread(thread.getName(), thread.isDaemon(), thread.getPriority(), -1L, status);
            threadWriter.printEmptyLine();
        }
    }
}

