/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.InetAddress;
import java.util.Vector;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.device.SearchListener;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPSearchSocket;

public class SSDPSearchSocketList
extends Vector {
    private InetAddress[] binds = null;
    private String multicastIPv4 = "239.255.255.250";
    private String multicastIPv6 = SSDP.getIPv6Address();
    private int port = SSDP.PORT;

    public SSDPSearchSocketList() {
    }

    public SSDPSearchSocketList(InetAddress[] binds) {
        this.binds = binds;
    }

    public SSDPSearchSocketList(InetAddress[] binds, int port, String multicastIPv4, String multicastIPv6) {
        this.binds = binds;
        this.port = port;
        this.multicastIPv4 = multicastIPv4;
        this.multicastIPv6 = multicastIPv6;
    }

    public SSDPSearchSocket getSSDPSearchSocket(int n) {
        return (SSDPSearchSocket)this.get(n);
    }

    public void addSearchListener(SearchListener listener) {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            SSDPSearchSocket sock = this.getSSDPSearchSocket(n);
            sock.addSearchListener(listener);
        }
    }

    public boolean open() {
        int i;
        String[] bindAddresses;
        InetAddress[] binds = this.binds;
        if (binds != null) {
            bindAddresses = new String[binds.length];
            for (i = 0; i < binds.length; ++i) {
                bindAddresses[i] = binds[i].getHostAddress();
            }
        } else {
            int nHostAddrs = HostInterface.getNHostAddresses();
            bindAddresses = new String[nHostAddrs];
            for (int n = 0; n < nHostAddrs; ++n) {
                bindAddresses[n] = HostInterface.getHostAddress(n);
            }
        }
        for (i = 0; i < bindAddresses.length; ++i) {
            if (bindAddresses[i] == null) continue;
            SSDPSearchSocket ssdpSearchSocket = HostInterface.isIPv6Address(bindAddresses[i]) ? new SSDPSearchSocket(bindAddresses[i], this.port, this.multicastIPv6) : new SSDPSearchSocket(bindAddresses[i], this.port, this.multicastIPv4);
            this.add(ssdpSearchSocket);
        }
        return true;
    }

    public void close() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchSocket sock = this.getSSDPSearchSocket(n);
            sock.close();
        }
        this.clear();
    }

    public void start() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchSocket sock = this.getSSDPSearchSocket(n);
            sock.start();
        }
    }

    public void stop() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchSocket sock = this.getSSDPSearchSocket(n);
            sock.stop();
        }
    }
}

