/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.extra.util;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.upnp.UPnPEventListener;

public class UPnPSubscriber {
    private BundleContext context;
    private UPnPEventListener listener;
    private HashMap hash;
    static /* synthetic */ Class class$org$osgi$service$upnp$UPnPEventListener;

    public UPnPSubscriber(BundleContext context, UPnPEventListener listener) {
        if (context == null || listener == null) {
            throw new IllegalArgumentException("Illegal arguments in UPnPSubscriber constructor.");
        }
        this.context = context;
        this.listener = listener;
        this.hash = new HashMap();
    }

    public void subscribe(String filter) {
        if (this.hash.get(filter) == null) {
            this.hash.put(filter, new Subscription(filter));
        }
    }

    public void unsubscribe(String filter) {
        if (this.hash.containsKey(filter)) {
            Subscription subscription = (Subscription)this.hash.get(filter);
            subscription.unsubscribe();
            this.hash.remove(filter);
        }
    }

    public void unsubscribeAll() {
        Iterator list = this.hash.entrySet().iterator();
        while (list.hasNext()) {
            Map.Entry entry = list.next();
            Subscription subcription = (Subscription)entry.getValue();
            subcription.unsubscribe();
            list.remove();
        }
    }

    public String subscribeServiceIdOf(String deviceId, String serviceId) {
        String keys = "(&(UPnP.device.UDN=" + deviceId + ")(" + "UPnP.service.id" + "=" + serviceId + "))";
        this.subscribe(keys);
        return keys;
    }

    public String subscribeServiceTypeOf(String deviceId, String serviceType) {
        String keys = "(&(UPnP.device.UDN=" + deviceId + ")(" + "UPnP.service.type" + "=" + serviceType + "))";
        this.subscribe(keys);
        return keys;
    }

    public String subscribeEveryServiceType(String deviceType, String serviceType) {
        String keys = "(&(UPnP.device.type=" + deviceType + ")(" + "UPnP.service.type" + "=" + serviceType + "))";
        this.subscribe(keys);
        return keys;
    }

    public String subscribeAllServicesOf(String deviceId) {
        String keys = "(UPnP.device.UDN=" + deviceId + ")";
        this.subscribe(keys);
        return keys;
    }

    public String subscribeEveryDeviceTypeServices(String deviceType) {
        String keys = "(UPnP.device.type=" + deviceType + ")";
        this.subscribe(keys);
        return keys;
    }

    public void unsubscribeServiceIdOf(String deviceId, String serviceId) {
        String keys = "(&(UPnP.device.UDN=" + deviceId + ")(" + "UPnP.service.id" + "=" + serviceId + "))";
        this.unsubscribe(keys);
    }

    public void unsubscribeAllServicesOf(String deviceId) {
        String keys = "(UPnP.device.UDN=" + deviceId + ")";
        this.unsubscribe(keys);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Subscription
    implements UPnPEventListener {
        ServiceRegistration registration;

        Subscription(String keys) {
            try {
                Filter filter = UPnPSubscriber.this.context.createFilter(keys);
                Properties props = new Properties();
                props.put("upnp.filter", filter);
                this.registration = UPnPSubscriber.this.context.registerService((class$org$osgi$service$upnp$UPnPEventListener == null ? (class$org$osgi$service$upnp$UPnPEventListener = UPnPSubscriber.class$("org.osgi.service.upnp.UPnPEventListener")) : class$org$osgi$service$upnp$UPnPEventListener).getName(), (Object)this, (Dictionary)props);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }

        public void unsubscribe() {
            this.registration.unregister();
        }

        public void notifyUPnPEvent(String arg0, String arg1, Dictionary arg2) {
            UPnPSubscriber.this.listener.notifyUPnPEvent(arg0, arg1, arg2);
        }
    }
}

