/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.felix.upnp.basedriver.util.Converter;
import org.apache.felix.upnp.tester.Mediator;
import org.apache.felix.upnp.tester.gui.ArgumentsModel;
import org.apache.felix.upnp.tester.gui.LogPanel;
import org.apache.felix.upnp.tester.gui.MyTable;
import org.apache.felix.upnp.tester.gui.OutputArgumentsModel;
import org.apache.felix.upnp.tester.gui.Util;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPException;

public class ActionPanel
extends JPanel {
    UPnPAction action;
    ArgumentsModel argsModel;
    MyTable table;
    JPanel buttonPanel;
    OutputArgumentsModel outArgsModel;
    JTable outTable;

    public ActionPanel() {
        super(new GridBagLayout());
        this.buildButtonPanel();
        this.buildTable();
        this.add((Component)new JScrollPane(this.table), Util.setConstrains(0, 0, 1, 1, 100, 100));
        this.add((Component)new JScrollPane(this.outTable), Util.setConstrains(0, 1, 1, 1, 100, 100));
        this.add((Component)this.buttonPanel, Util.setConstrains(1, 0, 1, 1, 1, 1));
    }

    private void buildButtonPanel() {
        this.buttonPanel = new JPanel();
        JButton doAction = new JButton("Do Action");
        doAction.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ActionPanel.this.outArgsModel.clearData();
                Hashtable<String, Object> params = null;
                Dictionary result = null;
                if (ActionPanel.this.argsModel.getRowCount() != 0) {
                    if (ActionPanel.this.table.isEditing()) {
                        ActionPanel.this.table.getCellEditor().stopCellEditing();
                    }
                    params = new Hashtable<String, Object>();
                    for (int i = 0; i < ActionPanel.this.argsModel.getRowCount(); ++i) {
                        String name = (String)ActionPanel.this.argsModel.getValueAt(i, 0);
                        String value = (String)ActionPanel.this.argsModel.getValueAt(i, 3);
                        try {
                            ((Dictionary)params).put(name, Converter.parseString((String)value, (String)ActionPanel.this.action.getStateVariable(name).getUPnPDataType()));
                            continue;
                        }
                        catch (Exception ex) {
                            LogPanel.log("Error invoking action (bad parameter)");
                            return;
                        }
                    }
                }
                try {
                    result = ActionPanel.this.action.invoke(params);
                }
                catch (UPnPException ex) {
                    String error = "===== Action Failed =====\nUPnP Error Code::\n    " + ex.getUPnPError_Code() + "\nUPnP Error Description::\n    " + ex.getMessage();
                    this.printReport(params, error);
                    JOptionPane.showMessageDialog(Mediator.getPropertiesViewer(), error);
                }
                catch (Exception ex) {
                    this.printReport(params, ex.getMessage());
                    JOptionPane.showMessageDialog(Mediator.getPropertiesViewer(), ex.getMessage());
                }
                if (result != null) {
                    this.printReport(params, result);
                    ActionPanel.this.outArgsModel.setData(ActionPanel.this.action, result);
                    JOptionPane.showMessageDialog(Mediator.getPropertiesViewer(), "Action invoked!");
                }
            }

            private void printReport(Dictionary params, Object result) {
                String input = "";
                String output = "";
                if (params != null) {
                    input = params.toString();
                }
                if (output != null) {
                    output = result.toString();
                }
                String method = ActionPanel.this.action.getName();
                String report = "\n==== Action:: " + method + " ====\n" + input + "\n----------- result ----------\n" + output + "\n-----------------------------";
                LogPanel.log(report);
            }
        });
        this.buttonPanel.add(doAction);
    }

    private void buildTable() {
        this.argsModel = new ArgumentsModel();
        this.table = new MyTable(this.argsModel);
        this.argsModel.setTable(this.table);
        this.outArgsModel = new OutputArgumentsModel();
        this.outTable = new JTable(this.outArgsModel);
    }

    public void setArguments(UPnPAction action) {
        this.action = action;
        this.argsModel.setData(action);
        this.outArgsModel.clearData();
    }
}

