/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.apache.felix.upnp.tester.gui.MyTable;
import org.apache.felix.upnp.tester.gui.SliderEditor;
import org.osgi.service.upnp.UPnPAction;
import org.osgi.service.upnp.UPnPStateVariable;

class ArgumentsModel
extends AbstractTableModel {
    int size = 0;
    private MyTable table;
    String[] names = new String[]{""};
    String[] related = new String[]{""};
    String[] types = new String[]{""};
    String[] values = new String[]{""};
    String[] header = new String[]{"arg name", "related Var", "Java \\ UpnP type", "value"};

    ArgumentsModel() {
    }

    public void setTable(MyTable table) {
        this.table = table;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.size;
    }

    public String getColumnName(int col) {
        return this.header[col];
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 3;
    }

    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.names[row];
        }
        if (col == 1) {
            return this.related[row];
        }
        if (col == 2) {
            return this.types[row];
        }
        if (col == 3) {
            return this.values[row];
        }
        return null;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.values[rowIndex] = (String)aValue;
    }

    public void setData(UPnPAction action) {
        this.table.deleteMyCellEditors();
        String[] names = action.getInputArgumentNames();
        this.size = 0;
        this.names = names;
        if (names != null) {
            this.values = new String[names.length];
            this.related = new String[names.length];
            this.types = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                int min;
                String val;
                this.values[i] = "";
                UPnPStateVariable currentStateVar = action.getStateVariable(names[i]);
                this.related[i] = currentStateVar.getName();
                String javaType = currentStateVar.getJavaDataType().toString();
                javaType = javaType.substring(javaType.lastIndexOf(46) + 1);
                String upnpType = currentStateVar.getUPnPDataType();
                this.types[i] = javaType + " \\ " + upnpType;
                if (currentStateVar.getAllowedValues() != null) {
                    String[] av = currentStateVar.getAllowedValues();
                    JComboBox<String> comboBox = new JComboBox<String>();
                    for (int j = 0; j < av.length; ++j) {
                        comboBox.addItem(av[j]);
                    }
                    this.values[i] = av[0];
                    this.table.setMyCellEditor(new DefaultCellEditor(comboBox), i);
                }
                if (currentStateVar.getDefaultValue() != null && (val = currentStateVar.getDefaultValue().toString()).length() > 0) {
                    this.values[i] = val;
                }
                if (currentStateVar.getMaximum() == null || currentStateVar.getMinimum() == null) continue;
                int max = currentStateVar.getMaximum().intValue();
                int value = min = currentStateVar.getMinimum().intValue();
                try {
                    value = Integer.parseInt(this.values[i]);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
                this.table.setMyCellEditor(new SliderEditor(min, max, value), i);
            }
            this.size = names.length;
        }
        this.fireTableChanged(new TableModelEvent(this));
        this.fireTableStructureChanged();
    }
}

