/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.application;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.application.ApplicationException;
import org.osgi.service.application.ApplicationHandle;
import org.osgi.service.application.ScheduledApplication;

public abstract class ApplicationDescriptor {
    public static final String APPLICATION_NAME = "application.name";
    public static final String APPLICATION_ICON = "application.icon";
    public static final String APPLICATION_PID = "service.pid";
    public static final String APPLICATION_VERSION = "application.version";
    public static final String APPLICATION_VENDOR = "service.vendor";
    public static final String APPLICATION_VISIBLE = "application.visible";
    public static final String APPLICATION_LAUNCHABLE = "application.launchable";
    public static final String APPLICATION_LOCKED = "application.locked";
    public static final String APPLICATION_DESCRIPTION = "application.description";
    public static final String APPLICATION_DOCUMENTATION = "application.documentation";
    public static final String APPLICATION_COPYRIGHT = "application.copyright";
    public static final String APPLICATION_LICENSE = "application.license";
    public static final String APPLICATION_CONTAINER = "application.container";
    public static final String APPLICATION_LOCATION = "application.location";
    private final String pid;
    Delegate delegate;
    static /* synthetic */ Class class$org$osgi$service$application$ApplicationDescriptor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Map;

    protected ApplicationDescriptor(String applicationId) {
        if (null == applicationId) {
            throw new NullPointerException("Application ID must not be null!");
        }
        this.pid = applicationId;
        try {
            this.delegate = new Delegate();
            this.delegate.setApplicationDescriptor(this, applicationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println("No implementation available for ApplicationDescriptor, property is: " + Delegate.cName);
        }
    }

    public final String getApplicationId() {
        return this.pid;
    }

    public abstract boolean matchDNChain(String var1);

    public final Map getProperties(String locale) {
        Map props = this.getPropertiesSpecific(locale);
        boolean isLocked = this.delegate.isLocked();
        Boolean containerLocked = (Boolean)props.remove(APPLICATION_LOCKED);
        if (containerLocked != null && containerLocked != isLocked) {
            try {
                if (isLocked) {
                    this.lockSpecific();
                } else {
                    this.unlockSpecific();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        props.put(APPLICATION_LOCKED, new Boolean(isLocked));
        return props;
    }

    protected abstract Map getPropertiesSpecific(String var1);

    public final ApplicationHandle launch(Map arguments) throws ApplicationException {
        try {
            this.delegate.launch(arguments);
        }
        catch (SecurityException se) {
            this.isLaunchableSpecific();
            throw se;
        }
        if (!this.isLaunchableSpecific()) {
            throw new ApplicationException(2, "Cannot launch the application!");
        }
        try {
            return this.launchSpecific(arguments);
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (SecurityException se) {
            throw se;
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception t) {
            throw new ApplicationException(3, (Throwable)t);
        }
    }

    protected abstract ApplicationHandle launchSpecific(Map var1) throws Exception;

    protected abstract boolean isLaunchableSpecific();

    public final ScheduledApplication schedule(String scheduleId, Map arguments, String topic, String eventFilter, boolean recurring) throws InvalidSyntaxException, ApplicationException {
        this.isLaunchableSpecific();
        try {
            return this.delegate.schedule(scheduleId, arguments, topic, eventFilter, recurring);
        }
        catch (SecurityException se) {
            this.isLaunchableSpecific();
            throw se;
        }
    }

    public final void lock() {
        try {
            this.delegate.lock();
        }
        catch (SecurityException se) {
            this.isLaunchableSpecific();
            throw se;
        }
        this.lockSpecific();
    }

    protected abstract void lockSpecific();

    public final void unlock() {
        try {
            this.delegate.unlock();
        }
        catch (SecurityException se) {
            this.isLaunchableSpecific();
            throw se;
        }
        this.unlockSpecific();
    }

    protected abstract void unlockSpecific();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Delegate {
        static String cName;
        static Class implementation;
        static Method setApplicationDescriptor;
        static Method isLocked;
        static Method lock;
        static Method unlock;
        static Method schedule;
        static Method launch;
        Object target = AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return implementation.newInstance();
            }
        });

        Delegate() throws Exception {
        }

        void setApplicationDescriptor(ApplicationDescriptor d, String pid) {
            try {
                try {
                    setApplicationDescriptor.invoke(this.target, d, pid);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        boolean isLocked() {
            try {
                try {
                    return (Boolean)isLocked.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        void lock() {
            try {
                try {
                    lock.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        void unlock() {
            try {
                try {
                    unlock.invoke(this.target, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        ScheduledApplication schedule(String scheduleId, Map args, String topic, String filter, boolean recurs) throws InvalidSyntaxException, ApplicationException {
            try {
                try {
                    return (ScheduledApplication)schedule.invoke(this.target, scheduleId, args, topic, filter, new Boolean(recurs));
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (InvalidSyntaxException e) {
                throw e;
            }
            catch (ApplicationException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        void launch(Map arguments) throws ApplicationException {
            try {
                try {
                    launch.invoke(this.target, arguments);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            catch (ApplicationException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        static {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    cName = System.getProperty("org.osgi.vendor.application.ApplicationDescriptor");
                    if (cName == null) {
                        throw new NoClassDefFoundError("org.osgi.vendor.application.ApplicationDescriptor property must be set");
                    }
                    try {
                        implementation = Class.forName(cName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new NoClassDefFoundError(e.toString());
                    }
                    try {
                        setApplicationDescriptor = implementation.getMethod("setApplicationDescriptor", class$org$osgi$service$application$ApplicationDescriptor == null ? (class$org$osgi$service$application$ApplicationDescriptor = ApplicationDescriptor.class$("org.osgi.service.application.ApplicationDescriptor")) : class$org$osgi$service$application$ApplicationDescriptor, class$java$lang$String == null ? (class$java$lang$String = ApplicationDescriptor.class$("java.lang.String")) : class$java$lang$String);
                        isLocked = implementation.getMethod("isLocked", new Class[0]);
                        lock = implementation.getMethod("lock", new Class[0]);
                        unlock = implementation.getMethod("unlock", new Class[0]);
                        schedule = implementation.getMethod("schedule", class$java$lang$String == null ? (class$java$lang$String = ApplicationDescriptor.class$("java.lang.String")) : class$java$lang$String, class$java$util$Map == null ? (class$java$util$Map = ApplicationDescriptor.class$("java.util.Map")) : class$java$util$Map, class$java$lang$String == null ? (class$java$lang$String = ApplicationDescriptor.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ApplicationDescriptor.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE);
                        launch = implementation.getMethod("launch", class$java$util$Map == null ? (class$java$util$Map = ApplicationDescriptor.class$("java.util.Map")) : class$java$util$Map);
                    }
                    catch (NoSuchMethodException e) {
                        throw new NoSuchMethodError(e.toString());
                    }
                    return null;
                }
            });
        }
    }
}

