/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.batch.command.internal;

import jakarta.ws.rs.core.UriInfo;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.batch.command.CommandStrategy;
import org.apache.fineract.batch.command.CommandStrategyUtils;
import org.apache.fineract.batch.domain.BatchRequest;
import org.apache.fineract.batch.domain.BatchResponse;
import org.apache.fineract.infrastructure.core.api.MutableUriInfo;
import org.apache.fineract.portfolio.savings.api.SavingsAccountsApiResource;
import org.springframework.stereotype.Component;

@Component
public class GetSavingsAccountByIdCommandStrategy
implements CommandStrategy {
    private final SavingsAccountsApiResource savingsAccountsApiResource;

    public BatchResponse execute(BatchRequest batchRequest, UriInfo uriInfo) {
        long savingsAccountId;
        MutableUriInfo parameterizedUriInfo = new MutableUriInfo(uriInfo);
        String relativeUrl = CommandStrategyUtils.relativeUrlWithoutVersion((BatchRequest)batchRequest);
        Map queryParameters = new HashMap();
        if (relativeUrl.indexOf(63) > 0) {
            savingsAccountId = Long.parseLong(StringUtils.substringBetween((String)relativeUrl, (String)"/", (String)"?"));
            queryParameters = CommandStrategyUtils.getQueryParameters((String)relativeUrl);
            CommandStrategyUtils.addQueryParametersToUriInfo((MutableUriInfo)parameterizedUriInfo, queryParameters);
        } else {
            savingsAccountId = Long.parseLong(StringUtils.substringAfter((String)relativeUrl, (String)"/"));
        }
        String staffInSelectedOfficeOnly = null;
        String chargeStatus = null;
        if (!queryParameters.isEmpty()) {
            if (queryParameters.containsKey("staffInSelectedOfficeOnly")) {
                staffInSelectedOfficeOnly = (String)queryParameters.get("staffInSelectedOfficeOnly");
            }
            if (queryParameters.containsKey("chargeStatus")) {
                chargeStatus = (String)queryParameters.get("chargeStatus");
            }
        }
        String responseBody = this.savingsAccountsApiResource.retrieveOne(Long.valueOf(savingsAccountId), Boolean.parseBoolean(staffInSelectedOfficeOnly), chargeStatus, uriInfo);
        return new BatchResponse().setRequestId(batchRequest.getRequestId()).setStatusCode(Integer.valueOf(200)).setBody(responseBody).setHeaders(batchRequest.getHeaders());
    }

    @Generated
    public GetSavingsAccountByIdCommandStrategy(SavingsAccountsApiResource savingsAccountsApiResource) {
        this.savingsAccountsApiResource = savingsAccountsApiResource;
    }
}

