/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.apache.fineract.cob.api.LoanCOBCatchUpApiResourceSwagger;
import org.apache.fineract.cob.data.IsCatchUpRunningDTO;
import org.apache.fineract.cob.data.OldestCOBProcessedLoanDTO;
import org.apache.fineract.cob.service.LoanCOBCatchUpService;
import org.apache.fineract.infrastructure.core.exception.JobIsNotFoundOrNotEnabledException;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="/v1/loans")
@Component
@Tag(name="Loan COB Catch Up", description="")
public class LoanCOBCatchUpApiResource {
    @Autowired
    private DefaultToApiJsonSerializer<OldestCOBProcessedLoanDTO> oldestCOBProcessedLoanSerializeService;
    @Autowired
    private DefaultToApiJsonSerializer<IsCatchUpRunningDTO> isCatchUpRunningSerializer;
    @Autowired(required=false)
    private LoanCOBCatchUpService loanCOBCatchUpService;

    @GET
    @Path(value="oldest-cob-closed")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves the oldest COB processed loan", description="Retrieves the COB business date and the oldest COB processed loan")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanCOBCatchUpApiResourceSwagger.GetOldestCOBProcessedLoanResponse.class))})})
    public String getOldestCOBProcessedLoan() {
        if (Objects.isNull(this.loanCOBCatchUpService)) {
            throw new JobIsNotFoundOrNotEnabledException(JobName.LOAN_COB.name());
        }
        OldestCOBProcessedLoanDTO response = this.loanCOBCatchUpService.getOldestCOBProcessedLoan();
        return this.oldestCOBProcessedLoanSerializeService.serialize((Object)response);
    }

    @POST
    @Path(value="catch-up")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Executes Loan COB Catch Up", description="Executes the Loan COB job on every day from the oldest Loan to the current COB business date")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="All loans are up to date"), @ApiResponse(responseCode="202", description="Catch Up has been started"), @ApiResponse(responseCode="400", description="Catch Up is already running")})
    public Response executeLoanCOBCatchUp() {
        if (Objects.isNull(this.loanCOBCatchUpService)) {
            throw new JobIsNotFoundOrNotEnabledException(JobName.LOAN_COB.name());
        }
        if (this.loanCOBCatchUpService.isCatchUpRunning().isCatchUpRunning()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        this.loanCOBCatchUpService.unlockHardLockedLoans();
        OldestCOBProcessedLoanDTO oldestCOBProcessedLoan = this.loanCOBCatchUpService.getOldestCOBProcessedLoan();
        if (oldestCOBProcessedLoan.getCobProcessedDate().equals(oldestCOBProcessedLoan.getCobBusinessDate())) {
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        this.loanCOBCatchUpService.executeLoanCOBCatchUp();
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @GET
    @Path(value="is-catch-up-running")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieves whether Loan COB catch up is running", description="Retrieves whether Loan COB catch up is running, and the current execution date if it is running.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=LoanCOBCatchUpApiResourceSwagger.IsCatchUpRunningResponse.class))})})
    public String isCatchUpRunning() {
        if (Objects.isNull(this.loanCOBCatchUpService)) {
            throw new JobIsNotFoundOrNotEnabledException(JobName.LOAN_COB.name());
        }
        IsCatchUpRunningDTO response = this.loanCOBCatchUpService.isCatchUpRunning();
        return this.isCatchUpRunningSerializer.serialize((Object)response);
    }
}

