/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.listener;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.fineract.cob.listener.FineractCOBAfterJobListener;
import org.apache.fineract.cob.listener.FineractCOBBeforeJobListener;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.context.ApplicationContext;

public class COBExecutionListenerRunner
implements JobExecutionListener {
    private final List<FineractCOBBeforeJobListener> beforeJobListeners = new ArrayList();
    private final List<FineractCOBAfterJobListener> afterJobListeners = new ArrayList();

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    public COBExecutionListenerRunner(ApplicationContext applicationContext, String jobName) {
        this.addBeforeListeners(applicationContext, jobName);
        this.addAfterListeners(applicationContext, jobName);
    }

    public void beforeJob(JobExecution jobExecution) {
        this.beforeJobListeners.forEach(beforeJobListener -> beforeJobListener.beforeJob(jobExecution));
    }

    public void afterJob(JobExecution jobExecution) {
        this.afterJobListeners.forEach(afterJobListener -> afterJobListener.afterJob(jobExecution));
    }

    private void addAfterListeners(ApplicationContext applicationContext, String jobName) {
        List<String> afterListenerClassNames = Arrays.stream(applicationContext.getBeanNamesForType(FineractCOBAfterJobListener.class)).toList();
        for (String afterListenerClassName : afterListenerClassNames) {
            FineractCOBAfterJobListener afterListener = (FineractCOBAfterJobListener)applicationContext.getBean(afterListenerClassName);
            if (!jobName.equals(afterListener.getJobName())) continue;
            this.afterJobListeners.add(afterListener);
        }
    }

    private void addBeforeListeners(ApplicationContext applicationContext, String jobName) {
        List<String> beforeListenerClassNames = Arrays.stream(applicationContext.getBeanNamesForType(FineractCOBBeforeJobListener.class)).toList();
        for (String beforeListenerClassName : beforeListenerClassNames) {
            FineractCOBBeforeJobListener beforeListener = (FineractCOBBeforeJobListener)applicationContext.getBean(beforeListenerClassName);
            if (!jobName.equals(beforeListener.getJobName())) continue;
            this.beforeJobListeners.add(beforeListener);
        }
    }
}

