/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.listener;

import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.item.ExecutionContext;

public class JobExecutionContextCopyListener
implements StepExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JobExecutionContextCopyListener.class);
    private final List<String> stepExecutionKeys;

    public JobExecutionContextCopyListener(List<String> stepExecutionKeys) {
        this.stepExecutionKeys = stepExecutionKeys;
    }

    public void beforeStep(StepExecution stepExecution) {
        log.debug("Before step: copying job execution context to step [{}]", (Object)stepExecution.getStepName());
        ExecutionContext stepExecutionContext = stepExecution.getExecutionContext();
        ExecutionContext jobExecutionContext = stepExecution.getJobExecution().getExecutionContext();
        jobExecutionContext.entrySet().forEach(jobExecutionContextEntry -> {
            if (this.stepExecutionKeys.contains(jobExecutionContextEntry.getKey()) && BooleanUtils.isFalse((Boolean)stepExecutionContext.containsKey((String)jobExecutionContextEntry.getKey()))) {
                stepExecutionContext.put((String)jobExecutionContextEntry.getKey(), jobExecutionContextEntry.getValue());
            }
        });
    }
}

