/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.COBBusinessStep;
import org.apache.fineract.cob.data.BusinessStep;
import org.apache.fineract.cob.data.BusinessStepDetail;
import org.apache.fineract.cob.data.JobBusinessStepConfigData;
import org.apache.fineract.cob.data.JobBusinessStepDetail;
import org.apache.fineract.cob.domain.BatchBusinessStep;
import org.apache.fineract.cob.domain.BatchBusinessStepRepository;
import org.apache.fineract.cob.exceptions.BusinessStepException;
import org.apache.fineract.cob.exceptions.BusinessStepNotBelongsToJobException;
import org.apache.fineract.cob.service.BusinessStepCategory;
import org.apache.fineract.cob.service.BusinessStepCategoryService;
import org.apache.fineract.cob.service.BusinessStepConfigDataParser;
import org.apache.fineract.cob.service.BusinessStepMapper;
import org.apache.fineract.cob.service.ConfigJobParameterService;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class ConfigJobParameterServiceImpl
implements ConfigJobParameterService,
InitializingBean {
    private final BatchBusinessStepRepository batchBusinessStepRepository;
    private final BusinessStepConfigDataParser dataParser;
    private final BusinessStepCategoryService businessStepCategoryService;
    private final ApplicationContext applicationContext;
    private final BusinessStepMapper mapper;
    private JobBusinessStepDetail availableBusinessStepsForLoan;

    public void afterPropertiesSet() throws Exception {
        this.availableBusinessStepsForLoan = this.getAvailableBusinessStepsByJobName(BusinessStepCategory.LOAN.name());
    }

    public JobBusinessStepConfigData getBusinessStepConfigByJobName(String jobName) {
        List batchBusinessSteps = this.batchBusinessStepRepository.findAllByJobName(jobName);
        JobBusinessStepConfigData jobBusinessStepConfigData = new JobBusinessStepConfigData();
        jobBusinessStepConfigData.setJobName(jobName);
        jobBusinessStepConfigData.setBusinessSteps(this.mapper.map(batchBusinessSteps));
        return jobBusinessStepConfigData;
    }

    public CommandProcessingResult updateStepConfigByJobName(JsonCommand command, String jobName) throws BusinessStepNotBelongsToJobException {
        List businessSteps = this.dataParser.parseUpdate(command);
        if (businessSteps.isEmpty()) {
            throw new BusinessStepException("A job needs to have 1 business step at least.");
        }
        List<String> availableBusinessStepNames = this.availableBusinessStepsForLoan.getAvailableBusinessSteps().stream().map(BusinessStepDetail::getStepName).toList();
        List<String> notValidBusinessStepNames = businessSteps.stream().map(BusinessStep::getStepName).filter(businessStepName -> !availableBusinessStepNames.contains(businessStepName)).toList();
        if (!notValidBusinessStepNames.isEmpty()) {
            throw new BusinessStepException(String.valueOf(notValidBusinessStepNames) + " Business steps are not configurable for this job.");
        }
        this.batchBusinessStepRepository.deleteAllByJobName(jobName);
        businessSteps.forEach(newBusinessStepConfig -> {
            BatchBusinessStep batchBusinessStep = new BatchBusinessStep();
            batchBusinessStep.setJobName(jobName);
            batchBusinessStep.setStepName(newBusinessStepConfig.getStepName());
            batchBusinessStep.setStepOrder(newBusinessStepConfig.getOrder());
            this.batchBusinessStepRepository.save((Object)batchBusinessStep);
        });
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).build();
    }

    public JobBusinessStepDetail getAvailableBusinessStepsByJobName(String jobName) {
        Class businessStepClass = this.businessStepCategoryService.getBusinessStepByCategory(jobName);
        if (businessStepClass == null) {
            return null;
        }
        List<String> businessStepBeanNames = Arrays.stream(this.applicationContext.getBeanNamesForType(businessStepClass)).toList();
        JobBusinessStepDetail jobBusinessStepDetail = new JobBusinessStepDetail();
        ArrayList<BusinessStepDetail> availableBusinessSteps = new ArrayList<BusinessStepDetail>();
        for (String businessStepBean : businessStepBeanNames) {
            COBBusinessStep businessStep = (COBBusinessStep)this.applicationContext.getBean(businessStepBean);
            BusinessStepDetail businessStepDetail = new BusinessStepDetail();
            businessStepDetail.setStepName(businessStep.getEnumStyledName());
            businessStepDetail.setStepDescription(businessStep.getHumanReadableName());
            availableBusinessSteps.add(businessStepDetail);
        }
        jobBusinessStepDetail.setJobName(jobName);
        jobBusinessStepDetail.setAvailableBusinessSteps(availableBusinessSteps);
        return jobBusinessStepDetail;
    }

    public List<String> getAllConfiguredJobNames() {
        return this.batchBusinessStepRepository.findConfiguredJobNames();
    }

    @Generated
    public ConfigJobParameterServiceImpl(BatchBusinessStepRepository batchBusinessStepRepository, BusinessStepConfigDataParser dataParser, BusinessStepCategoryService businessStepCategoryService, ApplicationContext applicationContext, BusinessStepMapper mapper) {
        this.batchBusinessStepRepository = batchBusinessStepRepository;
        this.dataParser = dataParser;
        this.businessStepCategoryService = businessStepCategoryService;
        this.applicationContext = applicationContext;
        this.mapper = mapper;
    }
}

