/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.commands.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.commands.api.MakercheckersApiResourceSwagger;
import org.apache.fineract.commands.data.AuditData;
import org.apache.fineract.commands.data.AuditSearchData;
import org.apache.fineract.commands.service.AuditReadPlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.service.SqlValidator;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.springframework.stereotype.Component;

@Path(value="/v1/audits")
@Component
@Tag(name="Audits", description="Every non-read Mifos API request is audited. A fully processed request can not be changed or deleted. See maker checker api for situations where an audit is not fully processed.\n\nPermissions: To search and look at audit entries a user needs to be attached to a role that has one of the ALL_FUNCTIONS, ALL_FUNCTIONS_READ or READ_AUDIT permissions.\n\nData Scope: A user can only see audits that are within their data scope. However, 'head office' users can see all audits including those that aren't office/branch related e.g. Loan Product changes.\")")
public class AuditsApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "actionName", "entityName", "resourceId", "subresourceId", "maker", "madeOnDate", "checker", "checkedOnDate", "processingResult", "commandAsJson", "officeName", "groupLevelName", "groupName", "clientName", "loanAccountNo", "savingsAccountNo", "clientId", "loanId", "url"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "AUDIT";
    private final PlatformSecurityContext context;
    private final AuditReadPlatformService auditReadPlatformService;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final DefaultToApiJsonSerializer<AuditData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<AuditSearchData> toApiJsonSerializerSearchTemplate;
    private final SqlValidator sqlValidator;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Audits", description="Get a 200 list of audits that match the criteria supplied and sorted by audit id in descending order, and are within the requestors' data scope. Also it supports pagination and sorting\n\nExample Requests:\n\naudits\n\naudits?fields=madeOnDate,maker,processingResult\n\naudits?makerDateTimeFrom=2013-03-25 08:00:00&makerDateTimeTo=2013-04-04 18:00:00\n\naudits?officeId=1\n\naudits?officeId=1&includeJson=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=MakercheckersApiResourceSwagger.GetMakerCheckerResponse.class)))})})
    public String retrieveAuditEntries(@Context UriInfo uriInfo, @QueryParam(value="actionName") @Parameter(description="actionName") String actionName, @QueryParam(value="entityName") @Parameter(description="entityName") String entityName, @QueryParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @QueryParam(value="makerId") @Parameter(description="makerId") Long makerId, @QueryParam(value="makerDateTimeFrom") @Parameter(description="makerDateTimeFrom") String makerDateTimeFrom, @QueryParam(value="makerDateTimeTo") @Parameter(description="makerDateTimeTo") String makerDateTimeTo, @QueryParam(value="checkerId") @Parameter(description="checkerId") Long checkerId, @QueryParam(value="checkerDateTimeFrom") @Parameter(description="checkerDateTimeFrom") String checkerDateTimeFrom, @QueryParam(value="checkerDateTimeTo") @Parameter(description="checkerDateTimeTo") String checkerDateTimeTo, @QueryParam(value="processingResult") @Parameter(description="processingResult") Integer processingResult, @QueryParam(value="officeId") @Parameter(description="officeId") Integer officeId, @QueryParam(value="groupId") @Parameter(description="groupId") Integer groupId, @QueryParam(value="clientId") @Parameter(description="clientId") Integer clientId, @QueryParam(value="loanid") @Parameter(description="loanid") Integer loanId, @QueryParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Integer savingsAccountId, @QueryParam(value="paged") @Parameter(description="paged") Boolean paged, @QueryParam(value="offset") @Parameter(description="offset") Integer offset, @QueryParam(value="limit") @Parameter(description="limit") Integer limit, @QueryParam(value="orderBy") @Parameter(description="orderBy") String orderBy, @QueryParam(value="sortOrder") @Parameter(description="sortOrder") String sortOrder) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        this.sqlValidator.validate(orderBy);
        this.sqlValidator.validate(sortOrder);
        PaginationParameters parameters = PaginationParameters.builder().paged(Boolean.TRUE.equals(paged)).limit(limit).offset(offset).orderBy(orderBy).sortOrder(sortOrder).build();
        SQLBuilder extraCriteria = this.getExtraCriteria(actionName, entityName, resourceId, makerId, makerDateTimeFrom, makerDateTimeTo, checkerId, checkerDateTimeFrom, checkerDateTimeTo, processingResult, officeId, groupId, clientId, loanId, savingsAccountId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        if (parameters.isPaged()) {
            Page auditEntries = this.auditReadPlatformService.retrievePaginatedAuditEntries(extraCriteria, settings.isIncludeJson(), parameters);
            return this.toApiJsonSerializer.serialize(settings, auditEntries, RESPONSE_DATA_PARAMETERS);
        }
        Collection auditEntries = this.auditReadPlatformService.retrieveAuditEntries(extraCriteria, settings.isIncludeJson());
        return this.toApiJsonSerializer.serialize(settings, auditEntries, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="{auditId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve an Audit Entry", description="Example Requests:\n\naudits/20\naudits/20?fields=madeOnDate,maker,processingResult")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.GetMakerCheckerResponse.class))})})
    public String retrieveAuditEntry(@PathParam(value="auditId") @Parameter(description="auditId") Long auditId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        AuditData auditEntry = this.auditReadPlatformService.retrieveAuditEntry(auditId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, (Object)auditEntry, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/searchtemplate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Audit Search Template", description="This is a convenience resource. It can be useful when building an Audit Search UI. \"appUsers\" are data scoped to the office/branch the requestor is associated with.\n\nExample Requests:\n\naudits/searchtemplate\naudits/searchtemplate?fields=actionNames")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.GetMakerCheckersSearchTemplateResponse.class))})})
    public String retrieveAuditSearchTemplate(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        AuditSearchData auditSearchData = this.auditReadPlatformService.retrieveSearchTemplate("audit");
        HashSet<String> RESPONSE_DATA_PARAMETERS_SEARCH_TEMPLATE = new HashSet<String>(Arrays.asList("appUsers", "actionNames", "entityNames", "status"));
        return this.toApiJsonSerializerSearchTemplate.serialize(settings, (Object)auditSearchData, RESPONSE_DATA_PARAMETERS_SEARCH_TEMPLATE);
    }

    private SQLBuilder getExtraCriteria(String actionName, String entityName, Long resourceId, Long makerId, String makerDateTimeFrom, String makerDateTimeTo, Long checkerId, String checkerDateTimeFrom, String checkerDateTimeTo, Integer status, Integer officeId, Integer groupId, Integer clientId, Integer loanId, Integer savingsAccountId) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addNonNullCriteria("aud.action_name = ", (Object)actionName);
        if (entityName != null) {
            extraCriteria.addCriteria("aud.entity_name like", (Object)(entityName + "%"));
        }
        extraCriteria.addNonNullCriteria("aud.resource_id = ", (Object)resourceId);
        extraCriteria.addNonNullCriteria("aud.maker_id = ", (Object)makerId);
        extraCriteria.addNonNullCriteria("aud.checker_id = ", (Object)checkerId);
        extraCriteria.addNonNullCriteria("aud.made_on_date >= ", (Object)makerDateTimeFrom);
        extraCriteria.addNonNullCriteria("aud.made_on_date <= ", (Object)makerDateTimeTo);
        extraCriteria.addNonNullCriteria("aud.checked_on_date >= ", (Object)checkerDateTimeFrom);
        extraCriteria.addNonNullCriteria("aud.checked_on_date <= ", (Object)checkerDateTimeTo);
        extraCriteria.addNonNullCriteria("aud.status = ", (Object)status);
        extraCriteria.addNonNullCriteria("aud.office_id = ", (Object)officeId);
        extraCriteria.addNonNullCriteria("aud.group_id = ", (Object)groupId);
        extraCriteria.addNonNullCriteria("aud.client_id = ", (Object)clientId);
        extraCriteria.addNonNullCriteria("aud.loan_id = ", (Object)loanId);
        extraCriteria.addNonNullCriteria("aud.savings_account_id = ", (Object)savingsAccountId);
        return extraCriteria;
    }

    @Generated
    public AuditsApiResource(PlatformSecurityContext context, AuditReadPlatformService auditReadPlatformService, ApiRequestParameterHelper apiRequestParameterHelper, DefaultToApiJsonSerializer<AuditData> toApiJsonSerializer, DefaultToApiJsonSerializer<AuditSearchData> toApiJsonSerializerSearchTemplate, SqlValidator sqlValidator) {
        this.context = context;
        this.auditReadPlatformService = auditReadPlatformService;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.toApiJsonSerializerSearchTemplate = toApiJsonSerializerSearchTemplate;
        this.sqlValidator = sqlValidator;
    }
}

