/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.commands.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.api.MakercheckersApiResourceSwagger;
import org.apache.fineract.commands.data.AuditData;
import org.apache.fineract.commands.data.AuditSearchData;
import org.apache.fineract.commands.service.AuditReadPlatformService;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.exception.UnrecognizedQueryParamException;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.springframework.stereotype.Component;

@Path(value="/v1/makercheckers")
@Component
@Tag(name="Maker Checker (or 4-eye) functionality")
public class MakercheckersApiResource {
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "actionName", "entityName", "resourceId", "subresourceId", "maker", "madeOnDate", "checker", "checkedOnDate", "processingResult", "commandAsJson", "officeName", "groupLevelName", "groupName", "clientName", "loanAccountNo", "savingsAccountNo", "clientId", "loanId"));
    private final AuditReadPlatformService readPlatformService;
    private final DefaultToApiJsonSerializer<AuditData> toApiJsonSerializerAudit;
    private final DefaultToApiJsonSerializer<AuditSearchData> toApiJsonSerializerSearchTemplate;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService writePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Maker Checker Entries", description="Get a list of entries that can be checked by the requestor that match the criteria supplied.\n\nExample Requests:\n\nmakercheckers\n\nmakercheckers?fields=madeOnDate,maker,processingResult\n\nmakercheckers?makerDateTimeFrom=2013-03-25 08:00:00&makerDateTimeTo=2013-04-04 18:00:00\n\nmakercheckers?officeId=1\n\nmakercheckers?officeId=1&includeJson=true")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=MakercheckersApiResourceSwagger.GetMakerCheckerResponse.class)))})})
    public String retrieveCommands(@Context UriInfo uriInfo, @QueryParam(value="actionName") @Parameter(description="actionName") String actionName, @QueryParam(value="entityName") @Parameter(description="entityName") String entityName, @QueryParam(value="resourceId") @Parameter(description="resourceId") Long resourceId, @QueryParam(value="makerId") @Parameter(description="makerId") Long makerId, @QueryParam(value="makerDateTimeFrom") @Parameter(description="makerDateTimeFrom") String makerDateTimeFrom, @QueryParam(value="makerDateTimeTo") @Parameter(description="makerDateTimeTo") String makerDateTimeTo, @QueryParam(value="officeId") @Parameter(description="officeId") Integer officeId, @QueryParam(value="groupId") @Parameter(description="groupId") Integer groupId, @QueryParam(value="clientId") @Parameter(description="clientId") Integer clientId, @QueryParam(value="loanid") @Parameter(description="loanid") Integer loanId, @QueryParam(value="savingsAccountId") @Parameter(description="savingsAccountId") Integer savingsAccountId) {
        SQLBuilder extraCriteria = this.getExtraCriteria(actionName, entityName, resourceId, makerId, makerDateTimeFrom, makerDateTimeTo, officeId, groupId, clientId, loanId, savingsAccountId);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        Collection entries = this.readPlatformService.retrieveAllEntriesToBeChecked(extraCriteria, settings.isIncludeJson());
        return this.toApiJsonSerializerAudit.serialize(settings, entries, RESPONSE_DATA_PARAMETERS);
    }

    @GET
    @Path(value="/searchtemplate")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Maker Checker Search Template", description="This is a convenience resource. It can be useful when building a Checker Inbox UI. \"appUsers\" are data scoped to the office/branch the requestor is associated with. \"actionNames\" and \"entityNames\" returned are those that the requestor has Checker approval permissions for.\n\nExample Requests:\n\nmakercheckers/searchtemplate\nmakercheckers/searchtemplate?fields=entityNames")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.GetMakerCheckersSearchTemplateResponse.class))})})
    public String retrieveAuditSearchTemplate(@Context UriInfo uriInfo) {
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        AuditSearchData auditSearchData = this.readPlatformService.retrieveSearchTemplate("makerchecker");
        HashSet<String> RESPONSE_DATA_PARAMETERS_SEARCH_TEMPLATE = new HashSet<String>(Arrays.asList("appUsers", "actionNames", "entityNames"));
        return this.toApiJsonSerializerSearchTemplate.serialize(settings, (Object)auditSearchData, RESPONSE_DATA_PARAMETERS_SEARCH_TEMPLATE);
    }

    @POST
    @Path(value="{auditId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Approve Maker Checker Entry | Reject Maker Checker Entry")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.PostMakerCheckersResponse.class))})})
    public String approveMakerCheckerEntry(@PathParam(value="auditId") @Parameter(description="auditId") Long auditId, @QueryParam(value="command") @Parameter(description="command") String commandParam) {
        CommandProcessingResult result = null;
        if (this.is(commandParam, "approve")) {
            result = this.writePlatformService.approveEntry(auditId);
        } else if (this.is(commandParam, "reject")) {
            Long id = this.writePlatformService.rejectEntry(auditId);
            result = CommandProcessingResult.commandOnlyResult((Long)id);
        } else {
            throw new UnrecognizedQueryParamException("command", commandParam, new Object[0]);
        }
        return this.toApiJsonSerializerAudit.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @DELETE
    @Path(value="{auditId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete Maker Checker Entry")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=MakercheckersApiResourceSwagger.PostMakerCheckersResponse.class))})})
    public String deleteMakerCheckerEntry(@PathParam(value="auditId") @Parameter(description="auditId") Long auditId) {
        Long id = this.writePlatformService.deleteEntry(auditId);
        return this.toApiJsonSerializerAudit.serialize((Object)CommandProcessingResult.commandOnlyResult((Long)id));
    }

    private SQLBuilder getExtraCriteria(String actionName, String entityName, Long resourceId, Long makerId, String makerDateTimeFrom, String makerDateTimeTo, Integer officeId, Integer groupId, Integer clientId, Integer loanId, Integer savingsAccountId) {
        SQLBuilder extraCriteria = new SQLBuilder();
        extraCriteria.addNonNullCriteria("aud.action_name = ", (Object)actionName);
        if (entityName != null) {
            extraCriteria.addCriteria("aud.entity_name like ", (Object)(entityName + "%"));
        }
        extraCriteria.addNonNullCriteria("aud.resource_id = ", (Object)resourceId);
        extraCriteria.addNonNullCriteria("aud.maker_id = ", (Object)makerId);
        extraCriteria.addNonNullCriteria("aud.made_on_date >= ", (Object)makerDateTimeFrom);
        extraCriteria.addNonNullCriteria("aud.made_on_date <= ", (Object)makerDateTimeTo);
        extraCriteria.addNonNullCriteria("aud.office_id = ", (Object)officeId);
        extraCriteria.addNonNullCriteria("aud.group_id = ", (Object)groupId);
        extraCriteria.addNonNullCriteria("aud.client_id = ", (Object)clientId);
        extraCriteria.addNonNullCriteria("aud.loan_id = ", (Object)loanId);
        extraCriteria.addNonNullCriteria("aud.savings_account_id = ", (Object)savingsAccountId);
        return extraCriteria;
    }

    @Generated
    public MakercheckersApiResource(AuditReadPlatformService readPlatformService, DefaultToApiJsonSerializer<AuditData> toApiJsonSerializerAudit, DefaultToApiJsonSerializer<AuditSearchData> toApiJsonSerializerSearchTemplate, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService writePlatformService) {
        this.readPlatformService = readPlatformService;
        this.toApiJsonSerializerAudit = toApiJsonSerializerAudit;
        this.toApiJsonSerializerSearchTemplate = toApiJsonSerializerSearchTemplate;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.writePlatformService = writePlatformService;
    }
}

