/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.commands.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.data.AuditData;
import org.apache.fineract.commands.data.AuditSearchData;
import org.apache.fineract.commands.service.AuditReadPlatformService;
import org.apache.fineract.commands.service.AuditReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.core.data.PaginationParameters;
import org.apache.fineract.infrastructure.core.data.PaginationParametersDataValidator;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.Page;
import org.apache.fineract.infrastructure.core.service.PaginationHelper;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.infrastructure.security.utils.ColumnValidator;
import org.apache.fineract.infrastructure.security.utils.SQLBuilder;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.organisation.office.service.OfficeReadPlatformService;
import org.apache.fineract.organisation.staff.data.StaffData;
import org.apache.fineract.organisation.staff.service.StaffReadPlatformService;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.client.service.ClientReadPlatformService;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.service.LoanEnumerations;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.apache.fineract.portfolio.savings.DepositAccountType;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.fineract.portfolio.savings.service.DepositProductReadPlatformService;
import org.apache.fineract.portfolio.savings.service.SavingsEnumerations;
import org.apache.fineract.portfolio.savings.service.SavingsProductReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.apache.fineract.useradministration.service.AppUserReadPlatformService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class AuditReadPlatformServiceImpl
implements AuditReadPlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AuditReadPlatformServiceImpl.class);
    private static final Set<String> supportedOrderByValues = new HashSet<String>(Arrays.asList("id", "actionName", "entityName", "resourceId", "subresourceId", "madeOnDate", "checkedOnDate", "officeName", "groupName", "clientName", "loanAccountNo", "savingsAccountNo", "clientId", "loanId", "maker", "checker", "processingResult"));
    private final JdbcTemplate jdbcTemplate;
    private final PlatformSecurityContext context;
    private final FromJsonHelper fromApiJsonHelper;
    private final AppUserReadPlatformService appUserReadPlatformService;
    private final OfficeReadPlatformService officeReadPlatformService;
    private final ClientReadPlatformService clientReadPlatformService;
    private final LoanProductReadPlatformService loanProductReadPlatformService;
    private final StaffReadPlatformService staffReadPlatformService;
    private final PaginationHelper paginationHelper;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final PaginationParametersDataValidator paginationParametersDataValidator;
    private final SavingsProductReadPlatformService savingsProductReadPlatformService;
    private final DepositProductReadPlatformService depositProductReadPlatformService;
    private final ColumnValidator columnValidator;

    public Collection<AuditData> retrieveAuditEntries(SQLBuilder extraCriteria, boolean includeJson) {
        return this.retrieveEntries("audit", extraCriteria, " order by aud.id DESC limit 200", includeJson);
    }

    public Page<AuditData> retrievePaginatedAuditEntries(SQLBuilder extraCriteria, boolean includeJson, PaginationParameters parameters) {
        this.paginationParametersDataValidator.validateParameterValues(parameters, supportedOrderByValues, "audits");
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        AuditMapper rm = new AuditMapper();
        StringBuilder sqlBuilder = new StringBuilder(200);
        sqlBuilder.append("select " + this.sqlGenerator.calcFoundRows() + " ");
        sqlBuilder.append(rm.schema(includeJson, hierarchy));
        sqlBuilder.append(' ').append(extraCriteria.getSQLTemplate());
        if (parameters.hasOrderBy()) {
            sqlBuilder.append(' ').append(parameters.orderBySql());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{parameters.orderBySql()});
        } else {
            sqlBuilder.append(' ').append(' ').append(" order by aud.id DESC");
        }
        if (parameters.hasLimit()) {
            sqlBuilder.append(' ').append(parameters.limitSql());
            this.columnValidator.validateSqlInjection(sqlBuilder.toString(), new String[]{parameters.limitSql()});
        }
        log.debug("sql: {}", (Object)sqlBuilder);
        return this.paginationHelper.fetchPage(this.jdbcTemplate, sqlBuilder.toString(), extraCriteria.getArguments(), (RowMapper)rm);
    }

    public Collection<AuditData> retrieveAllEntriesToBeChecked(SQLBuilder extraCriteria, boolean includeJson) {
        extraCriteria.addCriteria("aud.status = ", (Object)2);
        return this.retrieveEntries("makerchecker", extraCriteria, " order by aud.id, mk.username", includeJson);
    }

    private Collection<AuditData> retrieveEntries(String useType, SQLBuilder extraCriteria, String groupAndOrderBySQL, boolean includeJson) {
        if (!useType.equals("audit") && !useType.equals("makerchecker")) {
            throw new PlatformDataIntegrityException("error.msg.invalid.auditSearchTemplate.useType", "Invalid Audit Search Template UseType: " + useType, new Object[0]);
        }
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        AuditMapper rm = new AuditMapper();
        String sql = "select " + rm.schema(includeJson, hierarchy);
        Boolean isLimitedChecker = false;
        if (useType.equals("makerchecker") && currentUser.hasNotPermissionForAnyOf(new String[]{"ALL_FUNCTIONS", "CHECKER_SUPER_USER"})) {
            isLimitedChecker = true;
        }
        if (isLimitedChecker.booleanValue()) {
            sql = sql + " join m_permission p on REPLACE(p.action_name, '_CHECKER', '')  = aud.action_name and p.entity_name = aud.entity_name and p.code like '%\\_CHECKER' join m_role_permission rp on rp.permission_id = p.id join m_role r on r.id = rp.role_id  join m_appuser_role ur on ur.role_id = r.id and ur.appuser_id = " + String.valueOf(currentUser.getId());
        }
        sql = sql + extraCriteria.getSQLTemplate();
        sql = sql + groupAndOrderBySQL;
        log.debug("sql: {}", (Object)sql);
        return this.jdbcTemplate.query(sql, (RowMapper)rm, extraCriteria.getArguments());
    }

    public AuditData retrieveAuditEntry(Long auditId) {
        AppUser currentUser = this.context.authenticatedUser();
        String hierarchy = currentUser.getOffice().getHierarchy();
        AuditMapper rm = new AuditMapper();
        String sql = "select " + rm.schema(true, hierarchy) + " where aud.id = ? ";
        AuditData auditResult = (AuditData)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, new Object[]{auditId});
        return this.replaceIdsOnAuditData(auditResult);
    }

    private AuditData replaceIdsOnAuditData(AuditData auditResult) {
        String auditAsJson = auditResult.getCommandAsJson();
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        Map commandAsJsonMap = this.fromApiJsonHelper.extractObjectMap(typeOfMap, auditAsJson);
        JsonElement auditJsonFragment = this.fromApiJsonHelper.parse(auditAsJson);
        JsonObject auditObject = auditJsonFragment.getAsJsonObject();
        if (commandAsJsonMap.containsKey("officeId")) {
            commandAsJsonMap.remove("officeId");
            Long officeId = null;
            String officeIdStr = auditObject.get("officeId").getAsString();
            if (StringUtils.isNotBlank((CharSequence)officeIdStr)) {
                officeId = Long.valueOf(officeIdStr);
                OfficeData office = this.officeReadPlatformService.retrieveOffice(officeId);
                commandAsJsonMap.put("officeName", office.getName());
            } else {
                commandAsJsonMap.put("officeName", "");
            }
        }
        if (commandAsJsonMap.containsKey("clientId")) {
            commandAsJsonMap.remove("clientId");
            Long clientId = null;
            String clientIdStr = auditObject.get("clientId").getAsString();
            if (StringUtils.isNotBlank((CharSequence)clientIdStr)) {
                clientId = Long.valueOf(clientIdStr);
                ClientData client = this.clientReadPlatformService.retrieveOne(clientId);
                commandAsJsonMap.put("clientName", client.getDisplayName());
            } else {
                commandAsJsonMap.put("clientName", "");
            }
        }
        if (commandAsJsonMap.containsKey("productId")) {
            commandAsJsonMap.remove("productId");
            Long productId = null;
            String productIdStr = auditObject.get("productId").getAsString();
            if (StringUtils.isNotBlank((CharSequence)productIdStr)) {
                productId = Long.valueOf(productIdStr);
                if (auditResult.getEntityName().equalsIgnoreCase("LOAN")) {
                    LoanProductData loanProduct = this.loanProductReadPlatformService.retrieveLoanProduct(productId);
                    commandAsJsonMap.put("productName", loanProduct.getName());
                } else if (auditResult.getEntityName().equalsIgnoreCase("SAVINGSACCOUNT")) {
                    SavingsProductData savingProduct = this.savingsProductReadPlatformService.retrieveOne(productId);
                    commandAsJsonMap.put("productName", savingProduct.getName());
                } else if (auditResult.getEntityName().equalsIgnoreCase("RECURRINGDEPOSITACCOUNT")) {
                    depositProduct = this.depositProductReadPlatformService.retrieveOne(DepositAccountType.RECURRING_DEPOSIT, productId);
                    commandAsJsonMap.put("productName", depositProduct.getName());
                } else if (auditResult.getEntityName().equalsIgnoreCase("FIXEDDEPOSITACCOUNT")) {
                    depositProduct = this.depositProductReadPlatformService.retrieveOne(DepositAccountType.FIXED_DEPOSIT, productId);
                    commandAsJsonMap.put("productName", depositProduct.getName());
                } else {
                    commandAsJsonMap.put("productName", "");
                }
            } else {
                commandAsJsonMap.put("productName", "");
            }
        }
        if (commandAsJsonMap.containsKey("loanOfficerId") || commandAsJsonMap.containsKey("fieldOfficerId") || commandAsJsonMap.containsKey("staffId")) {
            String staffIdStr = "";
            String staffNameParamName = "";
            if (commandAsJsonMap.containsKey("loanOfficerId")) {
                commandAsJsonMap.remove("loanOfficerId");
                staffIdStr = auditObject.get("loanOfficerId").getAsString();
                staffNameParamName = "loanOfficerName";
            } else if (commandAsJsonMap.containsKey("fieldOfficerId")) {
                commandAsJsonMap.remove("fieldOfficerId");
                staffIdStr = auditObject.get("fieldOfficerId").getAsString();
                staffNameParamName = "fieldOfficerName";
            } else if (commandAsJsonMap.containsKey("staffId")) {
                commandAsJsonMap.remove("staffId");
                staffIdStr = auditObject.get("staffId").getAsString();
                staffNameParamName = "staffName";
            }
            this.replaceStaffIdWithStaffName(staffIdStr, staffNameParamName, commandAsJsonMap);
        }
        this.updateEnumerations(commandAsJsonMap, auditObject, auditResult.getEntityName());
        String newAuditAsJson = this.fromApiJsonHelper.toJson((Object)commandAsJsonMap);
        auditResult.setCommandAsJson(newAuditAsJson);
        return auditResult;
    }

    private void updateEnumerations(Map<String, Object> commandAsJsonMap, JsonObject auditObject, String entityName) {
        block3: {
            String[] enumTypes;
            block2: {
                String[] enumTypes2;
                if (!entityName.equalsIgnoreCase("LOAN") && !entityName.equalsIgnoreCase("LOANPRODUCT")) break block2;
                for (String typeName : enumTypes2 = new String[]{"loanTermFrequencyType", "termFrequencyType", "repaymentFrequencyType", "amortizationType", "interestType", "interestCalculationPeriodType", "interestRateFrequencyType", "accountingRule"}) {
                    if (!commandAsJsonMap.containsKey(typeName)) continue;
                    commandAsJsonMap.remove(typeName);
                    Integer enumTypeId = auditObject.get(typeName).getAsInt();
                    String code = LoanEnumerations.loanEnumeration((String)typeName, (int)enumTypeId).getValue();
                    if (code == null) continue;
                    commandAsJsonMap.put(typeName, code);
                }
                break block3;
            }
            if (!entityName.equalsIgnoreCase("SAVINGSPRODUCT") && !entityName.equalsIgnoreCase("SAVINGSACCOUNT") && !entityName.equalsIgnoreCase("RECURRINGDEPOSITPRODUCT") && !entityName.equalsIgnoreCase("RECURRINGDEPOSITACCOUNT") && !entityName.equalsIgnoreCase("FIXEDDEPOSITPRODUCT") && !entityName.equalsIgnoreCase("FIXEDDEPOSITACCOUNT")) break block3;
            for (String typeName : enumTypes = new String[]{"interestCompoundingPeriodType", "interestPostingPeriodType", "interestCalculationType", "lockinPeriodFrequencyType", "minDepositTermTypeId", "maxDepositTermTypeId", "inMultiplesOfDepositTermTypeId", "depositPeriodFrequencyId", "accountingRule", "interestCalculationDaysInYearType", "preClosurePenalInterestOnTypeId", "recurringFrequencyType"}) {
                if (!commandAsJsonMap.containsKey(typeName)) continue;
                commandAsJsonMap.remove(typeName);
                Integer enumTypeId = auditObject.get(typeName).getAsInt();
                String code = SavingsEnumerations.savingEnumueration((String)typeName, (int)enumTypeId).getValue();
                if (code == null) continue;
                commandAsJsonMap.put(typeName, code);
            }
        }
    }

    private void replaceStaffIdWithStaffName(String staffIdStr, String staffNameParamName, Map<String, Object> commandAsJsonMap) {
        Long staffId = null;
        if (StringUtils.isNotBlank((CharSequence)staffIdStr)) {
            staffId = Long.valueOf(staffIdStr);
            StaffData officer = this.staffReadPlatformService.retrieveStaff(staffId);
            commandAsJsonMap.put(staffNameParamName, officer.getDisplayName());
        } else {
            commandAsJsonMap.put(staffNameParamName, "");
        }
    }

    public AuditSearchData retrieveSearchTemplate(String useType) {
        if (!useType.equals("audit") && !useType.equals("makerchecker")) {
            throw new PlatformDataIntegrityException("error.msg.invalid.auditSearchTemplate.useType", "Invalid Audit Search Template UseType: " + useType, new Object[0]);
        }
        AppUser currentUser = this.context.authenticatedUser();
        Collection appUsers = this.appUserReadPlatformService.retrieveSearchTemplate();
        Object sql = " SELECT distinct(action_name) as actionName, CASE WHEN action_name in ('CREATE', 'DELETE', 'UPDATE') THEN action_name ELSE 'ZZZ' END as classifier  FROM m_permission p ";
        sql = (String)sql + this.makercheckerCapabilityOnly(useType, currentUser);
        sql = (String)sql + " order by classifier, action_name";
        ActionNamesMapper mapper = new ActionNamesMapper();
        List actionNames = this.jdbcTemplate.query((String)sql, (RowMapper)mapper);
        sql = " select distinct(entity_name) as entityName, CASE WHEN " + this.sqlGenerator.escape("grouping") + " = 'datatable' THEN 'ZZZ' ELSE entity_name END as classifier  from m_permission p ";
        sql = (String)sql + this.makercheckerCapabilityOnly(useType, currentUser);
        sql = (String)sql + " order by classifier, entity_name";
        EntityNamesMapper mapper2 = new EntityNamesMapper();
        List entityNames = this.jdbcTemplate.query((String)sql, (RowMapper)mapper2);
        List processingResults = null;
        if (useType.equals("audit")) {
            ProcessingResultsMapper mapper3 = new ProcessingResultsMapper();
            processingResults = this.jdbcTemplate.query(mapper3.schema(), (RowMapper)mapper3);
        }
        return new AuditSearchData(appUsers, actionNames, entityNames, processingResults);
    }

    private String makercheckerCapabilityOnly(String useType, AppUser currentUser) {
        Object sql = "";
        Boolean isLimitedChecker = false;
        if (useType.equals("makerchecker") && currentUser.hasNotPermissionForAnyOf(new String[]{"ALL_FUNCTIONS", "CHECKER_SUPER_USER"})) {
            isLimitedChecker = true;
        }
        if (isLimitedChecker.booleanValue()) {
            sql = (String)sql + " join m_role_permission rp on rp.permission_id = p.id join m_role r on r.id = rp.role_id  join m_appuser_role ur on ur.role_id = r.id and ur.appuser_id = " + String.valueOf(currentUser.getId());
        }
        sql = (String)sql + " where p.action_name is not null and p.action_name <> 'READ' ";
        if (isLimitedChecker.booleanValue()) {
            sql = (String)sql + "and p.code like '%\\_CHECKER'";
        }
        return sql;
    }

    @Generated
    public AuditReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, PlatformSecurityContext context, FromJsonHelper fromApiJsonHelper, AppUserReadPlatformService appUserReadPlatformService, OfficeReadPlatformService officeReadPlatformService, ClientReadPlatformService clientReadPlatformService, LoanProductReadPlatformService loanProductReadPlatformService, StaffReadPlatformService staffReadPlatformService, PaginationHelper paginationHelper, DatabaseSpecificSQLGenerator sqlGenerator, PaginationParametersDataValidator paginationParametersDataValidator, SavingsProductReadPlatformService savingsProductReadPlatformService, DepositProductReadPlatformService depositProductReadPlatformService, ColumnValidator columnValidator) {
        this.jdbcTemplate = jdbcTemplate;
        this.context = context;
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.appUserReadPlatformService = appUserReadPlatformService;
        this.officeReadPlatformService = officeReadPlatformService;
        this.clientReadPlatformService = clientReadPlatformService;
        this.loanProductReadPlatformService = loanProductReadPlatformService;
        this.staffReadPlatformService = staffReadPlatformService;
        this.paginationHelper = paginationHelper;
        this.sqlGenerator = sqlGenerator;
        this.paginationParametersDataValidator = paginationParametersDataValidator;
        this.savingsProductReadPlatformService = savingsProductReadPlatformService;
        this.depositProductReadPlatformService = depositProductReadPlatformService;
        this.columnValidator = columnValidator;
    }
}

