/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.group;

import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.IdempotencyKeyGenerator;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.ClientIdSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.EnumOptionDataValueSerializer;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.EnumOptionData;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.portfolio.calendar.data.CalendarData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GroupImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(GroupImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final IdempotencyKeyGenerator idempotencyKeyGenerator;

    @Autowired
    public GroupImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, IdempotencyKeyGenerator idempotencyKeyGenerator) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.idempotencyKeyGenerator = idempotencyKeyGenerator;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        ArrayList groups = new ArrayList();
        ArrayList meetings = new ArrayList();
        ArrayList statuses = new ArrayList();
        this.readExcelFile(workbook, groups, meetings, statuses, locale, dateFormat);
        return this.importEntity(workbook, groups, meetings, statuses, dateFormat);
    }

    private void readExcelFile(Workbook workbook, List<GroupGeneralData> groups, List<CalendarData> meetings, List<String> statuses, String locale, String dateFormat) {
        Sheet groupsSheet = workbook.getSheet("Groups");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)groupsSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = groupsSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)13)) continue;
            groups.add(this.readGroup(workbook, row, statuses, locale, dateFormat));
            meetings.add(this.readMeeting(row, locale, dateFormat));
        }
    }

    private CalendarData readMeeting(Row row, String locale, String dateFormat) {
        LocalDate meetingStartDate = ImportHandlerUtils.readAsDate((int)8, (Row)row);
        Boolean isRepeating = ImportHandlerUtils.readAsBoolean((int)9, (Row)row);
        String frequency = ImportHandlerUtils.readAsString((int)10, (Row)row);
        EnumOptionData frequencyEnum = new EnumOptionData(null, null, ImportHandlerUtils.getFrequencyId((String)frequency));
        Integer interval = ImportHandlerUtils.readAsInt((int)11, (Row)row);
        String repeatsOnDay = ImportHandlerUtils.readAsString((int)12, (Row)row);
        EnumOptionData repeatsOnDayEnum = new EnumOptionData(null, null, ImportHandlerUtils.getRepeatsOnDayId((String)repeatsOnDay));
        if (meetingStartDate == null) {
            return null;
        }
        if (repeatsOnDay == null) {
            return CalendarData.importInstanceNoRepeatsOnDay((LocalDate)meetingStartDate, (boolean)isRepeating, (EnumOptionData)frequencyEnum, (Integer)interval, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
        }
        return CalendarData.importInstanceWithRepeatsOnDay((LocalDate)meetingStartDate, (boolean)isRepeating, (EnumOptionData)frequencyEnum, (Integer)interval, (EnumOptionData)repeatsOnDayEnum, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private GroupGeneralData readGroup(Workbook workbook, Row row, List<String> statuses, String locale, String dateFormat) {
        String clientName;
        String status = ImportHandlerUtils.readAsString((int)13, (Row)row);
        String officeName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        String staffName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        Long staffId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)staffName);
        String centerName = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Long centerId = null;
        if (centerName != null) {
            centerId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Centers"), (String)centerName);
        }
        String externalId = ImportHandlerUtils.readAsString((int)4, (Row)row);
        Boolean active = ImportHandlerUtils.readAsBoolean((int)5, (Row)row);
        LocalDate submittedOnDate = ImportHandlerUtils.readAsDate((int)7, (Row)row);
        LocalDate activationDate = null;
        activationDate = active != false ? ImportHandlerUtils.readAsDate((int)6, (Row)row) : submittedOnDate;
        String groupName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        if (groupName == null || groupName.equals("")) {
            throw new IllegalArgumentException("Name is blank");
        }
        ArrayList<ClientData> clientMembers = new ArrayList<ClientData>();
        for (int cellNo = 16; cellNo < 250 && (clientName = ImportHandlerUtils.readAsString((int)cellNo, (Row)row)) != null; ++cellNo) {
            Long clientId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Clients"), (String)clientName);
            ClientData clientData = ClientData.emptyInstance((Long)clientId);
            if (this.containsClientId(clientMembers, clientId)) continue;
            clientMembers.add(clientData);
        }
        statuses.add(status);
        return GroupGeneralData.importInstance((String)groupName, clientMembers, (LocalDate)activationDate, (LocalDate)submittedOnDate, (Boolean)active, (String)externalId, (Long)officeId, (Long)staffId, (Long)centerId, (Integer)row.getRowNum(), (String)locale, (String)dateFormat);
    }

    private boolean containsClientId(List<ClientData> clientMembers, Long clientId) {
        for (ClientData client : clientMembers) {
            if (!client.getId().equals(clientId)) continue;
            return true;
        }
        return false;
    }

    private Count importEntity(Workbook workbook, List<GroupGeneralData> groups, List<CalendarData> meetings, List<String> statuses, String dateFormat) {
        Sheet groupSheet = workbook.getSheet("Groups");
        int successCount = 0;
        int errorCount = 0;
        int progressLevel = 0;
        String groupId = "";
        String errorMessage = "";
        for (int i = 0; i < groups.size(); ++i) {
            Row row = groupSheet.getRow(groups.get(i).getRowIndex().intValue());
            Cell errorReportCell = row.createCell(15);
            Cell statusCell = row.createCell(13);
            CommandProcessingResult result = null;
            try {
                String status = statuses.get(i);
                progressLevel = this.getProgressLevel(status);
                if (progressLevel == 0) {
                    result = this.importGroup(groups, i, dateFormat);
                    groupId = result.getGroupId().toString();
                    progressLevel = 1;
                } else {
                    groupId = Objects.requireNonNull(ImportHandlerUtils.readAsInt((int)14, (Row)groupSheet.getRow(groups.get(i).getRowIndex().intValue()))).toString();
                }
                if (meetings.get(i) != null && groups.get(i).getCenterId() == null) {
                    progressLevel = this.importGroupMeeting(meetings, Objects.requireNonNull(result), i, dateFormat);
                }
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
                continue;
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                this.writeGroupErrorMessage(workbook, groupId, errorMessage, progressLevel, statusCell, errorReportCell, row);
            }
        }
        this.setReportHeaders(groupSheet);
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    private void writeGroupErrorMessage(Workbook workbook, String groupId, String errorMessage, int progressLevel, Cell statusCell, Cell errorReportCell, Row row) {
        String status = "";
        if (progressLevel == 0) {
            status = "Creation failed";
        } else if (progressLevel == 1) {
            status = "Meeting failed";
        }
        statusCell.setCellValue(status);
        statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.RED));
        if (progressLevel > 0) {
            row.createCell(14).setCellValue((double)Integer.parseInt(groupId));
        }
        errorReportCell.setCellValue(errorMessage);
    }

    private void setReportHeaders(Sheet groupSheet) {
        ImportHandlerUtils.writeString((int)13, (Row)groupSheet.getRow(0), (String)"Status");
        ImportHandlerUtils.writeString((int)14, (Row)groupSheet.getRow(0), (String)"Group ID");
        ImportHandlerUtils.writeString((int)15, (Row)groupSheet.getRow(0), (String)"Failure Report");
    }

    private Integer importGroupMeeting(List<CalendarData> meetings, CommandProcessingResult result, int rowIndex, String dateFormat) {
        CalendarData calendarData = meetings.get(rowIndex);
        calendarData.setTitle("group_" + result.getGroupId().toString() + "_CollectionMeeting");
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        gsonBuilder.registerTypeAdapter(EnumOptionData.class, (Object)new EnumOptionDataValueSerializer());
        String payload = gsonBuilder.create().toJson((Object)calendarData);
        CommandWrapper commandWrapper = new CommandWrapper(result.getOfficeId(), result.getGroupId(), result.getClientId(), result.getLoanId(), result.getSavingsId(), null, null, null, null, null, payload, result.getTransactionId(), result.getProductId(), null, null, null, null, this.idempotencyKeyGenerator.create(), null);
        CommandWrapper commandRequest = new CommandWrapperBuilder().createCalendar(commandWrapper, "CENTER", result.getGroupId()).withJson(payload).build();
        this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return 2;
    }

    private CommandProcessingResult importGroup(List<GroupGeneralData> groups, int rowIndex, String dateFormat) {
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        Type clientCollectionType = new /* Unavailable Anonymous Inner Class!! */.getType();
        gsonBuilder.registerTypeAdapter(clientCollectionType, (Object)new ClientIdSerializer());
        String payload = gsonBuilder.create().toJson((Object)groups.get(rowIndex));
        CommandWrapper commandRequest = new CommandWrapperBuilder().createGroup().withJson(payload).build();
        return this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
    }

    private int getProgressLevel(String status) {
        if (status == null || status.equals("Creation failed")) {
            return 0;
        }
        if (status.equals("Meeting failed")) {
            return 1;
        }
        return 0;
    }
}

