/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.office;

import com.google.gson.GsonBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfficeImportHandler
implements ImportHandler {
    private static final Logger LOG = LoggerFactory.getLogger(OfficeImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @Autowired
    public OfficeImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List offices = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, offices, dateFormat);
    }

    private List<OfficeData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<OfficeData> offices = new ArrayList<OfficeData>();
        Sheet officeSheet = workbook.getSheet("Offices");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)officeSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = officeSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)10)) continue;
            offices.add(this.readOffice(row, locale, dateFormat));
        }
        return offices;
    }

    private OfficeData readOffice(Row row, String locale, String dateFormat) {
        String officeName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        Long parentId = ImportHandlerUtils.readAsLong((int)2, (Row)row);
        LocalDate openedDate = ImportHandlerUtils.readAsDate((int)3, (Row)row);
        String externalId = ImportHandlerUtils.readAsString((int)4, (Row)row);
        OfficeData office = OfficeData.importInstance((String)officeName, (Long)parentId, (LocalDate)openedDate, (ExternalId)ExternalIdFactory.produce((String)externalId));
        office.setImportFields(Integer.valueOf(row.getRowNum()), locale, dateFormat);
        return office;
    }

    private Count importEntity(Workbook workbook, List<OfficeData> offices, String dateFormat) {
        Sheet officeSheet = workbook.getSheet("Offices");
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat));
        int successCount = 0;
        int errorCount = 0;
        for (OfficeData office : offices) {
            try {
                String payload = gsonBuilder.create().toJson((Object)office);
                CommandWrapper commandRequest = new CommandWrapperBuilder().createOffice().withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = officeSheet.getRow(office.getRowIndex().intValue()).createCell(10);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)officeSheet, (Integer)office.getRowIndex(), (String)errorMessage, (int)10);
            }
        }
        officeSheet.setColumnWidth(10, 4000);
        ImportHandlerUtils.writeString((int)10, (Row)officeSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }
}

